<?php include('inc/template.php'); ?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="index.php">Home</a>
			</li>
			<li class="breadcrumb-item"><a href="flight_booking_list.php">Flight Booking List</a>
			</li>
			<li class="breadcrumb-item active">
				<?php echo isset($_GET['id']) ? 'Update Flight Booking' : 'Add Flight Booking'; ?>
			</li>
		</ol>
	</nav>
	<div class="row">
		<div class="col-9">
	<div class="card shadow p-4">
		<form id="flightBookingForm" method="post" enctype="multipart/form-data">
			<div class="row g-3">
				<div class="col-md-4">
					<label class="form-label">Booking Date</label>
					<input type="date" name="booking_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>"/>
				</div>

				<div class="col-md-8">
							<label for="customer_id" class="form-label">Customer Name</label>
							<input type="hidden" id="inquiry_id" name="inquiry_id" />
							<select name="customer_id" id="customer_id" required class="select2 form-select form-select-lg">
								<option value="">Select Customer</option>

								<!-- In-Progress Inquiry Customers -->
								<optgroup label="In-Progress Inquiries">
									<?php
									$inProgress = $conn->query( "SELECT c.id AS customer_id,c.name,c.phone, i.id AS inquiry_id FROM customers c INNER JOIN inquiries i ON c.id = i.customer_id AND i.inquiry_type = 'flight' AND i.status = 'in-progress' WHERE c.status = 'active' ORDER BY c.name ASC" );
									if ( $inProgress->num_rows > 0 ) {
										while ( $row = $inProgress->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="' . $row[ 'inquiry_id' ] . '">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>No in-progress inquiries</option>';
									}
									?>
								</optgroup>

								<!-- Other Customers (no in-progress inquiry) -->
								<optgroup label="Other Customers">
									<?php
									$others = $conn->query( "SELECT c.id AS customer_id, c.name, c.phone FROM customers c WHERE c.status = 'active' AND c.id NOT IN ( SELECT customer_id FROM inquiries WHERE status = 'in-progress' AND inquiry_type = 'package' ) ORDER BY c.name ASC" );
									if ( $others->num_rows > 0 ) {
										while ( $row = $others->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>All customers have in-progress inquiries</option>';
									}
									?>
								</optgroup>
							</select>

						</div>

				<div class="col-md-4">
					<label class="form-label">Flight Type</label>
					<select name="flight_type" id="flight_type" class="form-select" required>
						
						<option value="one_way">One Way</option>
						<option value="round_trip">Round Trip</option>
					</select>
				</div>

				<div class="col-md-4">
					<label class="form-label">From (City)</label>
					<input type="text" name="flight_from_city" id="flight_from_city" class="form-control" required>
				</div>

				<div class="col-md-4">
					<label class="form-label">To (City)</label>
					<input type="text" name="flight_to_city" id="flight_to_city" class="form-control" required>
				</div>

				<div class="col-md-4">
					<label class="form-label">Departure Flight Name</label>
					<input type="text" name="flight_departure_name" id="flight_departure_name" class="form-control" required>
				</div>
					<div class="col-md-4">
					<label class="form-label">Departure Flight No.</label>
					<input type="text" name="flight_departure_no" id="flight_departure_no" class="form-control" required>
				</div>
				<div class="col-md-4">
					<label class="form-label">Departure Date</label>
					<input type="date" name="flight_departure_date" id="flight_departure_date" class="form-control" required min="<?= date('Y-m-d'); ?>">
				</div>

				<div class="col-md-4 return-field">
  <label class="form-label">Return Date</label>
  <input type="date" name="flight_return_date" id="flight_return_date" class="form-control" min="<?= date('Y-m-d'); ?>">
</div>

<div class="col-md-4 return-field">
  <label class="form-label">Return Flight Name</label>
  <input type="text" name="flight_return_name" id="flight_return_name" class="form-control">
</div>

<div class="col-md-4 return-field">
  <label class="form-label">Return Flight No.</label>
  <input type="text" name="flight_return_no" id="flight_return_no" class="form-control">
</div>

				<div class="col-md-4">
					<label class="form-label">Flight Class</label>
					<select name="flight_class" id="flight_class" class="form-select" required>
					  <option value="">Select Flight Class</option>
   						<option value="economy">Economy</option>
    					<option value="business">Business Class</option>
    					<option value="first">First Class</option>
					</select>
				</div>
				 <div class="col-md-3">
    <label class="form-label">Adults</label>
    <select name="flight_adult" id="flight_adult" class="form-select">
      <?php for ($i = 1; $i <= 9; $i++): ?>
        <option value="<?= $i ?>"><?= $i ?></option>
      <?php endfor; ?>
    </select>
  </div>

  <div class="col-md-3">
    <label class="form-label">Children</label>
    <select name="flight_child" id="flight_child" class="form-select">
      <?php for ($i = 0; $i <= 9; $i++): ?>
        <option value="<?= $i ?>"><?= $i ?></option>
      <?php endfor; ?>
    </select>
  </div>

  <div class="col-md-3">
    <label class="form-label">Infants</label>
    <select name="flight_infant" id="flight_infant" class="form-select">
      <?php for ($i = 0; $i <= 9; $i++): ?>
        <option value="<?= $i ?>"><?= $i ?></option>
      <?php endfor; ?>
    </select>
  </div>

				<div class="col-md-3">
					<label class="form-label">Base Fare (INR)</label>
					<input type="number" name="transport_charges" id="transport_charges" class="form-control" min="0" value="0" required>
				</div>

				<div class="col-md-3">
					<label class="form-label">Other Charges (INR)</label>
					<input type="number" name="extra_charges" id="extra_charges" class="form-control" value="0">
				</div>

				<div class="col-md-3">
					<label class="form-label">Discount %</label>
					<input type="number" name="discount" id="discount" class="form-control" min="0" value="0">
				</div>

				<div class="col-md-3">
					<label class="form-label">With GST?</label>
					<select name="gst_included" id="gst_included" class="form-select">
						<option value="no">No</option>
						<option value="yes">Yes</option>
					</select>
					<input type="hidden" name="gst_rate" id="gst_rate" value="5">
				</div>

				<div class="col-md-3">
					<label class="form-label">Grand Total (INR)</label>
					<input type="text" name="grand_total" id="grand_total" class="form-control" readonly>
				</div>

				<!-- Payment Mode -->
				<div class="col-md-4">
					<label for="payment_mode" class="form-label">Payment Mode</label>
					<select name="payment_mode" id="payment_mode" class="form-select" required>
						<option value="">Select Mode</option>
						<option value="cash">Cash</option>
						<option value="upi">UPI</option>
						<option value="bank">Bank Transfer</option>
						<option value="card">Card</option>
						<option value="online">Online</option>
					</select>
				</div>

				<!-- UPI Details -->
				<div class="col-md-4" id="upi_details_group" style="display:none;">
					<label for="upi_id" class="form-label">UPI ID</label>
					<input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
				</div>

				<!-- Bank Details -->
				<div class="col-md-4" id="bank_details_group" style="display:none;">
					<label for="bank_name" class="form-label">Bank Name</label>
					<input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
				</div>

				<div class="col-md-4" id="account_no_group" style="display:none;">
					<label for="account_no" class="form-label">Account / Cheque No</label>
					<input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
				</div>

				<div class="col-md-4" id="transaction_id_group" style="display:none;">
					<label for="transaction_id" class="form-label">Transaction / Reference ID</label>
					<input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
				</div>

				<!-- Advance Payment -->
				<div class="col-md-4" id="advance_payment_group" style="display:none;">
					<label for="advance_payment" class="form-label">Advance Payment (INR)</label>
					<input type="number" name="advance_payment" id="advance_payment" class="form-control" min="1" placeholder="Enter amount">
				</div>




				<input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
				<input type="hidden" name="id" value="<?php echo $_GET['id'] ?? ''; ?>">
				<input type="hidden" name="created_by" value="<?php echo $userId; ?>">
			</div>

			<div class="mt-4">
				<button type="submit" class="btn btn-primary me-2">Save</button>
				<button type="button" id="download-pdf" class="btn btn-success me-2">Download PDF</button>
				<button type="reset" class="btn btn-secondary">Reset</button>
			</div>
		</form>
	</div>
</div>
<div class="col-3">
  <div class="card shadow p-4 sticky-card">
    <div class="row g-3">
      <h5>Flight Inquiry Detail</h5>

      <div class="col-md-12">
        <label class="form-label">From City</label>
        <input type="text" id="from_city" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">To City</label>
        <input type="text" id="to_city" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Departure</label>
        <input type="text" id="departure_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Return</label>
        <input type="text" id="return_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Passengers</label>
        <input type="text" id="passengers" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Class</label>
        <input type="text" id="fclass" class="form-control" readonly>
      </div>

        

      <div class="col-md-12">
        <label class="form-label">Remarks</label>
        <textarea id="remarks" class="form-control" rows="4" readonly></textarea>
      </div>
    </div>
  </div>
</div>
</div>
</div>

<script>
$(document).ready(function () {
	
// Hide all return fields initially
$('.return-field').hide();
$('#flight_return_date, #flight_return_name, #flight_return_no').prop('required', false);

// Toggle on flight type change
$('#flight_type').on('change', function () {
  const type = $(this).val();

  if (type === 'round_trip') {
    $('.return-field').show();
    $('#flight_return_date, #flight_return_name, #flight_return_no').prop('required', true);
  } else {
    $('.return-field').hide();
    $('#flight_return_date, #flight_return_name, #flight_return_no')
      .prop('required', false)
      .val('');
  }
});


  // ================================
  // Payment Mode Toggle
  // ================================
  $('#payment_mode').on('change', function () {
    const mode = $(this).val();

    // Hide all optional groups
    $('#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group').hide();
    $('#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment').prop('required', false).val('');

    if (mode === 'upi') {
      $('#upi_details_group, #transaction_id_group, #advance_payment_group').show();
      $('#upi_id, #transaction_id, #advance_payment').prop('required', true);
    } else if (mode === 'bank' || mode === 'card' || mode === 'online') {
      $('#bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group').show();
      $('#bank_name, #account_no, #transaction_id, #advance_payment').prop('required', true);
    } else if (mode === 'cash') {
      $('#advance_payment_group').show();
      $('#advance_payment').prop('required', true);
    }
  });

  // ================================
  // ðŸ”¹ Total Calculation
  // ================================
  function num(v) {
    return parseFloat(v) || 0;
  }

  function calculateFlightTotal() {
    const baseFare = num($('#transport_charges').val());
    const extra = num($('#extra_charges').val());
    const discount = num($('#discount').val());
    const gstIncluded = $('#gst_included').val();
    const gstRate = num($('#gst_rate').val());

    let total = baseFare + extra;

    if (discount > 0) total -= (total * discount / 100);
    if (gstIncluded === 'yes') total += (total * gstRate / 100);

    $('#grand_total').val(total.toFixed(2));
  }

  $(document).on('input change', '#transport_charges, #extra_charges, #discount, #gst_included', calculateFlightTotal);
  calculateFlightTotal(); // initial run

  // ================================
  // Customer  Fetch Inquiry Details (Flight)
  // ================================
  $('#customer_id').on('change', function () {
    const customerId = $(this).val();

    if (customerId) {
      $.ajax({
        url: 'ajax/fetchInquiryDetails.php',
        type: 'POST',
        data: { customer_id: customerId, type: 'flight' },
        dataType: 'json',
        beforeSend: function () {
          $('#inquiry_id,#flight_from_city, #flight_to_city, #flight_departure_date, #flight_return_date, #flight_passengers, #flight_class').val('');
        },
        success: function (res) {
          if (res.status === 'success') {
            const d = res.flight || {};

            function formatDate(dateStr) {
              if (!dateStr) return '';
              const parts = dateStr.split('-');
              return parts.length === 3 ? `${parts[2]}-${parts[1]}-${parts[0]}` : '';
            }

            $('#inquiry_id').val(d.inquiry_id || 0);
            $('#from_city').val(d.flight_from_city || '');
            $('#to_city').val(d.flight_to_city || '');
            $('#departure_date').val(formatDate(d.flight_departure_date));
            $('#return_date').val(formatDate(d.flight_return_date));
            $('#passengers').val(d.flight_passengers || '');
            $('#fclass').val(d.flight_class || '');
            $('#remarks').val(d.remarks || '');
          }
        },
        error: function () {
          toastr.error('Error fetching flight inquiry details.');
        }
      });
    } else {
      $('#inquiry_id,#flight_from_city, #flight_to_city, #flight_departure_date, #flight_return_date, #flight_passengers, #flight_class').val('');
    }
  });

  // ================================
  // ðŸ”¹ Form Submission + PDF Download
  // ================================
  let downloadPdfAfterSubmit = false;

  $('#download-pdf').click(function (e) {
    e.preventDefault();
    downloadPdfAfterSubmit = true;
    $('#flightBookingForm').submit();
  });

  $('#flightBookingForm').submit(function (e) {
    e.preventDefault();

    const payment = parseFloat($('#advance_payment').val() || 0);
    if (payment <= 0) {
      toastr.error('Advance payment must be greater than 0.');
      return false;
    }

    const formData = new FormData(this);

    $.ajax({
      url: 'controller/FlightBookingController.php',
      method: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function (response) {
        if (response.status === 'success') {
          toastr.success(response.message);

          if (downloadPdfAfterSubmit && response.id) {
            window.open('controller/DownloadPDFFlightBookingController.php?id=' + response.id, '_blank');
            downloadPdfAfterSubmit = false;
          }

          setTimeout(() => window.location.href = 'flight_booking_list.php', 1500);
        } else {
          toastr.error(response.message || 'Failed to save booking.');
        }
      },
      error: function (xhr, status, error) {
        toastr.error('An error occurred while submitting the form.');
        console.error('AJAX Error:', status, error, xhr.responseText);
      }
    });
  });
});
</script>

<?php include('inc/footer.php');?>