<?php
include __DIR__ . '/../inc/db.php';

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {

  // 🔹 List Financial Years
  case 'list':
    header('Content-Type: text/html');
    $res = $conn->query("SELECT * FROM financial_years ORDER BY id DESC");
//    if ($res->num_rows === 0) {
//      echo "<tr><td colspan='5' class='text-center text-muted'>No Financial Years Found</td></tr>";
//      exit;
//    }
    while ($row = $res->fetch_assoc()) {
     
    echo "
<tr>
  <td>{$row['year_label']}</td>
  <td>{$row['start_date']}</td>
  <td>{$row['end_date']}</td>
  <td>
    <label class='switch'>
      <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' ".($row['status'] === 'active' ? 'checked' : '').">
      <span class='switch-toggle-slider'>
        <span class='switch-on'></span>
        <span class='switch-off'></span>
      </span>
    </label>
  </td>
  <td>
    <button class='btn btn-sm btn-warning editBtn' data-id='{$row['id']}'><i class='far fa-edit'></i></button>
    <button class='btn btn-sm btn-danger deleteBtn' data-id='{$row['id']}'><i class='far fa-trash-alt'></i></button>
  </td>
</tr>";

    }
    exit;

  //  Add
  // 🔹 ADD
case 'add':
  $year_label = trim($_POST['year_label'] ?? '');
  $start_date = trim($_POST['start_date'] ?? '');
  $end_date   = trim($_POST['end_date'] ?? '');

  if (!$year_label || !$start_date || !$end_date) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required']);
    exit;
  }

  // ✅ Duplicate Check
  $check = $conn->prepare("SELECT id FROM financial_years WHERE year_label = ?");
  $check->bind_param("s", $year_label);
  $check->execute();
  $check->store_result();

  if ($check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'This financial year already exists']);
    exit;
  }

  // ✅ Insert Record
  $stmt = $conn->prepare("INSERT INTO financial_years (year_label, start_date, end_date, status) VALUES (?, ?, ?, 'active')");
  $stmt->bind_param("sss", $year_label, $start_date, $end_date);

  $success = $stmt->execute();
  echo json_encode([
    'status' => $success ? 'success' : 'error',
    'message' => $success ? 'Added successfully' : 'Failed to add'
  ]);
  exit;


  
// 🔹 UPDATE
case 'update':
  $id         = intval($_POST['id'] ?? 0);
  $year_label = trim($_POST['year_label'] ?? '');
  $start_date = trim($_POST['start_date'] ?? '');
  $end_date   = trim($_POST['end_date'] ?? '');

  if (!$year_label || !$start_date || !$end_date) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required']);
    exit;
  }

  // ✅ Prevent duplicate year_label for other records
  $check = $conn->prepare("SELECT id FROM financial_years WHERE year_label = ? AND id != ?");
  $check->bind_param("si", $year_label, $id);
  $check->execute();
  $check->store_result();

  if ($check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'This financial year already exists']);
    exit;
  }

  // ✅ Update Record
  $stmt = $conn->prepare("UPDATE financial_years SET year_label=?, start_date=?, end_date=? WHERE id=?");
  $stmt->bind_param("sssi", $year_label, $start_date, $end_date, $id);

  $success = $stmt->execute();
  echo json_encode([
    'status' => $success ? 'success' : 'error',
    'message' => $success ? 'Updated successfully' : 'Failed to update'
  ]);
  exit;

  //  Get for edit
  case 'getFinancialyear':
    $id = intval($_POST['id'] ?? 0);
    $res = $conn->query("SELECT * FROM financial_years WHERE id=$id");
    echo json_encode($res->fetch_assoc() ?: []);
    exit;

  

  //  Delete
  case 'deleteFinancialyear':
    $id = intval($_POST['id'] ?? 0);
    echo json_encode($conn->query("DELETE FROM financial_years WHERE id=$id")
      ? ['status' => 'success', 'message' => 'Deleted successfully']
      : ['status' => 'error', 'message' => 'Delete failed']);
    exit;

  //  Toggle
  case 'toggleStatus':
    $id = intval($_POST['id'] ?? 0);
    $status = ($_POST['status'] === 'true') ? 'active' : 'inactive';
    echo json_encode($conn->query("UPDATE financial_years SET status='$status' WHERE id=$id")
      ? ['status' => 'success', 'message' => 'Status updated']
      : ['status' => 'error', 'message' => 'Failed to update status']);
    exit;

  default:
    echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
    exit;
}
