<?php
// Enable errors for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

// Default response
$response = ['status' => 'error', 'message' => 'Something went wrong'];

// Get POST values
$id = $_POST['id'] ?? null;
$action = $_POST['action'] ?? '';

// ========================= CREATE / UPDATE =========================
if ($action === 'Create' || $action === 'Update') {
    $vehicle_type = trim($_POST['vehicle_type'] ?? '');
    $quantity = (int)($_POST['quantity'] ?? 1);

    // Basic validation
    if (empty($vehicle_type) || $quantity <= 0) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required and must be valid.']);
        exit;
    }

    if ($action === 'Create') {
        $stmt = $conn->prepare("INSERT INTO vehicles(vehicle_type, quantity) VALUES (?, ?)");
        $stmt->bind_param("si", $vehicle_type, $quantity);
        $response = $stmt->execute()
            ? ['status' => 'success', 'message' => 'Vehicle added successfully']
            : ['status' => 'error', 'message' => 'Failed to add vehicle'];
    } else {
        $stmt = $conn->prepare("UPDATE vehicles SET vehicle_type = ?, quantity = ? WHERE id = ?");
        $stmt->bind_param("sii", $vehicle_type, $quantity, $id);
        $response = $stmt->execute()
            ? ['status' => 'success', 'message' => 'Vehicle updated successfully']
            : ['status' => 'error', 'message' => 'Failed to update vehicle'];
    }

    echo json_encode($response);
    exit;
}

// ========================= SELECT =========================
if ($action === 'Select') {
    $stmt = $conn->prepare("SELECT * FROM vehicles WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $data = $stmt->get_result()->fetch_assoc();

    echo json_encode($data ? ['status' => 'success', 'data' => $data] : ['status' => 'error', 'message' => 'Vehicle not found']);
    exit;
}

// ========================= TOGGLE STATUS =========================
if ($action === 'ToggleStatus') {
    $stmt = $conn->prepare("SELECT status FROM vehicles WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $row = $stmt->get_result()->fetch_assoc();

    if (!$row) {
        echo json_encode(['status' => 'error', 'message' => 'Vehicle not found']);
        exit;
    }

    $new_status = $row['status'] === 'active' ? 'inactive' : 'active';
    $stmt = $conn->prepare("UPDATE vehicles SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $new_status, $id);
    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'Status updated', 'new_status' => $new_status]);
    exit;
}

// ========================= DELETE =========================
if ($action === 'Delete') {
    $stmt = $conn->prepare("DELETE FROM vehicles WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();

    echo json_encode(['status' => 'success', 'message' => 'Vehicle deleted successfully']);
    exit;
}

// ========================= DEFAULT RESPONSE =========================
echo json_encode($response);
