<?php 
include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$response = ['status' => 'error', 'message' => 'Invalid action'];

if ($action === 'save') {

    $payment_id   = $_POST['payment_id'] ?? 0; // For update
    $booking_id   = $_POST['booking_id'] ?? 0;
    $customer_id  = $_POST['customer_id'] ?? 0;
    $received_by  = $_POST['useridnew'] ?? 0;
    $amount       = floatval($_POST['received'] ?? 0);
    $mode         = $_POST['payment_mode'] ?? 'cash';
    $remarks      = trim($_POST['remarks'] ?? '');
    $upi_id       = trim($_POST['upi_id'] ?? '');
    $bank_name    = trim($_POST['bank_name'] ?? '');
    $account_no   = trim($_POST['account_no'] ?? '');
    $transaction_id = trim($_POST['transaction_id'] ?? '');

   
    // --- Transaction ID Auto ---
    if ($mode === 'upi' && empty($transaction_id)) {
        $transaction_id = 'UPI-' . time();
    } elseif (in_array($mode, ['bank', 'card', 'online']) && empty($transaction_id)) {
        $transaction_id = 'TXN-' . time();
    }

    // --- Fetch Booking Info ---
    $bq = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = '$booking_id'");
    if (!$bq || $bq->num_rows == 0) {
        echo json_encode(['status' => 'error', 'message' => 'Booking not found!']);
        exit;
    }

    $b = $bq->fetch_assoc();
    $current_due = $b['total_amount'] - $b['paid_amount'];

    // --- Validate amount ---
    if ($payment_id) {
        // Update Mode: Check difference
        $old = $conn->query("SELECT amount FROM payments WHERE id = '$payment_id'")->fetch_assoc();
        $diff = $amount - $old['amount'];
        if ($diff > $current_due) {
            echo json_encode(['status' => 'error', 'message' => 'Entered amount exceeds remaining due!']);
            exit;
        }
    } else {
        // New payment
        if ($amount > $current_due) {
            echo json_encode(['status' => 'error', 'message' => 'Entered amount exceeds remaining due!']);
            exit;
        }
    }

    // --- Helper Function ---
    function updateBookingStatus($conn, $booking_id) {
        $q = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = '$booking_id'");
        $b = $q->fetch_assoc();
        $due = $b['total_amount'] - $b['paid_amount'];
        $status = 'partial';
        if ($b['paid_amount'] >= $b['total_amount']) $status = 'paid';
        elseif ($b['paid_amount'] == 0) $status = 'unpaid';
        $conn->query("UPDATE bookings SET paid_amount = '$due', payment_status = '$status' WHERE id = '$booking_id'");
    }

    // --- UPDATE PAYMENT ---
    if ($payment_id) {
        $old = $conn->query("SELECT amount, booking_id FROM payments WHERE id = '$payment_id'")->fetch_assoc();
        $diff = $amount - $old['amount'];

        $sql = "
            UPDATE payments SET
                amount = '$amount',
                mode = '$mode',
                transaction_id = '$transaction_id',
                bank_name = '$bank_name',
                account_no = '$account_no',
                upi_id = '$upi_id',
                narration = '$remarks',
                received_by = '$received_by'
            WHERE id = '$payment_id'
        ";

        if ($conn->query($sql)) {
            $conn->query("UPDATE bookings SET paid_amount = paid_amount + $diff WHERE id = {$old['booking_id']}");
            updateBookingStatus($conn, $old['booking_id']);

            $response = ['status' => 'success', 'message' => 'Payment updated successfully!', 'payment_id' => $payment_id];
        } else {
            $response = ['status' => 'error', 'message' => $conn->error];
        }

    } else {
        // --- NEW PAYMENT ---
        function generateReceiptNo($conn) {
            $month = date('n');
            $year = date('Y');
            $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
            $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
            $nextNumber = 1;
            if ($res && $res->num_rows > 0) {
                $row = $res->fetch_assoc();
                preg_match('/(\d+)$/', $row['receipt_no'], $matches);
                $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
            }
            $formattedNo = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
            return "RC{$fy_short}-{$formattedNo}";
        }

        $receipt_no = generateReceiptNo($conn);

        $sql = "
            INSERT INTO payments 
            (booking_id, customer_id, payment_type, amount, mode, transaction_id, 
             receipt_no, reference_no, bank_name, account_no, upi_id, narration, received_by, 
             financial_year, status)
            VALUES (
                '$booking_id', '$customer_id', 'received', '$amount', '$mode', '$transaction_id',
                '$receipt_no', NULL, '$bank_name', '$account_no', '$upi_id', '$remarks',
                '$received_by', '$financial_year', 'completed'
            )
        ";

        if ($conn->query($sql)) {
            $conn->query("UPDATE bookings SET paid_amount = paid_amount + $amount WHERE id = $booking_id");
            updateBookingStatus($conn, $booking_id);

            // Recalculate remaining due
            $bnew = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = $booking_id")->fetch_assoc();
            $remaining_due = $bnew['total_amount'] - $bnew['paid_amount'];

            $response = [
                'status' => 'success',
                'message' => 'Payment saved successfully!',
                'payment_id' => $conn->insert_id,
                'remaining_due' => $remaining_due
            ];
        } else {
            $response = ['status' => 'error', 'message' => $conn->error];
        }
    }

}elseif ($action === 'Select') {
    $id = intval($_POST['id'] ?? 0);
    $res = $conn->query("SELECT * FROM payments WHERE id = $id");
    if ($res && $res->num_rows > 0) {
        $payment = $res->fetch_assoc();

        // Fetch booking info to get total amount or due
        $bq = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = {$payment['booking_id']}");
        $booking = $bq->fetch_assoc() ?? ['total_amount'=>0, 'paid_amount'=>0];

        $payment['total'] = $booking['total_amount'] - $booking['paid_amount'] + $payment['amount']; 
        // Add the current payment amount so editing shows correct total due

        $response = $payment;
    } else {
        $response = ['status' => 'error', 'message' => 'Payment not found'];
    }


} elseif ($action === 'Delete') {
    $id = intval($_POST['id']);
    $res = $conn->query("SELECT booking_id, amount FROM payments WHERE id = $id");
    if ($res->num_rows > 0) {
        $p = $res->fetch_assoc();
        $conn->query("UPDATE bookings SET paid_amount = paid_amount - {$p['amount']} WHERE id = {$p['booking_id']}");
    }

    $del = $conn->query("DELETE FROM payments WHERE id = $id");
    $response = $del 
        ? ['status' => 'success', 'message' => 'Payment deleted successfully!'] 
        : ['status' => 'error', 'message' => 'Failed to delete payment'];
}

echo json_encode($response);
?>
