<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Something went wrong'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'Create';
    $id = $_POST['id'] ?? null;
    $inclusions = $_POST['inclusions'] ?? '';
    $status = 'active';

    // Create
    if ($action === 'Create') {
        if (empty($inclusions)) {
            $response['message'] = 'Package Inclusions are required.';
            echo json_encode($response);
            exit;
        }

        $stmt = $conn->prepare("INSERT INTO packages_inclusions (inclusions, status, created_at) VALUES (?, ?, NOW())");
        $stmt->bind_param("ss", $inclusions, $status);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package Inclusions created successfully'];
        } else {
            $response['message'] = 'Failed to create Inclusions.';
        }
    }

    // Update
    elseif ($action === 'Update' && $id) {
        if (empty($inclusions)) {
            $response['message'] = 'Package Inclusions are required.';
            echo json_encode($response);
            exit;
        }

        $stmt = $conn->prepare("UPDATE packages_inclusions SET inclusions = ?, updated_at = NOW() WHERE id = ?");
        $stmt->bind_param("si", $inclusions, $id);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package Inclusions updated successfully'];
        } else {
            $response['message'] = 'Failed to update Inclusions.';
        }
    }

    // Select
    elseif ($_POST['action'] === 'Select') {
    $id = $_POST['id'];
    $query = mysqli_query($conn, "SELECT * FROM packages_inclusions WHERE id = '$id'");
    if ($row = mysqli_fetch_assoc($query)) {
        echo json_encode([
            'status' => 'success',
            'data' => [
                'id' => $row['id'],
                'inclusions' => $row['inclusions']
            ]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Data not found']);
    }
    exit;
}


    // Delete
    elseif ($action === 'Delete' && $id) {
        $stmt = $conn->prepare("DELETE FROM packages_inclusions WHERE id = ?");
        $stmt->bind_param("i", $id);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Inclusions deleted successfully'];
        } else {
            $response['message'] = 'Failed to delete package.';
        }
    }

    // Toggle Status
    elseif ($action === 'ToggleStatus' && $id) {
        // First get current status
        $stmt = $conn->prepare("SELECT status FROM packages_inclusions WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();

        if ($row) {
            $newStatus = ($row['status'] === 'active') ? 'inactive' : 'active';

            // Update status
            $updateStmt = $conn->prepare("UPDATE packages_inclusions SET status = ?, updated_at = NOW() WHERE id = ?");
            $updateStmt->bind_param("si", $newStatus, $id);

            if ($updateStmt->execute()) {
                $response = [
                    'status' => 'success',
                    'message' => 'Status toggled successfully',
                    'new_status' => $newStatus
                ];
            } else {
                $response['message'] = 'Failed to update status.';
            }
        } else {
            $response['message'] = 'Inclusion not found.';
        }
    }
}

echo json_encode($response);
?>
