<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Something went wrong'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $action = $_POST['action'] ?? '';
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

    // Fields common for Create/Update
    $package_name = trim($_POST['package_name'] ?? '');
    $destination = trim($_POST['destination'] ?? '');
    $destination_id = isset($_POST['destination_id']) ? (int)$_POST['destination_id'] : 0;
    $days = isset($_POST['days']) ? (int)$_POST['days'] : 0;
    $nights = isset($_POST['nights']) ? (int)$_POST['nights'] : 0;
    $purchase_price = isset($_POST['purchase_price']) ? (float)$_POST['purchase_price'] : 0;
    $sale_price = isset($_POST['sale_price']) ? (float)$_POST['sale_price'] : 0;
    $description = $_POST['description'] ?? '';
    $inclusions = $_POST['inclusions'] ?? '';
    $exclusions = $_POST['exclusions'] ?? '';
    $status = 'active';
	
	if ($action === 'getNextPackageCode') {
        $destination = trim($_POST['destination']);
        $prefix = strtoupper(substr($destination, 0, 3)); // e.g. KER

        $query = "SELECT package_code FROM packages 
                  WHERE BINARY package_code LIKE '$prefix%' 
                  ORDER BY id DESC LIMIT 1";
        $result = mysqli_query($conn, $query);

        if ($row = mysqli_fetch_assoc($result)) {
            $last_code = $row['package_code'];
            $num = (int)substr($last_code, 3);
            $next_num = $num + 1;
        } else {
            $next_num = 1;
        }

        $next_code = $prefix . str_pad($next_num, 3, '0', STR_PAD_LEFT);
        echo json_encode(['package_code' => $next_code]);
        exit; // ✅ stop here so the rest of the code doesn’t execute
    }

    // CREATE
    if ($action === 'Create') {
        if (empty($package_name) || empty($destination)) {
            echo json_encode(['status' => 'error', 'message' => 'All required fields must be valid.']);
            exit;
        }

        $stmt = $conn->prepare("
    INSERT INTO packages 
    (package_code, package_name, destination, destination_id, days, nights, purchase_price, sale_price, description, inclusions, exclusions, status, created_at)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
");
$stmt->bind_param(
    "sssiiddsssss",
    $_POST['package_code'], // ✅ include this from form
    $package_name,
    $destination,
    $destination_id,
    $days,
    $nights,
    $purchase_price,
    $sale_price,
    $description,
    $inclusions,
    $exclusions,
    $status
);


        $response = $stmt->execute()
            ? ['status' => 'success', 'message' => 'Package created successfully']
            : ['status' => 'error', 'message' => 'Failed to create package'];
        echo json_encode($response);
        exit;
    }

    // UPDATE
    elseif ($action === 'Update') {
        if (!$id) {
            echo json_encode(['status' => 'error', 'message' => 'Package ID is required for update']);
            exit;
        }

        if (empty($package_name) || empty($destination)) {
            echo json_encode(['status' => 'error', 'message' => 'All required fields must be valid.']);
            exit;
        }

        $stmt = $conn->prepare("
    UPDATE packages 
    SET package_code=?, package_name=?, destination=?, destination_id=?, days=?, nights=?, purchase_price=?, sale_price=?, 
        description=?, inclusions=?, exclusions=?, updated_at=NOW()
    WHERE id=?
");
$stmt->bind_param(
    "sssiiiddsssi",
    $_POST['package_code'], // ✅ include this
    $package_name,
    $destination,
    $destination_id,
    $days,
    $nights,
    $purchase_price,
    $sale_price,
    $description,
    $inclusions,
    $exclusions,
    $id
);


        $response = $stmt->execute()
            ? ['status' => 'success', 'message' => 'Package updated successfully']
            : ['status' => 'error', 'message' => 'Failed to update package'];
        echo json_encode($response);
        exit;
    }

    // SELECT
    elseif ($action === 'Select') {
        if (!$id) {
            echo json_encode(['status' => 'error', 'message' => 'Package ID is required']);
            exit;
        }

        $stmt = $conn->prepare("SELECT * FROM packages WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();

        $response = $result
            ? ['status' => 'success', 'data' => $result]
            : ['status' => 'error', 'message' => 'Package not found'];
        echo json_encode($response);
        exit;
    }

    // TOGGLE STATUS
    elseif ($action === 'ToggleStatus') {
        if (!$id) {
            echo json_encode(['status' => 'error', 'message' => 'Package ID is required']);
            exit;
        }

        $stmt = $conn->prepare("SELECT status FROM packages WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();

        if (!$result) {
            echo json_encode(['status' => 'error', 'message' => 'Package not found']);
            exit;
        }

        $new_status = ($result['status'] === 'active') ? 'inactive' : 'active';
        $stmt = $conn->prepare("UPDATE packages SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $new_status, $id);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Status updated successfully', 'new_status' => $new_status]);
        exit;
    }

    // DELETE
    elseif ($action === 'Delete') {
        if (!$id) {
            echo json_encode(['status' => 'error', 'message' => 'Package ID is required']);
            exit;
        }

        $stmt = $conn->prepare("DELETE FROM packages WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Package deleted successfully']);
        exit;
    }
	
	
}

echo json_encode($response);
?>
