<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
include '../inc/db.php';
// Financial Year


$action = $_POST['action'] ?? '';
$id = intval($_POST['id'] ?? 0);

function responseJSON($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

/* =======================================================
   🔹 CREATE BOOKING
   ======================================================= */
if ($action === 'Create') { 

    $customer_id       = intval($_POST['customer_id']);
    $booking_date      = $_POST['booking_date'] ?? date('Y-m-d');
    $inquiry_id        = intval($_POST['inquiry_id'] ?? 0);
	$category_id        = intval($_POST['category_id'] ?? 0);
	$package_id        = intval($_POST['package_id'] ?? 0);
    $package_start_date = $_POST['package_start_date'];
    $package_end_date   = $_POST['package_end_date'];
	$meal_plan          = $conn->real_escape_string($_POST['meal_plan'][0] ?? '');
    $accommodation_type = $conn->real_escape_string($_POST['accommodation_type'] ?? '');
    $room_type          = $conn->real_escape_string($_POST['room_type'] ?? '');
	$vehicle_type       = $conn->real_escape_string($_POST['transport_type'] ?? '');
    $package_adults     = intval($_POST['adults']);
    $package_children   = intval($_POST['child']);
	$package_extrabed   = intval($_POST['extrabed']);
    $adult_price        = floatval($_POST['adult_price']);
    $child_price        = floatval($_POST['child_price']);
    $extra_bed_price    = floatval($_POST['extra_bed_price']);
    $transport_charges  = floatval($_POST['transport_charges']);
    $extra_charges      = floatval($_POST['extra_charges'] ?? 0);
    $discount           = floatval($_POST['discount']);
    $gst_included       = $_POST['gst_included'] ?? 'no';
    $advance_payment    = floatval($_POST['advance_payment']);
    $payment_mode       = $_POST['payment_mode'] ?? 'cash';
    $useridnew          = intval($_POST['useridnew']);
    $special_request    = $conn->real_escape_string($_POST['special_request'] ?? '');
    $status             = 'confirmed';

    // --- Payment details (mode-specific fields)
	
    $upi_id         = $_POST['upi_id'] ?? null;
    $bank_name      = $_POST['bank_name'] ?? null;
    $account_no     = $_POST['account_no'] ?? null;
    $transaction_id = $_POST['transaction_id'] ?? null;
    // Generate booking code
    // Company prefix
$prefix = "MTT/";

// Determine current financial year (April–March)
$yearStart = (date('n') >= 4) ? date('y') : date('y') - 1;
$yearEnd   = $yearStart + 1;
$financialYear = $yearStart . '-' . $yearEnd;

// Fetch last booking number for this financial year
$codeQuery = $conn->query("
    SELECT booking_code FROM bookings 
    WHERE booking_code LIKE '%$financialYear%' 
    ORDER BY id DESC LIMIT 1
");

if ($codeQuery && $codeQuery->num_rows > 0) {
    $lastCode = $codeQuery->fetch_assoc()['booking_code'];
    preg_match('/(\d+)$/', $lastCode, $matches);
    $nextNumber = isset($matches[1]) ? intval($matches[1]) + 1 : 1;
} else {
    $nextNumber = 1;
}

// Format new booking code
$booking_code = sprintf("%s%s/%04d", $prefix, $financialYear, $nextNumber);
	

    // --- Get package name
    $pkgRes = $conn->query("SELECT package_name FROM packages WHERE id='$package_id' LIMIT 1");
    $package_name = ($pkgRes && $pkgRes->num_rows > 0) ? $pkgRes->fetch_assoc()['package_name'] : '';

   // --- Base Calculation ---
$base = ($package_adults * $adult_price)
      + ($package_children * $child_price)
      + ($extra_bed_price * intval($_POST['extrabed']));

$discount_amt = ($discount > 0) ? ($base * $discount / 100) : 0;
$after_discount = $base - $discount_amt;

$gst_rate = 5; // example 5%

if ($gst_included === 'yes') {
    // GST already included ? extract GST portion
    $gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
    $base_with_gst = round($after_discount + $gst_amount, 2);
    $total = round($base_with_gst + $transport_charges + $extra_charges, 2);
} else {
    // GST not included ? do NOT add GST
    $gst_amount = 0;
    $base_without_gst = round($after_discount, 2);
    $total = round($base_without_gst + $transport_charges + $extra_charges, 2);
}

    $payment_status = ($advance_payment >= $total) ? 'paid' : (($advance_payment > 0) ? 'partial' : 'unpaid');

    $sql = "
        INSERT INTO bookings (
          inquiry_id, customer_id, booking_type, booking_code, booking_date,category_id,package_id,
          package_name, package_start_date, package_end_date,meal_plan,accommodation_type,room_type, package_adults, package_children,package_extrabed,
          adult_price, child_price, extra_bed_price,vehicle_type, transport_charges, extra_charges,
          discount, gst_rate, gst_amount, gst_included, discount_amount,
          total_amount, paid_amount, payment_status, status, payment_mode,
          special_request, created_by, financial_year
        ) VALUES (
          '$inquiry_id', '$customer_id', 'package', '$booking_code', NOW(),
          '$category_id','$package_id','$package_name', '$package_start_date', '$package_end_date','$meal_plan','$accommodation_type','$room_type', '$package_adults', '$package_children','$package_extrabed',
          '$adult_price', '$child_price', '$extra_bed_price','$vehicle_type', '$transport_charges', '$extra_charges',
          '$discount', '$gst_rate', '$gst_amount', '$gst_included', '$discount_amt',
          '$total', '$advance_payment', '$payment_status', '$status', '$payment_mode',
          '$special_request', '$useridnew', '$financial_year'
        )
    ";


    if (mysqli_query($conn, $sql)) {
        $booking_id = $conn->insert_id;
		
		// --- NEW PAYMENT ---
        function generateReceiptNo($conn) {
            $month = date('n');
            $year = date('Y');
            $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
            $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
            $nextNumber = 1;
            if ($res && $res->num_rows > 0) {
                $row = $res->fetch_assoc();
                preg_match('/(\d+)$/', $row['receipt_no'], $matches);
                $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
            }
            $formattedNo = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
            return "RC{$fy_short}-{$formattedNo}";
        }

        $receipt_no = generateReceiptNo($conn);

        // 💰 Insert payment record if advance paid
        if ($advance_payment > 0) {
            $p_sql = "INSERT INTO payments 
            (booking_id, customer_id, payment_type, amount, mode, transaction_id, 
             receipt_no, reference_no, bank_name, account_no, upi_id, narration, received_by, 
             financial_year, status)
            VALUES (
                '$booking_id', '$customer_id', 'received', '$advance_payment', '$payment_mode', '$transaction_id',
                '$receipt_no', NULL, '$bank_name', '$account_no', '$upi_id', 'Package Booked',
                '$useridnew', '$financial_year', 'completed'
            )
                
            ";

            mysqli_query($conn, $p_sql);
        }
		
		if (!empty($inquiry_id) && $inquiry_id > 0) {
        $conn->query("UPDATE inquiries SET status = 'closed' WHERE id = '$inquiry_id'");
    }

        responseJSON('success', 'Booking created successfully.', [
            'id' => $booking_id,
            'gst_included' => $gst_included
        ]);
    } else {
        responseJSON('error', 'Failed to create booking: ' . mysqli_error($conn));
    }
}

/* =======================================================
   UPDATE BOOKING
   ======================================================= */
elseif ($action === 'Update' && $id > 0) { 

    // --- Get posted fields
    $category_id        = intval($_POST['category_id'] ?? 0);
    $package_id         = intval($_POST['package_id'] ?? 0);
    $package_start_date = $_POST['package_start_date'];
    $package_end_date   = $_POST['package_end_date'];
    $meal_plan          = $conn->real_escape_string($_POST['meal_plan'][0] ?? '');
    $accommodation_type = $conn->real_escape_string($_POST['accommodation_type'] ?? '');
    $room_type          = $conn->real_escape_string($_POST['room_type'] ?? '');
	$vehicle_type       = $conn->real_escape_string($_POST['transport_type'] ?? '');
    $package_adults     = intval($_POST['adults']);
    $package_children   = intval($_POST['child']);
	$package_extrabed   = intval($_POST['extrabed']);
    $adult_price        = floatval($_POST['adult_price']);
    $child_price        = floatval($_POST['child_price']);
    $extra_bed_price    = floatval($_POST['extra_bed_price']);
    $transport_type     = $conn->real_escape_string($_POST['transport_type'] ?? '');
    $transport_charges  = floatval($_POST['transport_charges']);
    $extra_charges      = floatval($_POST['extra_charges'] ?? 0);
    $discount           = floatval($_POST['discount']);
    $gst_included       = $_POST['gst_included'] ?? 'no';
    $gst_rate           = floatval($_POST['gst'] ?? 5);
    $advance_payment    = floatval($_POST['advance_payment']);
    $payment_mode       = $_POST['payment_mode'] ?? 'cash';
    $useridnew          = intval($_POST['useridnew']);
    $customer_id        = intval($_POST['customer_id']);
    $special_request    = $conn->real_escape_string($_POST['special_request'] ?? '');
    $booking_notes      = $conn->real_escape_string($_POST['booking_notes'] ?? '');
    $status             = 'confirmed';

    // --- Calculations
    $base = ($package_adults * $adult_price)
          + ($package_children * $child_price)
          + ($extra_bed_price * $package_extrabed)
          + $transport_charges
          + $extra_charges;

    $discount_amt = ($discount > 0) ? ($base * $discount / 100) : 0;
    $after_discount = $base - $discount_amt;

    if ($gst_included === 'yes') {
        $gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
        $base_without_gst = round($after_discount - $gst_amount, 2);
        $total = $after_discount; // already includes GST
    } else {
        $gst_amount = 0;
        $base_without_gst = round($after_discount, 2);
        $total = $base_without_gst; // no GST added
    }

    $payment_status = ($advance_payment >= $total) ? 'paid' : (($advance_payment > 0) ? 'partial' : 'unpaid');

    // --- Update booking record
    $stmt = $conn->prepare("
        UPDATE bookings SET
            category_id=?, package_id=?, package_start_date=?, package_end_date=?,
            meal_plan=?, accommodation_type=?, room_type=?, package_adults=?, package_children=?, package_extrabed=?,
            adult_price=?, child_price=?, extra_bed_price=?,vehicle_type=?, transport_type=?, transport_charges=?, extra_charges=?,
            discount=?, discount_amount=?, gst_rate=?, gst_amount=?, gst_included=?,
            total_amount=?, paid_amount=?, payment_status=?, payment_mode=?, special_request=?, booking_notes=?,
            updated_at=NOW(), updated_by=?
        WHERE id=?
    ");

    $stmt->bind_param(
        "iisssssiiidddssdidddsddssssii",
        $category_id, $package_id, $package_start_date, $package_end_date,
        $meal_plan, $accommodation_type, $room_type, $package_adults, $package_children, $package_extrabed,
        $adult_price, $child_price, $extra_bed_price, $transport_type, $transport_charges, $extra_charges,
        $discount, $discount_amt, $gst_rate, $gst_amount, $gst_included,
        $total, $advance_payment, $payment_status, $payment_mode, $special_request, $booking_notes,
        $useridnew, $id
    );

    if ($stmt->execute()) {
        // Remove old payments
        $conn->query("DELETE FROM payments WHERE booking_id = '$id'");

        // Reinsert updated advance payment
        if ($advance_payment > 0) {
            $pstmt = $conn->prepare("
                INSERT INTO payments (booking_id, customer_id, amount, mode, payment_type, received_by)
                VALUES (?, ?, ?, ?, 'received', ?)
            ");
            $pstmt->bind_param('iidss', $id, $customer_id, $advance_payment, $payment_mode, $useridnew);
            $pstmt->execute();
        }

        responseJSON('success', 'Booking updated successfully.', ['id' => $id]);
    } else {
        responseJSON('error', 'Failed to update booking: ' . $stmt->error);
    }
}


/* =======================================================
   🔹 SELECT BOOKING
   ======================================================= */
elseif ($action === 'Select' && $id > 0) {
    $result = $conn->query("SELECT * FROM bookings WHERE id='$id' LIMIT 1");
    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_assoc();
        responseJSON('success', 'Booking fetched successfully.', ['data' => $data]);
    } else {
        responseJSON('error', 'Booking not found.');
    }
}

/* =======================================================
    FETCH FOR DATATABLE
   ======================================================= */
elseif ($action === 'fetch') {
    $draw   = intval($_POST['draw'] ?? 1);
    $start  = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 25);
    $search = $_POST['search']['value'] ?? '';

    // ? Base filter (package type only)
    $where = "WHERE b.booking_type = 'package'";

    // ? Search filter
    if (!empty($search)) {
        $search = $conn->real_escape_string($search);
        $where .= " AND (
            b.booking_code LIKE '%$search%' OR
            b.package_name LIKE '%$search%' OR
            c.name LIKE '%$search%' OR
            c.phone LIKE '%$search%' OR
            cat.name LIKE '%$search%'
        )";
    }

    // ? Total records
    $totalQuery = $conn->query("SELECT COUNT(*) AS total FROM bookings WHERE booking_type = 'package'");
    $totalData  = $totalQuery->fetch_assoc()['total'];

    // ? Main query with category join and payment info
    $query = "
        SELECT 
            b.id, b.customer_id, b.booking_code, b.booking_date,
            b.package_name, b.package_start_date, b.package_end_date,
            b.total_amount, b.paid_amount,
            (b.total_amount - b.paid_amount) AS due_amount,
            c.name AS customer_name, c.phone AS customer_phone,
            cat.category_name,
            p.last_payment_date, p.last_payment_type, p.last_payment_amount
        FROM bookings b
        LEFT JOIN customers c ON c.id = b.customer_id
        LEFT JOIN package_categories cat ON cat.id = b.category_id
        LEFT JOIN (
            SELECT 
                booking_id,
                MAX(payment_date) AS last_payment_date,
                SUBSTRING_INDEX(GROUP_CONCAT(payment_type ORDER BY payment_date DESC), ',', 1) AS last_payment_type,
                SUBSTRING_INDEX(GROUP_CONCAT(amount ORDER BY payment_date DESC), ',', 1) AS last_payment_amount
            FROM payments
            WHERE status = 'completed'
            GROUP BY booking_id
        ) p ON p.booking_id = b.id
        $where
        ORDER BY b.id DESC
        LIMIT $start, $length
    ";

    $result = $conn->query($query);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $due   = floatval($row['due_amount']);
        $total = floatval($row['total_amount']);

        // ? Payment status badge
        if ($due <= 0) {
            $statusBadge = '<span class="badge bg-success">Paid</span>';
            $paymentBtn = '';
        } else {
            $statusBadge = ($due < $total)
                ? '<span class="badge bg-warning text-dark">Partial</span>'
                : '<span class="badge bg-danger">Unpaid</span>';

            $paymentBtn = '
                <div class="mb-1">
                    <button class="btn btn-xs btn-success changeStatusBtn" 
                        data-id="' . $row['id'] . '" 
                        data-customer_id="' . $row['customer_id'] . '" 
                        data-total_amount="' . $row['total_amount'] . '"
						data-balance_amount="' . $row['due_amount'] . '" 
                        data-gst_included="yes"
                        title="Add Payment">
                        <i class="far fa-rupee-sign"></i>
                    </button>
                </div>';

            if (!empty($row['last_payment_date'])) {
                $statusBadge .= '<br>
                    <small class="text-muted">
                        Last: ' . date('d-m-Y', strtotime($row['last_payment_date'])) . '<br>
                        ' . ucfirst($row['last_payment_type']) . ': ' . number_format($row['last_payment_amount'], 2) . '
                    </small>';
            }
        }

        // ? Action buttons
        $actions = '
            ' . $paymentBtn . '
            <button class="btn btn-xs btn-info download" data-id="' . $row['id'] . '" title="Download PDF">
                <i class="far fa-file-pdf"></i>
            </button>
            <button class="btn btn-xs btn-danger delete" id="' . $row['id'] . '" title="Delete Booking">
                <i class="far fa-trash-alt"></i>
            </button>
        ';

        // ? Row output
        $data[] = [
            'booking_date'   => !empty($row['booking_date']) ? date('d-m-Y', strtotime($row['booking_date'])) : '',
            'booking_code'   => htmlspecialchars($row['booking_code'] ?? ''),
            'customer_name'  => '<a href="package_booking_details.php?book_id=' . intval($row['id']) . '">'
                     . ($row['customer_name'] ?? '') . 
                   '</a>',
            'customer_phone' => htmlspecialchars($row['customer_phone'] ?? ''),
            'category'       => htmlspecialchars($row['category_name'] ?? ''),
            'package_name'   => htmlspecialchars($row['package_name'] ?? ''),
            'package_start'  => !empty($row['package_start_date']) ? date('d-m-Y', strtotime($row['package_start_date'])) : '',
            'package_end'    => !empty($row['package_end_date']) ? date('d-m-Y', strtotime($row['package_end_date'])) : '',
            'total_amount'   => number_format($row['total_amount'], 2),
            'due_amount'     => number_format($row['due_amount'], 2),
            'payment_status' => $statusBadge,
            'action'         => $actions
        ];
    }

    echo json_encode([
        'draw'            => $draw,
        'recordsTotal'    => $totalData,
        'recordsFiltered' => !empty($search) ? count($data) : $totalData,
        'data'            => $data
    ]);
    exit;
}


/* =======================================================
   💳 SAVE PAYMENT (Add Payment Modal)
   ======================================================= */
elseif ($action === 'savepayment') {
    $booking_id   = intval($_POST['booking_id'] ?? 0);
    $customer_id  = intval($_POST['customer_id'] ?? 0);
    $amount       = floatval($_POST['amount'] ?? 0);
    $mode         = $conn->real_escape_string($_POST['mode'] ?? 'cash');
    $upi_id       = $conn->real_escape_string($_POST['upi_id'] ?? '');
    $reference_no = $conn->real_escape_string($_POST['reference_no'] ?? '');
    $bank_name    = $conn->real_escape_string($_POST['bank_name'] ?? '');
    $narration    = $conn->real_escape_string($_POST['narration'] ?? '');
    $received_by  = intval($_POST['received_by'] ?? 0);

    if ($booking_id <= 0 || $amount <= 0) {
        responseJSON('error', 'Invalid booking or amount.');
    }

    $stmt = $conn->prepare("
        INSERT INTO payments 
        (booking_id, customer_id, amount, mode, upi_id, reference_no, bank_name, narration, payment_type, received_by, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'received', ?, NOW())
    ");
    $stmt->bind_param('iidsssssi', $booking_id, $customer_id, $amount, $mode, $upi_id, $reference_no, $bank_name, $narration, $received_by);

    if ($stmt->execute()) {
        $payment_id = $conn->insert_id;
        $conn->query("UPDATE bookings SET paid_amount = paid_amount + $amount WHERE id = $booking_id");

        responseJSON('success', 'Payment added successfully.', ['payment_id' => $payment_id]);
    } else {
        responseJSON('error', 'Failed to save payment: ' . $conn->error);
    }
}

/* =======================================================
   ❌ DELETE BOOKING
   ======================================================= */
elseif ($action === 'Delete' && $id > 0) {
    $conn->query("DELETE FROM payments WHERE booking_id = '$id'");
    $conn->query("DELETE FROM bookings WHERE id = '$id'");
    responseJSON('Delete', 'Booking deleted successfully.');
}

/* =======================================================
   ⚠️ INVALID ACTION
   ======================================================= */
else {
    responseJSON('error', 'Invalid action or missing parameters.');
}
?>
