<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();

include __DIR__ . '/../inc/db.php'; // adjust path if needed

$action = $_POST['action'] ?? '';

if ($action === 'insert') {
    $inquiry_id = intval($_POST['inquiry_id']);
    $followup_date = date('Y-m-d H:i:s');
    $followup_mode = $_POST['followup_mode'];
    $remarks = $_POST['followup_remarks'];
    $status = $_POST['followup_status'];
    $next_followup_date = !empty($_POST['reschedule_date']) ? $_POST['reschedule_date'] : null;
    $followed_by = $_POST['user_id'] ?? ($_SESSION['user_id'] ?? 1);

    $stmt = $conn->prepare("INSERT INTO inquiry_followups 
      (inquiry_id, followup_date, followup_mode, remarks, status, next_followup_date, followed_by)
      VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssssi", $inquiry_id, $followup_date, $followup_mode, $remarks, $status, $next_followup_date, $followed_by);

    if ($stmt->execute()) {
        // Update inquiry main table
        // Determine new inquiry status based on follow-up
        if ($status === 'done') {
            $inquiry_status = 'in-progress'; // or 'closed' if you want to mark inquiry completed
        } elseif ($status === 'closed') {
            $inquiry_status = 'closed';
        } else {
            $inquiry_status = 'pending';
        }
        $updateQuery = "UPDATE inquiries 
                        SET status = ?, 
                            last_followup_date = ?, 
                            next_followup_date = ?
                        WHERE id = ?";
        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bind_param("sssi", $inquiry_status, $followup_date, $next_followup_date, $inquiry_id);
        $updateStmt->execute();

        echo json_encode(['success' => true, 'message' => 'Follow-up saved successfully!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to save follow-up.']);
    }
    exit;
}

if ($action === 'fetch') {
    $inquiry_id = intval($_POST['inquiry_id']);

    $query = "SELECT f.followup_date, f.followup_mode, f.remarks, f.status, f.next_followup_date, 
                     COALESCE(u.name, 'System') AS followed_by_name
              FROM inquiry_followups f
              LEFT JOIN users u ON f.followed_by = u.id
              WHERE f.inquiry_id = ?
              ORDER BY f.followup_date DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $inquiry_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = [
            'followup_date' => date('d-m-Y H:i', strtotime($row['followup_date'])),
            'followup_mode' => ucfirst($row['followup_mode']),
            'remarks' => htmlspecialchars($row['remarks']),
            'status' => ucfirst($row['status']),
            'next_followup_date' => !empty($row['next_followup_date']) ? date('d-m-Y', strtotime($row['next_followup_date'])) : '-',
            'followed_by_name' => ucwords($row['followed_by_name'])
        ];
    }

    echo json_encode($data);
    exit;
}
?>
