<?php
// HotelController.php
header('Content-Type: application/json');
include '../inc/db.php'; // adjust path to your db.php

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? 0;

$response = ['status' => 'error', 'message' => 'Invalid action'];

try {

    // ================= Create/Update Hotel =================
    if ($action === 'Create' || $action === 'Update') {
        $hotel_name = $_POST['hotel_name'] ?? '';
        $city_id    = $_POST['city_id'] ?? '';
        $address    = $_POST['address'] ?? '';
        $stars      = $_POST['stars'] ?? '';
        $status     = 'active';

        if (!$hotel_name || !$city_id || !$stars) {
            throw new Exception('Please fill all required fields.');
        }

        if ($action === 'Create') {
            $stmt = $conn->prepare("INSERT INTO hotels (hotel_name, city_id, address, stars, status, created_at, updated_at) VALUES (?, ?, ?, ?, ?, NOW(), NOW())");
            $stmt->bind_param("sisis", $hotel_name, $city_id, $address, $stars, $status);
            $stmt->execute();
            $stmt->close();

            $response = ['status' => 'success', 'message' => 'Hotel created successfully'];
        } else { // Update
            $stmt = $conn->prepare("UPDATE hotels SET hotel_name=?, city_id=?, address=?, stars=?, updated_at=NOW() WHERE id=?");
            $stmt->bind_param("sisii", $hotel_name, $city_id, $address, $stars, $id);
            $stmt->execute();
            $stmt->close();

            $response = ['status' => 'success', 'message' => 'Hotel updated successfully'];
        }
    }

    // ================= Select Single Hotel =================
    elseif ($action === 'Select') {
        $stmt = $conn->prepare("SELECT h.id, h.hotel_name, h.city_id, c.city_name, h.address, h.stars 
                                FROM hotels h 
                                LEFT JOIN cities c ON h.city_id = c.id 
                                WHERE h.id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res->num_rows > 0) {
            $data = $res->fetch_assoc();
            $response = ['status' => 'success', 'data' => $data];
        } else {
            $response = ['status' => 'error', 'message' => 'Hotel not found'];
        }
        $stmt->close();
    }

    // ================= Delete Hotel =================
    elseif ($action === 'Delete') {
        $stmt = $conn->prepare("DELETE FROM hotels WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        $response = ['status' => 'success', 'message' => 'Hotel deleted successfully'];
    }

    // ================= Toggle Status =================
    elseif ($action === 'ToggleStatus') {
        $stmt = $conn->prepare("SELECT status FROM hotels WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res->num_rows > 0) {
            $row = $res->fetch_assoc();
            $new_status = $row['status'] === 'active' ? 'inactive' : 'active';
            $stmt->close();

            $stmt = $conn->prepare("UPDATE hotels SET status=?, updated_at=NOW() WHERE id=?");
            $stmt->bind_param("si", $new_status, $id);
            $stmt->execute();
            $stmt->close();

            $response = ['status' => 'success', 'message' => 'Status updated', 'new_status' => $new_status];
        } else {
            $response = ['status' => 'error', 'message' => 'Hotel not found'];
        }
    }

    // ================= Server-side DataTable List =================
elseif ($action === 'List') {
    // Columns correspond to DataTable columns: hotel_name, address, destination(city_name), stars, status
    $columns = ['h.hotel_name', 'h.address', 'c.city_name', 'h.stars', 'h.status'];

    $draw = intval($_POST['draw'] ?? 1);
    $start = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 25);
    $orderCol = intval($_POST['order'][0]['column'] ?? 0);
    $orderDir = $_POST['order'][0]['dir'] ?? 'asc';
    $searchValue = $_POST['search']['value'] ?? '';

    // Total records
    $totalRecords = $conn->query("SELECT COUNT(*) as cnt FROM hotels")->fetch_assoc()['cnt'];

    // Base query
    $sql = "SELECT h.id, h.hotel_name, h.address, c.city_name AS destination, h.stars, h.status
            FROM hotels h
            LEFT JOIN cities c ON h.city_id = c.id
            WHERE 1";

    // Search filter
    if ($searchValue) {
        $searchValue = $conn->real_escape_string($searchValue);
        $sql .= " AND (h.hotel_name LIKE '%$searchValue%' OR h.address LIKE '%$searchValue%' OR c.city_name LIKE '%$searchValue%')";
    }

    // Total filtered
    $totalFilteredQuery = str_replace(
        "SELECT h.id, h.hotel_name, h.address, c.city_name AS destination, h.stars, h.status",
        "SELECT COUNT(*) as cnt",
        $sql
    );
    $totalFiltered = $conn->query($totalFilteredQuery)->fetch_assoc()['cnt'];

    // Ordering & limit
    $sql .= " ORDER BY {$columns[$orderCol]} $orderDir LIMIT $start, $length";
    $result = $conn->query($sql);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $statusBtn = '<label class="switch">
            <input type="checkbox" class="switch-input" value="'.$row['id'].'" '.($row['status'] === 'active' ? 'checked' : '').' onClick="statusChange(this.value);" />
            <span class="switch-toggle-slider">
                <span class="switch-on"></span>
                <span class="switch-off"></span>
            </span>
        </label>';

        $actionBtn = '
            <button type="button" class="btn btn-sm btn-warning" onclick="location.href=\'hotel_add.php?id='.$row['id'].'\'">
                <i class="far fa-edit"></i>
            </button>
            <button type="button" class="btn btn-sm btn-danger delete" id="'.$row['id'].'">
                <i class="far fa-trash-alt"></i>
            </button>';

        $row['status'] = $statusBtn;
        $row['action'] = $actionBtn;

        $data[] = $row;
    }

    $response = [
        "draw" => $draw,
        "recordsTotal" => intval($totalRecords),
        "recordsFiltered" => intval($totalFiltered),
        "data" => $data
    ];

    echo json_encode($response);
    exit;
}
// ========================= Add or Update Package Hotel =========================
// ========================= Save or Update Package Hotel =========================
elseif ($action === 'savePackageHotel') {
    try {
        $package_id = $_POST['package_id'] ?? '';
        $category_id = $_POST['category_id'] ?? '';
        $hotel_id = $_POST['hotel_id'] ?? '';
        $city_id = $_POST['city_id'] ?? '';
        $state_id = $_POST['state_id'] ?? '';
        $status = 'active';

        if (!$package_id || !$hotel_id || !$city_id) {
            throw new Exception('Please select all required fields.');
        }

        // Check if already exists (same package + hotel)
        $check = $conn->prepare("SELECT id FROM package_hotels WHERE package_id=? AND hotel_id=?");
        $check->bind_param("ii", $package_id, $hotel_id);
        $check->execute();
        $result = $check->get_result();

        if ($result->num_rows > 0) {
            // Update existing
            $row = $result->fetch_assoc();
            $id = $row['id'];
            $stmt = $conn->prepare("UPDATE package_hotels 
                SET category_id=?, hotel_id=?, city_id=?, state_id=?, updated_at=NOW() 
                WHERE id=?");
            $stmt->bind_param("iiiii", $category_id, $hotel_id, $city_id, $state_id, $id);
            $stmt->execute();
            $stmt->close();

            $response = ['status' => 'success', 'message' => 'Package hotel updated successfully'];
        } else {
            // Insert new
            $stmt = $conn->prepare("INSERT INTO package_hotels 
                (package_id, category_id, hotel_id, city_id, state_id, status, created_at, updated_at)
                VALUES (?, ?, ?, ?, ?, ?, NOW(), NOW())");
            $stmt->bind_param("iiiiis", $package_id, $category_id, $hotel_id, $city_id, $state_id, $status);
            $stmt->execute();
            $stmt->close();

            $response = ['status' => 'success', 'message' => 'Package hotel added successfully'];
        }

    } catch (Exception $e) {
        $response = ['status' => 'error', 'message' => $e->getMessage()];
    }

    // ✅ Always return JSON and stop execution
    echo json_encode($response);
    exit;
}
// ========================= List Package Hotels =========================
elseif ($action === 'listPackageHotel') {
    $query = "SELECT ph.id, ph.package_id, ph.category_id, ph.hotel_id, ph.city_id, ph.state_id, 
                     h.hotel_name, c.city_name, s.state_name, pc.category_name, ph.status
              FROM package_hotels ph
              LEFT JOIN hotels h ON ph.hotel_id = h.id
              LEFT JOIN cities c ON ph.city_id = c.id
              LEFT JOIN states s ON ph.state_id = s.id
              LEFT JOIN package_categories pc ON ph.category_id = pc.id
              ORDER BY ph.id DESC";

    $result = $conn->query($query);
    $data = [];

    while ($row = $result->fetch_assoc()) {
        // ✅ Status switch
        $statusLabel = '
            <label class="switch">
                <input type="checkbox" class="switch-input" value="'.$row['id'].'" 
                    '.($row['status'] === 'active' ? 'checked' : '').' 
                    onclick="statusChange('.$row['id'].');" />
                <span class="switch-toggle-slider">
                    <span class="switch-on"></span>
                    <span class="switch-off"></span>
                </span>
            </label>
        ';
        $row['status'] = $statusLabel;

        // ✅ Action buttons
        $row['actions'] = '
            <button type="button" class="btn btn-sm btn-warning editHotel" data-id="'.$row['id'].'">
                <i class="far fa-edit"></i>
            </button>
            <button type="button" class="btn btn-sm btn-danger deleteHotel" data-id="'.$row['id'].'">
                <i class="far fa-trash-alt"></i>
            </button>
        ';

        $data[] = $row;
    }

    // ✅ Clean JSON output
    
    echo json_encode(['data' => $data]);
    exit;
}


// ========================= Get Single Package Hotel =========================
elseif ($action === 'getPackageHotel') {
    $id = $_POST['id'] ?? 0;

    $stmt = $conn->prepare("SELECT * FROM package_hotels WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'data' => $row
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Record not found.'
        ]);
    }

    exit;
}
	
elseif ($action === 'ToggleStatusPackageHotel') {
        $stmt = $conn->prepare("SELECT status FROM package_hotels WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res->num_rows > 0) {
            $row = $res->fetch_assoc();
            $new_status = $row['status'] === 'active' ? 'inactive' : 'active';
            $stmt->close();

            $stmt = $conn->prepare("UPDATE package_hotels SET status=? WHERE id=?");
            $stmt->bind_param("si", $new_status, $id);
            $stmt->execute();
            $stmt->close();

            $response = ['status' => 'success', 'message' => 'Status updated', 'new_status' => $new_status];
        } else {
            $response = ['status' => 'error', 'message' => 'Hotel not found'];
        }
    }


// ========================= Delete Package Hotel =========================
elseif ($action === 'deletePackageHotel') {
    $id = $_POST['id'] ?? 0;

    if ($id > 0) {
        $stmt = $conn->prepare("DELETE FROM package_hotels WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();

        $response = [
            'status' => 'success',
            'message' => 'Package hotel deleted successfully'
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'Invalid hotel ID.'
        ];
    }

    // ✅ Important: Always echo the JSON and exit
    echo json_encode($response);
    exit;
}



} catch (Exception $e) {
    $response = ['status' => 'error', 'message' => $e->getMessage()];
}

echo json_encode($response);
?>
