<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
include '../inc/db.php';

$action = $_POST['action'] ?? '';
$id = intval($_POST['id'] ?? 0);

function responseJSON($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

/* =======================================================
    CREATE BOOKING
   ======================================================= */
if ($action === 'Create') { 
	$customer_id       = intval($_POST['customer_id']);
	$inquiry_id        = intval($_POST['inquiry_id'] ?? 0);
	$booking_date      = $_POST['booking_date'] ?? date('Y-m-d');
	$flight_type       = $_POST['flight_type'] ?? 'one_way';
	$flight_from_city  = $_POST['flight_from_city'] ?? '';
	$flight_to_city    = $_POST['flight_to_city'] ?? '';
	$flight_departure_no = $_POST['flight_departure_no'] ?? '';
	$flight_departure_name = $_POST['flight_departure_name'] ?? '';
	$flight_return_no = $_POST['flight_return_no'] ?? '';
	$flight_return_name = $_POST['flight_return_name'] ?? '';
	$flight_departure_date = !empty($_POST['flight_departure_date']) ? $_POST['flight_departure_date'] : null;
	$flight_return_date = !empty($_POST['flight_return_date']) ? $_POST['flight_return_date'] : null;
	$flight_class      = $_POST['flight_class'] ?? 'economy';
	$flight_adult      = intval($_POST['flight_adult']);
	$flight_child      = intval($_POST['flight_child']);
	$flight_infant      = intval($_POST['flight_infant']);
	$transport_charges       = floatval($_POST['transport_charges']);
	$extra_charges     = floatval($_POST['extra_charges']);
	$discount          = floatval($_POST['discount']);
	$gst_included      = $_POST['gst_included'] ?? 'no';
	$gst_rate          = floatval($_POST['gst_rate']);
	$payment_mode      = $_POST['payment_mode'] ?? 'cash';
	$advance_payment   = floatval($_POST['advance_payment'] ?? 0);
	$useridnew         = intval($_POST['created_by']);
	$upi_id            = $_POST['upi_id'] ?? null;
	$bank_name         = $_POST['bank_name'] ?? null;
	$account_no        = $_POST['account_no'] ?? null;
	$transaction_id    = $_POST['transaction_id'] ?? null;

// ====== Calculate totals ======
$base_total = $transport_charges + $extra_charges;
$discount_amount = ($discount > 0) ? ($base_total * $discount / 100) : 0;
$after_discount  = $base_total - $discount_amount;
if ($gst_included === 'yes') {
    // GST is already included → extract GST part
    $gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
    $base_without_gst = round($after_discount - $gst_amount, 2);
    $total_amount = $after_discount; // total already includes GST
} else {
    // GST is NOT included → do NOT add GST at all
    $gst_amount = 0;
    $base_without_gst = round($after_discount, 2);
    $total_amount = $base_without_gst; // total = price without GST
}


// ====== Payment Status ======
if ($advance_payment >= $total_amount) $payment_status = 'paid';
elseif ($advance_payment > 0) $payment_status = 'partial';
else $payment_status = 'unpaid';

// ====== Generate Booking Code ======
$prefix = "MTT/";
$yearStart = (date('n') >= 4) ? date('y') : date('y') - 1;
$yearEnd   = $yearStart + 1;
$financialYear = $yearStart . '-' . $yearEnd;

$codeQuery = $conn->query("
    SELECT booking_code FROM bookings 
    WHERE booking_code LIKE '%$financialYear%' 
    ORDER BY id DESC LIMIT 1
");
if ($codeQuery && $codeQuery->num_rows > 0) {
    $lastCode = $codeQuery->fetch_assoc()['booking_code'];
    preg_match('/(\d+)$/', $lastCode, $matches);
    $nextNumber = isset($matches[1]) ? intval($matches[1]) + 1 : 1;
} else {
    $nextNumber = 1;
}
$booking_code = sprintf("%s%s/%04d", $prefix, $financialYear, $nextNumber);

// ====== Insert Booking ======
$sql = "
INSERT INTO bookings (
  inquiry_id, customer_id, booking_type, booking_code, booking_date,
  status, payment_status, flight_from_city, flight_to_city, flight_departure_date,
  flight_return_date, flight_departure_no,flight_departure_name, flight_return_no,flight_return_name, flight_adult, flight_child,flight_infant,
  flight_class, transport_charges, extra_charges, discount, gst_rate, gst_included,
  gst_amount, discount_amount, total_amount, paid_amount, payment_mode, created_by, financial_year
)
VALUES (
  '$inquiry_id', '$customer_id', 'flight', '$booking_code', '$booking_date',
  'confirmed', '$payment_status', '$flight_from_city', '$flight_to_city', '$flight_departure_date',
  " . ($flight_return_date ? "'$flight_return_date'" : "NULL") . ", '$flight_departure_no','$flight_departure_name', '$flight_return_no','$flight_return_name', '$flight_adult', '$flight_child','$flight_infant',
  '$flight_class', '$transport_charges', '$extra_charges', '$discount', '$gst_rate', '$gst_included',
  '$gst_amount', '$discount_amount', '$total_amount', '$advance_payment', '$payment_mode', '$useridnew', '$financial_year'
)
";

if ($conn->query($sql)) {
    $booking_id = $conn->insert_id;

    // ====== Generate Receipt No ======
    function generateReceiptNo($conn) {
        $month = date('n');
        $year = date('Y');
        $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
        $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
        $nextNumber = 1;
        if ($res && $res->num_rows > 0) {
            $row = $res->fetch_assoc();
            preg_match('/(\d+)$/', $row['receipt_no'], $matches);
            $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
        }
        return "RC{$fy_short}-" . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
    }

    if ($advance_payment > 0) {
        $receipt_no = generateReceiptNo($conn);
        $conn->query("
            INSERT INTO payments (
              booking_id, customer_id, payment_type, amount, mode, transaction_id,
              receipt_no, bank_name, account_no, upi_id, received_by, financial_year, status
            ) VALUES (
              '$booking_id', '$customer_id', 'received', '$advance_payment', '$payment_mode', '$transaction_id',
              '$receipt_no', '$bank_name', '$account_no', '$upi_id', '$useridnew', '$financial_year', 'completed'
            )
        ");
    }

    if ($inquiry_id > 0) {
        $conn->query("UPDATE inquiries SET status='closed' WHERE id='$inquiry_id'");
    }

    responseJSON('success', 'Flight booking created successfully.', ['id' => $booking_id]);

    } else {
        responseJSON('error', 'Failed to create booking: ' . mysqli_error($conn));
    }
}

/* =======================================================
    UPDATE BOOKING
   ======================================================= */
elseif ($action === 'Update' && $id > 0) {

    $hotel_rooms       = intval($_POST['hotel_rooms']);
    $transport_charges       = floatval($_POST['transport_charges']);
    $child_price       = floatval($_POST['child_price']);
    $extra_bed_price   = floatval($_POST['extra_bed_price']);
    $transport_charges = floatval($_POST['transport_charges']);
    $discount          = floatval($_POST['discount']);
    $gst_included      = $_POST['gst_included'] ?? 'no';
    $gst_rate          = floatval($_POST['gst']);
    $grand_total       = floatval($_POST['grand_total']);
    $advance_payment   = floatval($_POST['advance_payment']);
    $payment_mode      = $_POST['payment_mode'] ?? 'cash';
    $useridnew         = intval($_POST['useridnew']);
    $customer_id       = intval($_POST['customer_id']);

    // ====== Calculate totals ======
$base_total = $transport_charges + $extra_charges;
$discount_amount = ($discount > 0) ? ($base_total * $discount / 100) : 0;
$after_discount  = $base_total - $discount_amount;
if ($gst_included === 'yes') {
    // GST is already included → extract GST part
    $gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
    $base_without_gst = round($after_discount - $gst_amount, 2);
    $total_amount = $after_discount; // total already includes GST
} else {
    // GST is NOT included → do NOT add GST at all
    $gst_amount = 0;
    $base_without_gst = round($after_discount, 2);
    $total_amount = $base_without_gst; // total = price without GST
}


    // Update booking
    $stmt = $conn->prepare("
        UPDATE bookings SET 
            hotel_rooms=?, transport_charges=?, child_price=?, extra_bed_price=?, transport_charges=?, 
            discount=?, gst_rate=?, gst_included=?, total_amount=?, paid_amount=?, payment_mode=?, 
            updated_at=NOW()
        WHERE id=?
    ");
    $stmt->bind_param(
        'iddddddssdsi',
        $hotel_rooms, $transport_charges, $child_price, $extra_bed_price, $transport_charges,
        $discount, $gst_rate, $gst_included, $total_amount, $advance_payment, $payment_mode, $id
    );

    if ($stmt->execute()) {
        // Reset old payments and insert updated advance
        $conn->query("DELETE FROM payments WHERE booking_id = '$id'");

        if ($advance_payment > 0) {
            $pstmt = $conn->prepare("
                INSERT INTO payments (booking_id, customer_id, amount, mode, payment_type, received_by)
                VALUES (?, ?, ?, ?, 'received', ?)
            ");
            $pstmt->bind_param('iidss', $id, $customer_id, $advance_payment, $payment_mode, $useridnew);
            $pstmt->execute();
        }

        responseJSON('success', 'Booking updated successfully.', ['id' => $id]);
    } else {
        responseJSON('error', 'Failed to update booking.');
    }
}

/* =======================================================
    SELECT BOOKING
   ======================================================= */
elseif ($action === 'Select' && $id > 0) {
    $result = $conn->query("SELECT * FROM bookings WHERE id='$id' LIMIT 1");
    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_assoc();
        responseJSON('success', 'Booking fetched successfully.', ['data' => $data]);
    } else {
        responseJSON('error', 'Booking not found.');
    }
}

/* =======================================================
    FETCH FOR DATATABLE
   ======================================================= */
elseif ($action === 'fetch') {
   $draw   = intval($_POST['draw'] ?? 1);
    $start  = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 25);
    $search = $_POST['search']['value'] ?? '';

    $where = "WHERE b.booking_type = 'flight'";
    if (!empty($search)) {
        $search = $conn->real_escape_string($search);
        $where .= " AND (
            b.booking_code LIKE '%$search%' OR
            b.flight_from_city LIKE '%$search%' OR
            b.flight_to_city LIKE '%$search%' OR
            c.name LIKE '%$search%' OR
            c.phone LIKE '%$search%'
        )";
    }

    // Total records
    $totalQuery = $conn->query("SELECT COUNT(*) AS total FROM bookings WHERE booking_type = 'flight'");
    $totalData  = $totalQuery->fetch_assoc()['total'];

    // Fetch records
    $query = "
        SELECT 
            b.id,b.customer_id, b.booking_code, b.booking_date, 
            b.flight_from_city, b.flight_to_city,
            b.flight_departure_date, b.flight_return_date, b.flight_class,
            b.total_amount, b.paid_amount,
            (b.total_amount - b.paid_amount) AS due_amount,
            c.name AS customer_name, c.phone AS customer_phone,
            p.last_payment_date, p.last_payment_type, p.last_payment_amount
        FROM bookings b
        LEFT JOIN customers c ON c.id = b.customer_id
        LEFT JOIN (
            SELECT 
                booking_id,
                MAX(payment_date) AS last_payment_date,
                SUBSTRING_INDEX(GROUP_CONCAT(payment_type ORDER BY payment_date DESC), ',', 1) AS last_payment_type,
                SUBSTRING_INDEX(GROUP_CONCAT(amount ORDER BY payment_date DESC), ',', 1) AS last_payment_amount
            FROM payments
            WHERE status = 'completed'
            GROUP BY booking_id
        ) p ON p.booking_id = b.id
        $where
        ORDER BY b.id DESC
        LIMIT $start, $length
    ";

    $result = $conn->query($query);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $due   = floatval($row['due_amount']);
        $total = floatval($row['total_amount']);

        //  Determine payment status
        if ($due <= 0) {
            $statusBadge = '<span class="badge bg-success">Paid</span>';
            $paymentBtn = '';
        } else {
            $statusBadge = ($due < $total)
                ? '<span class="badge bg-warning text-dark">Partial</span>'
                : '<span class="badge bg-danger">Unpaid</span>';

            $paymentBtn = '
                <div class="mb-1">
                    <button class="btn btn-xs btn-success changeStatusBtn" 
                        data-id="' . $row['id'] . '" 
                        data-customer_id="' . $row['customer_id'] . '" 
                        data-total_amount="' . $row['total_amount'] . '" 
						data-balance_amount="' . $row['due_amount'] . '" 
                        data-gst_included="yes"
                        title="Add Payment">
                        <i class="ti ti-credit-card"></i>
                    </button>
                </div>';
            
            //  Add last payment info (if available)
            if (!empty($row['last_payment_date'])) {
                $statusBadge .= '<br>
                    <small class="text-muted">
                        Last: ' . date('d-m-Y', strtotime($row['last_payment_date'])) . '<br>
                        ' . ucfirst($row['last_payment_type']) . ': ' . number_format($row['last_payment_amount'], 2) . '
                    </small>';
            }
        }


        // Action Buttons
        $actions = '
            ' . $paymentBtn . '
            <button class="btn btn-xs btn-info download" data-id="' . $row['id'] . '" title="Download PDF">
                <i class="ti ti-file-download"></i>
            </button>
            <button class="btn btn-xs btn-danger delete" id="' . $row['id'] . '" title="Delete Booking">
                <i class="ti ti-trash"></i>
            </button>
        ';
        $data[] = [
            'booking_date'   => date('d-m-Y', strtotime($row['booking_date'])),
            'booking_code'   => htmlspecialchars($row['booking_code']),
             'customer_name'  => '<a href="flight_booking_payment.php?book_id=' . intval($row['id']) . '">'
                     . ($row['customer_name'] ?? '') . 
                   '</a>',
            'customer_phone' => htmlspecialchars($row['customer_phone']),
            'from_to'        => $row['flight_from_city'] . ' to ' . $row['flight_to_city'],
            'departure_date' => !empty($row['flight_departure_date']) ? date('d-m-Y', strtotime($row['flight_departure_date'])) : '-',
            'return_date'    => !empty($row['flight_return_date']) ? date('d-m-Y', strtotime($row['flight_return_date'])) : '-',
            'flight_class'   => ucfirst($row['flight_class'] ?? '-'),
            'total_amount'   => number_format($row['total_amount'], 2),
            'due_amount'     => number_format($row['due_amount'], 2),
            'payment_status' => $statusBadge,
            'action'         => $actions
        ];
    }

    echo json_encode([
        'draw'            => $draw,
        'recordsTotal'    => $totalData,
        'recordsFiltered' => !empty($search) ? count($data) : $totalData,
        'data'            => $data
    ]);
	exit;
}


elseif ($action === 'savepayment') {
    $booking_id   = intval($_POST['booking_id'] ?? 0);
    $customer_id  = intval($_POST['customer_id'] ?? 0);
    $amount       = floatval($_POST['amount'] ?? 0);
    $mode         = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
    $upi_id       = $conn->real_escape_string($_POST['upi_id'] ?? '');
    $reference_no = $conn->real_escape_string($_POST['transaction_id'] ?? '');
    $bank_name    = $conn->real_escape_string($_POST['bank_name'] ?? '');
    $narration    = $conn->real_escape_string($_POST['narration'] ?? '');
    $received_by  = intval($_POST['received_by'] ?? 0);

    if ($booking_id <= 0 || $amount <= 0) {
        responseJSON('error', 'Invalid booking or amount.');
    }

    // --- Fetch booking ---
    $bq = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = $booking_id LIMIT 1");
    if (!$bq || $bq->num_rows == 0) {
        responseJSON('error', 'Booking not found.');
    }
    $b = $bq->fetch_assoc();
    $balance = $b['total_amount'] - $b['paid_amount'];

    if ($amount > $balance) {
        responseJSON('error', 'Received amount cannot be greater than balance amount.');
    }

    // --- Generate Receipt No ---
    function generateReceiptNo($conn) {
        $month = date('n');
        $year = date('Y');
        $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
        $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
        $nextNumber = 1;
        if ($res && $res->num_rows > 0) {
            $row = $res->fetch_assoc();
            preg_match('/(\d+)$/', $row['receipt_no'], $matches);
            $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
        }
        $formattedNo = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return "RC{$fy_short}-{$formattedNo}";
    }

    $receipt_no = generateReceiptNo($conn);

    // --- Save Payment ---
    $stmt = $conn->prepare("
        INSERT INTO payments 
        (booking_id, customer_id, amount, mode, upi_id, reference_no, bank_name, narration, receipt_no, payment_type, received_by, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'received', ?, 'completed', NOW())
    ");
    $stmt->bind_param('iidssssssi', $booking_id, $customer_id, $amount, $mode, $upi_id, $reference_no, $bank_name, $narration, $receipt_no, $received_by);

    if ($stmt->execute()) {
        $payment_id = $conn->insert_id;

        // --- Update booking ---
        $conn->query("UPDATE bookings 
                      SET paid_amount = paid_amount + $amount, 
                          payment_status = CASE 
                              WHEN paid_amount + $amount >= total_amount THEN 'paid'
                              WHEN paid_amount + $amount > 0 THEN 'partial'
                              ELSE 'unpaid'
                          END
                      WHERE id = $booking_id");

        responseJSON('success', 'Payment added successfully.', ['payment_id' => $payment_id]);
    } else {
        responseJSON('error', 'Failed to save payment: ' . $conn->error);
    }
}


/* =======================================================
   ❌ DELETE BOOKING
   ======================================================= */
elseif ($action === 'Delete' && $id > 0) {
    $conn->query("DELETE FROM payments WHERE booking_id = '$id'");
    $conn->query("DELETE FROM bookings WHERE id = '$id'");
    responseJSON('Delete', 'Booking deleted successfully.');
}

/* =======================================================
   ⚠️ INVALID ACTION
   ======================================================= */
else {
    responseJSON('error', 'Invalid action or missing parameters.');
}
?>
