<?php
include( 'inc/template.php' );

// Function to handle main operations
//function main() {
//	global $conn;

?>

<div class="container-fluid flex-grow-1 container-p-y">
	<h4 class="py-1 mb-1"><span class="text-muted fw-light">Change Password</h4>
	<div class="row mb-4">
<?php
if (isset($_POST['submitchang'])) {
    $oldPassword = $_POST['old-password'];
    $newPassword = $_POST['new-password'];
    $confirmPassword = $_POST['confirm-password'];

    if (empty($oldPassword) || empty($newPassword) || empty($confirmPassword)) {
        $message = "All fields are required.";
        $messageType = 'error';
    } elseif ($newPassword != $confirmPassword) {
        $message = "New password and confirm password do not match.";
        $messageType = 'error';
    } else {
        $userId = $_SESSION['UserId'];
        $role = $_SESSION['Role'];

        if ($role == 'Admin') {
            $sql = "SELECT PasswordHash FROM Users WHERE UserID = ?";
        
            $stmt = mysqli_prepare($conn, $sql);
            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "i", $userId);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_bind_result($stmt, $hashedPassword);
                mysqli_stmt_fetch($stmt);
                mysqli_stmt_close($stmt);

                if (password_verify($oldPassword, $hashedPassword)) {
                    $newHashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

                    $updateSql = "UPDATE Users SET PasswordHash = ? WHERE UserID = ?";

                    $updateStmt = mysqli_prepare($conn, $updateSql);
                    if ($updateStmt) {
                        mysqli_stmt_bind_param($updateStmt, "si", $newHashedPassword, $userId);
                        mysqli_stmt_execute($updateStmt);
                        $message = "Password changed successfully.";
                        $messageType = 'success';
                    } else {
                        $message = "Error updating password: " . mysqli_error($conn);
                        $messageType = 'error';
                    }
                } else {
                    $message = "Incorrect old password.";
                    $messageType = 'error';
                }
            } else {
                $message = "Error preparing SQL statement: " . mysqli_error($conn);
                $messageType = 'error';
            }
        } else {
            $message = "Invalid role.";
            $messageType = 'error';
        }

        mysqli_close($conn);
    }
}
?>


<script>
    <?php if (isset($message)): ?>
        // Use Toastr to show the message
        toastr.<?php echo $messageType; ?>("<?php echo $message; ?>");
    <?php endif; ?>
</script>

		<div class="card">
			<div class="card-body">
				
				<form id="formAuthentication" method="POST">
					<div class="mb-3 form-password-toggle">
						<label class="form-label" for="password">Old Password</label>
						<div class="input-group input-group-merge">

							<input type="password" id="old-password" class="form-control" name="old-password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" required/>
							<span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
						</div>
					</div>
					<div class="mb-3 form-password-toggle">
						<label class="form-label" for="password">New Password</label>
						<div class="input-group input-group-merge">

							<input type="password" id="new-password" class="form-control" name="new-password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" required/>
							<span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
						</div>
					</div>
					<div class="mb-3 form-password-toggle">
						<label class="form-label" for="confirm-password">Confirm Password</label>
						<div class="input-group input-group-merge">
							<input type="password" id="confirm-password" class="form-control" name="confirm-password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" required/>
							<span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
						</div>
					</div>
					<button type="submit" name="submitchang" class="btn btn-primary d-grid w-100 mb-3">Change Password</button>

				</form>

			</div>
		</div>

	</div>

</div>
<?php include('inc/footer.php');?>
<?php//}?>