<?php
include("inc/config.php");
session_start();

// Only Admin / Manager can update
if (!in_array($_SESSION['role'], ['succ_admin', 'succ_manager'])) {
    echo "Unauthorized";
    exit;
}

if (isset($_POST['id']) && isset($_POST['status'])) {
    $id     = intval($_POST['id']);
    $status = $_POST['status'];
    $remarks = isset($_POST['remarks']) ? mysqli_real_escape_string($conn, $_POST['remarks']) : null;

    // validate status
    if (!in_array($status, ['approved', 'rejected'])) {
        echo "Invalid status";
        exit;
    }

    // build SQL
    if ($status == 'approved') {
        $sql = "UPDATE timesheets 
                SET status='approved', review_remarks=NULL 
                WHERE id='$id' AND status='pending'";
    } elseif ($status == 'rejected') {
        $sql = "UPDATE timesheets 
                SET status='rejected', review_remarks='$remarks' 
                WHERE id='$id' AND status='pending'";
    }

    if (mysqli_query($conn, $sql)) {
        echo "success";
    } else {
        echo "Error: " . mysqli_error($conn);
    }
} else {
    echo "Invalid Request";
}
