 <?php
$title = "PP / HDPE Raffia Woven Sack Production Line | Heaven Extrusions";
$meta_description = "High-performance PP / HDPE Raffia Woven Sack Bag Production Line. Complete production solution with technical specifications and machine video.";
ob_start();

$products = [
    [
        'title' => 'PP / HDPE Raffia Woven Sack Bag Production Line',
        'link'  => 'pp-hdpe-raffia-woven-sack-bag-production-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-36.png'
    ],
    [
        'title' => 'Extrusion Coating Tarpaulin Lamination Line',
        'link'  => 'extrusion-coating-tarpaulin-lamination-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-37.png'
    ],
    [
        'title' => 'Extrusion Coating Carpet Lamination Line',
        'link'  => 'extrusion-coating-carpet-lamination-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-39.png'
    ],
    [
        'title' => 'Multilayer Blown Film Extrusion Line',
        'link'  => 'multilayer-blown-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-40.png'
    ],
    [
        'title' => 'ABA Co-Extrusion Blown Film Extrusion Line',
        'link'  => 'aba-co-ex-blown-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-41.png'
    ],
    [
        'title' => 'Two-Layer Blown Film Extrusion Line',
        'link'  => 'two-layer-blown-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-42.png'
    ],
    [
        'title' => 'Monolayer Blown Film Extrusion Line',
        'link'  => 'monolayer-blown-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-43.png'
    ],
    [
        'title' => 'Biodegradable Bags Production Line',
        'link'  => 'biodegradable-bags-production-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-44.png'
    ],
    [
        'title' => 'Air Bubble Film Extrusion Line',
        'link'  => 'air-bubble-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-45.png'
    ],
    [
        'title' => 'Cast Stretch Film Extrusion Line',
        'link'  => 'cast-stretch-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-46.png'
    ],
    [
        'title' => 'Cast Embossed Film Extrusion Line',
        'link'  => 'cast-embossed-film-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-47.png'
    ],
    [
        'title' => 'PP/HDPE Sheet Extrusion Line',
        'link'  => 'pp-hdpe-sheet-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-48.png'
    ],
    [
        'title' => 'PP/HDPE Monofilament Extrusion Line',
        'link'  => 'pp-hdpe-pe-monofilament-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-49.png'
    ],
    [
        'title' => 'PP/PET Box Strapping Extrusion Line',
        'link'  => 'pp-pet-box-strapping-extrusion-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-50.png'
    ],
    [
        'title' => 'PP/HDPE Baler Twine Extruder Line',
        'link'  => 'pp-hdpe-baler-twine-extruder-line',
        'image' => 'assets/images/portfolio/portfolio-thumb-51.png'
    ],
    [
        'title' => 'Rotogravure Printing Machine',
        'link'  => 'rotogravure-printing-machine',
        'image' => 'assets/images/portfolio/portfolio-thumb-52.png'
    ],
    [
        'title' => 'Flexographic Printing Machine',
        'link'  => 'flexography-printing-machine',
        'image' => 'assets/images/portfolio/portfolio-thumb-53.png'
    ]
];
?>




<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
	<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
	<div class="container">
		<div class="row">
			<div class="col-xxl-6 col-xl-8 col-lg-8">
				<div class="rs-breadcrumb-content-wrapper">
<!--
					<div class="rs-breadcrumb-title-wrapper">
						<h1 class="rs-breadcrumb-title">PP/PET Box Strapping Extrusion Line</h1>
					</div>
-->
					<div class="rs-breadcrumb-menu">
						<nav>
							<ul>
								<li><span><a href="index.php">Home</a></span>
								</li>
								<li><span>Products</span>
								</li>
								
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
 
<section class="rs-elements-portfolio-area section-space-bottom rs-portfolio-eight rs-services-area rs-services-three section-space has-theme-orange">
    <div class="container">
        <div class="row g-5 process-counts">

            <?php foreach ($products as $index => $product): ?>
                <div class="col-xl-<?= $index < 4 ? '4' : '4' ?> col-lg-4 col-md-6">
                    <div class="rs-services-wrapper">
                        <div class="rs-portfolio-item">
                            <div class="rs-portfolio-thumb">
                                <img src="<?= $product['image']; ?>" alt="<?= $product['title']; ?>">
                            </div>
                            <div class="rs-portfolio-content">
                                <h6 class="rs-portfolio-title underline has-white">
                                    <a href="<?= $product['link']; ?>">
                                        <?= $product['title']; ?>
                                    </a>
                                </h6>
                            </div>
                            <div class="rs-portfolio-btn">
                                <a class="rs-btn has-theme-light-green has-circle has-icon" href="<?= $product['link']; ?>">
                                    <span class="icon-box">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">
                                            <path d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z"/>
                                        </svg>
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

        </div>
    </div>
</section>

<?php
$content = ob_get_clean();
include 'layout/layout.php';
?>
