<?php

require_once IADMIN_PATH . '/config/db.php';

// Auto login via Remember Me cookie
$isLoggedIn = false;
if (empty($_SESSION['user_id']) && !empty($_COOKIE['remember_me'])) {
    [$selector, $token] = explode(':', $_COOKIE['remember_me'], 2);
	require_once APP_PATH . '/models/AuthModel.php';
    $model = new AuthModel($conn);

    $row = $model->getRememberToken($selector);

    if ($row && strtotime($row['expires_at']) > time() && hash_equals($row['hashed_token'], hash('sha256', $token))) {
        $_SESSION['user_id']    = $row['id'];
        $_SESSION['user_name']  = $row['name'];
        $_SESSION['user_email'] = $row['email'];
        $_SESSION['user_status']= $row['status'] ?? 'active';
    }
}

// Set login flag
if (!empty($_SESSION['user_id'])) {
    $isLoggedIn = true;
}
