<?php
//require_once __DIR__ . '/iadmin/config/config.php';
//require_once LAYOUT_PATH . '/auth_check.php';

$title = "Price Monitoring Tool | Track Prices & Get Alerts";
$meta_description = "Track product prices automatically across multiple websites, view price history, and get instant alerts when prices change.";

ob_start();
?>
<style>
/* Counter number & text white */
.rs-elements-counter-area.purple-bg .rs-counter-number,
.rs-elements-counter-area.purple-bg .prefix,
.rs-elements-counter-area.purple-bg .rs-counter-title,
.rs-elements-counter-area.purple-bg .rs-counter-text {
    color: #ffffff !important;
}

/* Optional: slightly dim titles */
.rs-elements-counter-area.purple-bg .rs-counter-title {
    opacity: 0.85;
}

.wave-line {
  width: 100%;
  height: 6px;
  background: linear-gradient(
    90deg,
    #2b2e83,
    #5a3db8,
    #2b2e83
  );
  border-radius: 50px;
}
	
.rs-elements-counter-area {
    position: relative;
    background-color: #393185; /* Purple background */
    color: #fff;
    overflow: hidden;
    padding: 0px 0;
}

/* Right-side half curve */
.right-curve {
    position: absolute;
    top: 0;
    right: -50px; /* move curve partly outside */
    width: 200px;
    height: 100%;
    background-color: #fff; /* color of curve */
    border-radius: 50% 0 0 50%; /* creates vertical half-curve */
    z-index: 1;
}

.rs-why-choose-thumb-wrapper {
    position: relative;
    z-index: 2; /* put image above curve */
}

.rs-why-choose-content-wrapper {
    position: relative;
    z-index: 2; /* counters on top of background */
}

.rs-counter-item {
    margin-bottom: 30px;
}

.rs-counter-number-wrapper {
    font-size: 36px;
    font-weight: bold;
}


</style>

<?php include __DIR__ . '/layout/slider.php'; ?>

<div class="rs-text-slide-area rs-text-slide-one">
            <div class="container-fluid">
                <div class="rs-text-slide-wrapper">
                    <div class="gsap-marquee right speed-20 move-to-1000">
                        <div class="rs-text-slide-inner">
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Architecture</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Oil</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Gas</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Materials</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Engineering</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Gas</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Oil</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Architecture</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<!-- banner area end -->
<section class="rs-about-area section-space rs-about-four">
            <div class="container">
                <div class="row g-5">
                    <div class="col-xl-6 col-lg-6">
                        <div class="rs-about-thumb-wrapper">
                            <div class="rs-about-thumb-left-part">
                                <div class="rs-about-thumb">
                                    <img src="assets/images/about/about-thumb-04.png" alt="image">
                                </div>
                                <div class="rs-about-video-btn">
                                    <div class="rs-rotate-btn">
                                        <a href="https://www.youtube.com/watch?v=Yue48fUXuqI"
                                            class="rs-play-btn popup-video has-theme-red"><i
                                                class="ri-play-fill"></i></a>
                                        <div class="rs-circle-title gsap-rotate rs-text-circle-wrapper">
                                            <div class="rs-text-circle" data-rotate-degree="13.33">
                                                Watch Video - Watch Video -
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rs-about-thumb-right-part">
                                <div class="rs-about-counter">
                                    <div class="rs-counter-inner">
                                        <div class="rs-counter-number-wrapper">
                                            <span class="rs-counter-number odometer" data-count="52">00</span>
                                            <span class="prefix">+</span>
                                        </div>
                                        <span class="rs-counter-title">Years of Experience
                                        </span>
                                    </div>
                                </div>
                                <div
                                    class="rs-about-thumb has-large-thumb rs-image scroll_reveal reveal_left reveal-active">
                                    <img decoding="async" src="assets/images/about/about-thumb-05.png" alt="image">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6">
                        <div class="rs-about-wrapper">
                            <div class="rs-about-content-wrapper">
                                <div class="rs-section-title-wrapper">
                                    <span class="rs-section-subtitle  has-bg-field justify-content-start">
                                        Welcome
                                    </span>
                                    <h2 class="rs-section-title rs-split-text-enable split-in-fade">Pioneering Excellence in
</h2>
									<h3 class="rs-section-title rs-split-text-enable split-in-fade">Plastic Extrusion Machinery <span class="title-line">
  <svg viewBox="0 0 1000 10" preserveAspectRatio="none">
    <defs>
      <linearGradient id="lineGradient" x1="0%" y1="0%" x2="100%" y2="0%">
        <stop offset="0%" stop-color="#3b3f99" stop-opacity="0"/>
        <stop offset="50%" stop-color="#4c4fd9"/>
        <stop offset="100%" stop-color="#3b3f99" stop-opacity="0"/>
      </linearGradient>
    </defs>

    <!-- soft glow -->
    <rect x="0" y="3" width="1000" height="4"
          fill="url(#lineGradient)" opacity="0.5"/>

    <!-- thicker center line -->
    <rect x="0" y="4" width="1000" height="3"
          fill="url(#lineGradient)"/>
  </svg>
</span>
</h3>
                                    <p class="descrip">Delivers innovative, High-performance Plastic Extrusion
Machinery trusted across India and Global Markets</p>
									
                                </div>
                                <div class="rs-about-tab">
                                    <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="pills-item-one-tab"
                                                data-bs-toggle="pill" data-bs-target="#pills-item-one" type="button"
                                                role="tab" aria-controls="pills-item-one" aria-selected="true">
                                                Our History
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-item-two-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-item-two" type="button" role="tab"
                                                aria-controls="pills-item-two" aria-selected="false"> Our Mission
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-item-three-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-item-three" type="button" role="tab"
                                                aria-controls="pills-item-three" aria-selected="false">
                                                Our Vision
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="rs-aobut-tab-content-wrapper">
                                    <div class="tab-content rs-about-tab-anim" id="pills-tabContent">
                                        <div class="tab-pane fade show active" id="pills-item-one" role="tabpanel"
                                            aria-labelledby="pills-item-one-tab" tabindex="0">
                                            <div class="rs-about-tab-content">
                                                <p>Welcome to Industrie, a leading industry innovator with a rich
                                                    history of
                                                    excellence
                                                    with a passion make also for precision we have been empowering
                                                    industries and
                                                    driving progress for</p>
                                                <div class="rs-about-feature-list">
                                                    <div class="rs-list-item has-theme-red">
                                                        <ul>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Quality Control System
                                                            </li>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Building Quality Industrial
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-item-two" role="tabpanel"
                                            aria-labelledby="pills-item-two-tab" tabindex="0">
                                            <div class="rs-about-tab-content">
                                                <p>Welcome to Industrie, a leading industry innovator with a rich
                                                    history of
                                                    excellence
                                                    with a passion make also for precision we have been empowering
                                                    industries and
                                                    driving progress for</p>
                                                <div class="rs-about-feature-list">
                                                    <div class="rs-list-item has-theme-red">
                                                        <ul>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Quality Control System
                                                            </li>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Building Quality Industrial
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-item-three" role="tabpanel"
                                            aria-labelledby="pills-item-three-tab" tabindex="0">
                                            <div class="rs-about-tab-content">
                                                <p>Welcome to Industrie, a leading industry innovator with a rich
                                                    history of
                                                    excellence
                                                    with a passion make also for precision we have been empowering
                                                    industries and
                                                    driving progress for</p>
                                                <div class="rs-about-feature-list">
                                                    <div class="rs-list-item has-theme-red">
                                                        <ul>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Quality Control System
                                                            </li>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Building Quality Industrial
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="rs-about-author-info">
                                    <div class="rs-about-btn">
                                        <a class="rs-btn has-theme-red has-icon has-bg has-skew"
                                            href="about.html">Explore More
                                            <span class="icon-box">
                                                <svg class="icon-first" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                                <svg class="icon-second" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                            </span>
                                        </a>
                                    </div>
                                  
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {

    // Disable on mobile
    if (window.innerWidth < 992) return;

    const section = document.querySelector(".rs-elements-counter-area");
    const image = document.querySelector(".gsap-parallax");

    if (!section || !image) return;

    section.addEventListener("mousemove", (e) => {
        const rect = section.getBoundingClientRect();

        const x = (e.clientX - rect.left - rect.width / 2) * 0.03;
        const y = (e.clientY - rect.top - rect.height / 2) * 0.03;

        gsap.to(image, {
            x: x,
            y: y,
            duration: 0.6,
            ease: "power3.out"
        });
    });

    section.addEventListener("mouseleave", () => {
        gsap.to(image, {
            x: 0,
            y: 0,
            duration: 0.8,
            ease: "power3.out"
        });
    });
});
</script>

<section class="rs-elements-counter-area section-space rs-why-choose-two purple-bg">
    <div class="container">
        <div class="row g-5">
            <div class="col-xl-9 col-lg-9">
                <div class="rs-why-choose-content-wrapper">
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="27">0</span>
                            <span class="prefix">+</span>
                        </div>
                        <span class="rs-counter-title">Countries</span>
                    </div>
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="1">0</span>
                            <span class="prefix">K+</span>
                        </div>
                        <span class="rs-counter-title">Customers</span>
                    </div>
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="20">0</span>
                            <span class="prefix">+</span>
                        </div>
                        <span class="rs-counter-title">Experience</span>
                    </div>
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="20">0</span>
                            <span class="prefix">+</span>
                        </div>
                        <span class="rs-counter-title">Product Range</span>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-3 position-relative">
                <!-- Right side half-curve -->
                <div class="right-curve"></div>

                <div class="rs-why-choose-section-area">
                    <div class="rs-why-choose-thumb-wrapper">
                        <div class="rs-why-choose-thumb image-two">
                            <img src="assets/images/bg/counterside.png" alt="image" class="gsap-parallax">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- feature area end -->


<section class="rs-why-choose-area rs-why-choose-three">
            <span class="rs-why-choose-shape gsap-move down-200 start-61"></span>
            <div class="rs-why-choose-bg-thumb" data-background="assets/images/bg/why-choose-bg.png"></div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-6 col-md-10">
                        <div class="rs-why-choose-content-wrapper section-space">
                            <div class="rs-section-title-wrapper section-title-space">
                                <span class="justify-content-start rs-section-subtitle has-stroke">
                                    Why Choose Us
                                </span>
                                <h2 class="rs-section-title rs-split-text-enable split-in-fade">Always Powering Your
                                    Business
                                    For Over 20 Years</h2>
                            </div>
							
                            <div class="rs-why-choose-content-inner">
                                <div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".3s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="52" height="39"
                                            viewBox="0 0 52 39" fill="none">
                                            <path
                                                d="M47.7749 4.22461C47.7749 5.91816 46.7266 5.91816 46.7266 7.69235C46.7266 9.3859 47.7749 9.3859 47.7749 11.1601C47.7749 12.8536 46.7266 12.8536 46.7266 14.6278C46.7266 16.3214 47.7749 16.3214 47.7749 18.0956C47.7749 19.7891 46.7266 19.7891 46.7266 21.5633C46.7266 23.2569 47.7749 23.2569 47.7749 25.0311C47.7749 26.7246 46.7266 26.7246 46.7266 28.4988C46.7266 30.1923 47.7749 30.1924 47.7749 31.9665"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M26.0003 29.7916C30.3206 29.7916 33.8229 26.2894 33.8229 21.9691C33.8229 17.6488 30.3206 14.1465 26.0003 14.1465C21.68 14.1465 18.1777 17.6488 18.1777 21.9691C18.1777 26.2894 21.68 29.7916 26.0003 29.7916Z"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M30.3542 28.4199V38.0973L25.9994 34.4683L21.6445 38.0973V28.4199C22.9349 29.307 24.3865 29.7909 25.9994 29.7909C27.6123 29.7909 29.1445 29.307 30.3542 28.4199Z"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M26.0014 16.8086L27.5336 19.8731L30.9207 20.357L28.5014 22.7763L29.0659 26.2441L26.0014 24.6312L22.9369 26.2441L23.5014 22.7763L21.082 20.357L24.4691 19.8731L26.0014 16.8086Z"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M18.4194 35.0323H1V1H51V35.0323H33.5806" stroke="white"
                                                stroke-width="1.7" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round"></path>
                                            <path
                                                d="M4.22656 4.22461C5.75882 4.22461 5.75882 5.273 7.37172 5.273C8.90398 5.273 8.90398 4.22461 10.5169 4.22461C12.0491 4.22461 12.0491 5.273 13.662 5.273C15.1943 5.273 15.1943 4.22461 16.8072 4.22461C18.3395 4.22461 18.3395 5.273 19.9524 5.273C21.4846 5.273 21.4846 4.22461 23.0975 4.22461C24.6298 4.22461 24.6298 5.273 26.2427 5.273C27.7749 5.273 27.7749 4.22461 29.3879 4.22461C30.9201 4.22461 30.9201 5.273 32.533 5.273C34.0653 5.273 34.0653 4.22461 35.6782 4.22461C37.2104 4.22461 37.2104 5.273 38.8233 5.273C40.4362 5.273 40.3556 4.22461 41.9685 4.22461C43.5008 4.22461 43.5008 5.273 45.1137 5.273C46.6459 5.273 46.6459 4.22461 48.2588 4.22461"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M4.22656 4.22461C4.22656 5.91816 5.27495 5.91816 5.27495 7.69235C5.27495 9.3859 4.22656 9.3859 4.22656 11.1601C4.22656 12.8536 5.27495 12.8536 5.27495 14.6278C5.27495 16.3214 4.22656 16.3214 4.22656 18.0149C4.22656 19.7085 5.27495 19.7085 5.27495 21.4827C5.27495 23.1762 4.22656 23.1762 4.22656 24.9504C4.22656 26.644 5.27495 26.644 5.27495 28.4182C5.27495 30.1117 4.22656 30.1117 4.22656 31.8859"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M33.582 31.1613C34.0659 31.4839 34.3885 31.8064 35.2756 31.8064C36.8078 31.8064 36.8078 30.7581 38.4207 30.7581C40.0336 30.7581 39.953 31.8064 41.5659 31.8064C43.1788 31.8064 43.0982 30.7581 44.7111 30.7581C46.2433 30.7581 46.2433 31.8064 47.8562 31.8064"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M4.22656 31.8062C5.75882 31.8062 5.75882 30.7578 7.37172 30.7578C8.98463 30.7578 8.90398 31.8062 10.5169 31.8062C12.1298 31.8062 12.0491 30.7578 13.662 30.7578C15.275 30.7578 15.1943 31.8062 16.8072 31.8062C17.6943 31.8062 18.0975 31.4836 18.5008 31.161"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M10.2754 9.95117H41.727" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M41.7259 12.8535H32.3711" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M19.6302 12.8535H10.2754" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M39.0663 15.8379H35.1953" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M16.8065 15.8379H12.9355" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title"> Extensive Product Range</h6>
                                        <!--<p class="descrip"> Stands as a multidimensional force of progress. </p>-->
                                    </div>
                                </div>
                                <div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".5s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="52" height="44"
                                            viewBox="0 0 52 44" fill="none">
                                            <path
                                                d="M1 35.972L11.8434 42.8999H41.6627L51 35.9721M1 35.972V29.6468L3.71084 28.442M1 35.972C2.13109 35.7807 3.23424 35.6004 4.31325 35.4312M51 35.9721V30.5504C50.367 28.7154 49.5632 28.2966 47.3855 28.442M51 35.9721C49.7161 35.7685 48.5209 35.5779 47.3855 35.4002M3.71084 28.442L4.31325 35.4312M3.71084 28.442C3.71295 17.0045 6.19652 11.6895 14.5542 6.45407L14.5643 6.75527M4.31325 35.4312C7.72785 34.8957 10.9007 34.4713 13.9518 34.1606M14.8554 15.4902C14.332 16.2806 14.1829 16.7992 14.253 17.8999L13.9518 34.1606M14.8554 15.4902C16.2976 13.0882 17.5835 11.4975 19.0723 10.4783M14.8554 15.4902L14.5643 6.75527M13.9518 34.1606C21.9015 33.3511 29.0249 33.3131 37.4458 34.0922M37.4458 34.0922C37.3505 27.4542 37.6415 23.4852 36.8081 17.2974M37.4458 34.0922C40.7709 34.3998 43.7753 34.8349 47.3855 35.4002M36.8081 17.2974C36.7298 16.716 36.6416 16.1149 36.5422 15.4902C35.2686 13.357 34.0887 11.8955 32.6265 10.8879M36.8081 17.2974V6.15284M32.6265 3.44202C32.8186 2.38671 34.1325 1.93599 34.4337 1.93599C34.7349 1.93599 36.3427 2.40407 36.8081 3.44202V6.15284M32.6265 3.44202V10.8879M32.6265 3.44202H29.012M32.6265 10.8879C31.603 10.1826 30.4411 9.69973 29.012 9.36462M29.012 3.44202V9.36462M29.012 3.44202C28.6022 1.27565 27.7684 0.898007 25.6988 1.03238C23.8847 0.867197 23.1108 1.28444 22.3855 3.44202V9.13869M29.012 9.36462C28.0437 9.13755 26.9527 8.97833 25.6988 8.86371C24.4485 8.86923 23.36 8.95033 22.3855 9.13869M22.3855 9.13869C21.1242 9.38253 20.0541 9.80613 19.0723 10.4783M22.0843 3.44202C20.7961 3.16488 20.1168 3.24563 19.0723 4.34563M19.0723 4.34563V10.4783M19.0723 4.34563C18.496 2.93306 17.9234 2.55188 16.6627 2.2372C15.1406 2.94065 14.8086 3.42516 14.5542 4.34563L14.5643 6.75527M47.3855 28.442V35.4002M47.3855 28.442V20.9119C45.6681 14.2309 44.1887 10.6804 36.8081 6.15284M17.2651 22.1167V31.454"
                                                stroke="white" stroke-width="2"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title"> Advanced Manufacturing Infrastructure</h6>
                                        <!--<p class="descrip"> Stands as a multidimensional force of progress. </p>-->
                                    </div>
                                </div>
                                <div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".7s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Strong AfterSales Support</h6>
                                        
                                    </div>
                                </div>
								<div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".8s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Customization</h6>
                                       
                                    </div>
                                </div>
								<div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".9s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Experienced Technical Team</h6>
                                        
                                    </div>
                                </div>
								<div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".10s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Global Export Capability</h6>
                                       
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="rs-why-choose-btn-wrapper" data-background="assets/images/bg/video-bg-05.png">
                <div class="rs-why-choose-btn">
                    <a href="https://www.youtube.com/watch?v=go7QYaQR494" class="rs-play-btn popup-video"><i
                            class="fa-duotone fa-play"></i></a>
                </div>
            </div>
        </section>

<section class="rs-services-area section-space rs-services-eight rs-swiper">
            <div class="rs-services-bg-thumb" data-background="assets/images/bg/services-bg-05.png">
            </div>
            <div class="container">
                <div class="row align-items-center g-5 section-title-space">
                    <div class="col-xl-7 col-lg-7">
                        <div class="rs-section-title-wrapper">
                            <span class="rs-section-subtitle has-theme-yellow justify-content-start">
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                    fill="none">
                                    <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                        fill="#EA5501"></path>
                                </svg>
                                Best Services
                            </span>
                            <h2 class="rs-section-title rs-split-text-enable split-in-fade">Get best industrial services
                                for
                                your business</h2>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-5">
                        <!-- If we need navigation buttons -->
                        <div class="rs-services-navigation">
                            <button class="swiper-button-prev rs-swiper-btn has-theme-yellow"><i
                                    class="fa-regular fa-arrow-left"></i></button>
                            <button class="swiper-button-next rs-swiper-btn has-theme-yellow"><i
                                    class="fa-regular fa-arrow-right"></i></button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="rs-services-slide-wrapper">
                        <div class="swiper" data-clone-slides="false" data-loop="false" data-speed="1500"
                            data-autoplay="true" data-dots-dynamic="false" data-hover-pause="true" data-effect="false"
                            data-delay="1000" data-item="3" data-item-xl="3" data-item-lg="3" data-item-md="2"
                            data-item-sm="1" data-item-xs="1" data-item-mobile="1" data-margin="30">
                            <div class="swiper-wrapper process-counts">
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-21.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Best
                                                    innovations in
                                                    metallurgy</a></h5>
                                            <!--<p class="descrip"> Consectetur ipiscing elit tellus ullam corper mattis
                                            </p>-->
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-22.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Manufacturer
                                                    of tin lead
                                                    and lead...</a></h5>
                                           
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-23.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> State of the
                                                    art for
                                                    hight control in... </a></h5>
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-08.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Automation
                                                    industry
                                                    management</a></h5>
                                                                                        
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-21.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Best
                                                    innovations in
                                                    metallurgy</a></h5>
                                                                                        
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-22.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Manufacturer
                                                    of tin lead
                                                    and lead...</a></h5>
                                                                                      
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-23.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> State of the
                                                    art for
                                                    hight control in... </a></h5>
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<!-- testimonial area start -->
<section class="rs-faq-area section-space rs-faq-one">
            <div class="rs-faq-bg-thumb" data-background="assets/images/bg/faq-bg-01.png"></div>
            <div class="container">
                <div class="row g-5">
                    <div class="col-xl-6 col-lg-6">
                        <!-- faq area start -->
                        <div class="rs-faq-wrapper">
                            <div class="rs-section-title-wrapper section-title-space">
                                <span class="rs-section-subtitle has-theme-red justify-content-start">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                        fill="none">
                                        <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                            fill="#EA5501"></path>
                                    </svg>
                                    Faq's
                                </span>
                                <h2 class="rs-section-title rs-split-text-enable split-in-fade">General Questions</h2>
                            </div>
                            <div class="rs-faq-content rs-accordion-one has-theme-red">
                                <div class="accordion-wrapper">
                                    <div class="accordion" id="accordionExampleOne">
                                        <div class="rs-accordion-item has-border-active">
                                            <h4 class="accordion-header" id="headingOne">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-expanded="true"
                                                    aria-controls="collapseOne">
                                                    01. Why is sand important for industry?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h4>
                                            <div id="collapseOne" class="accordion-collapse collapse show"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body"> Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="rs-accordion-item has-border-active">
                                            <h6 class="accordion-header" id="headingTwo">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                    aria-expanded="false" aria-controls="collapseTwo">
                                                    02. Can I switch to a different plan?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h6>
                                            <div id="collapseTwo" class="accordion-collapse collapse"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body">Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.</div>
                                            </div>
                                        </div>
                                        <div class="rs-accordion-item has-border-active">
                                            <h6 class="accordion-header" id="headingThree">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                    aria-expanded="false" aria-controls="collapseThree">
                                                    03. What should I wear for an industry treatment?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h6>
                                            <div id="collapseThree" class="accordion-collapse collapse"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body">Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.</div>
                                            </div>
                                        </div>
                                        <div class="rs-accordion-item has-border-active">
                                            <h6 class="accordion-header" id="headingFour">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseFour"
                                                    aria-expanded="false" aria-controls="collapseFour">
                                                    04. Can you give tips for the stock market?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h6>
                                            <div id="collapseFour" class="accordion-collapse collapse"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body">Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- faq area end -->
                    </div>
                    <!-- testimonial area start -->
                    <div class="col-xl-6 col-lg-6">
                        <div class="rs-testimonial-wrapper rs-testimonial-two rs-swiper">
                            <div class="rs-section-title-wrapper section-title-space">
                                <span class="rs-section-subtitle has-theme-red justify-content-start">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                        fill="none">
                                        <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                            fill="#EA5501"></path>
                                    </svg>
                                    Reviews
                                </span>
                                <h2 class="rs-section-title rs-split-text-enable split-in-fade">Customer Feedback</h2>
                            </div>
                            <div class="rs-testimonial-slider-wrapper">
                                <div class="swiper" data-clone-slides="false" data-loop="true" data-speed="1500"
                                    data-autoplay="true" data-dots-dynamic="false" data-hover-pause="true"
                                    data-effect="false" data-delay="2500" data-item="1" data-item-xl="1"
                                    data-item-lg="1" data-item-md="1" data-item-sm="1" data-item-xs="1"
                                    data-item-mobile="1" data-margin="30" data-margin-xl="30">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="rs-testimonial-item">
                                                <div class="rs-testimonial-avater-thumb">
                                                    <div class="rs-testimonial-thumb">
                                                        <img src="assets/images/user/user-thumb-01.png" alt="image">
                                                    </div>
                                                    <div class="rs-testimonial-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="29"
                                                            viewBox="0 0 40 29" fill="none">
                                                            <path
                                                                d="M2.85714 29H11.4286L17.1429 17.4V0H0V17.4H8.57143L2.85714 29ZM25.7143 29H34.2857L40 17.4V0H22.8571V17.4H31.4286L25.7143 29Z"
                                                                fill="white" fill-opacity="0.4"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                                <div class="rs-testimonial-content">
                                                    <h5 class="rs-testimonial-title">Best Company</h5>
                                                    <div class="rs-testimonial-description">
                                                        <p>Podcasting operational change management inside of workflows
                                                            to establish a
                                                            framework Taking seamless key performance indicators.</p>
                                                    </div>
                                                    <div class="rs-tesimonial-avater-info">
                                                        <h6 class="rs-testimonial-avater-title">Nayeem</h6>
                                                        <span class="rs-testimonial-avater-designation">Manager</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="rs-testimonial-item">
                                                <div class="rs-testimonial-avater-thumb">
                                                    <div class="rs-testimonial-thumb">
                                                        <img src="assets/images/user/user-thumb-02.png" alt="image">
                                                    </div>
                                                    <div class="rs-testimonial-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="29"
                                                            viewBox="0 0 40 29" fill="none">
                                                            <path
                                                                d="M2.85714 29H11.4286L17.1429 17.4V0H0V17.4H8.57143L2.85714 29ZM25.7143 29H34.2857L40 17.4V0H22.8571V17.4H31.4286L25.7143 29Z"
                                                                fill="white" fill-opacity="0.4"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                                <div class="rs-testimonial-content">
                                                    <h5 class="rs-testimonial-title">Best Company</h5>
                                                    <div class="rs-testimonial-description">
                                                        <p>Podcasting operational change management inside of workflows
                                                            to establish a
                                                            framework Taking seamless key performance indicators.</p>
                                                    </div>
                                                    <div class="rs-tesimonial-avater-info">
                                                        <h6 class="rs-testimonial-avater-title">Abdur Rashid</h6>
                                                        <span class="rs-testimonial-avater-designation">Founder &amp;
                                                            CEO</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="rs-testimonial-item">
                                                <div class="rs-testimonial-avater-thumb">
                                                    <div class="rs-testimonial-thumb">
                                                        <img src="assets/images/user/user-thumb-03.png" alt="image">
                                                    </div>
                                                    <div class="rs-testimonial-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="29"
                                                            viewBox="0 0 40 29" fill="none">
                                                            <path
                                                                d="M2.85714 29H11.4286L17.1429 17.4V0H0V17.4H8.57143L2.85714 29ZM25.7143 29H34.2857L40 17.4V0H22.8571V17.4H31.4286L25.7143 29Z"
                                                                fill="white" fill-opacity="0.4"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                                <div class="rs-testimonial-content">
                                                    <h5 class="rs-testimonial-title">Best Company</h5>
                                                    <div class="rs-testimonial-description">
                                                        <p>Podcasting operational change management inside of workflows
                                                            to establish a
                                                            framework Taking seamless key performance indicators.</p>
                                                    </div>
                                                    <div class="rs-tesimonial-avater-info">
                                                        <h6 class="rs-testimonial-avater-title">Tom Hanks</h6>
                                                        <span class="rs-testimonial-avater-designation">Customer</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- If we need navigation buttons -->
                                    <div class=" rs-testimonial-navigation">
                                        <button
                                            class="swiper-button-prev rs-swiper-btn has-bg-white hover-black has-small"><i
                                                class="fa-regular fa-arrow-left"></i></button>
                                        <button
                                            class="swiper-button-next rs-swiper-btn has-bg-white hover-black has-small"><i
                                                class="fa-regular fa-arrow-right"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- testimonial area end -->
                </div>
            </div>
        </section>
<!-- testimonial area start -->

<!-- brand area start -->
<section class="rs-brand-area rs-brand-one section-space-bottom primary-bg rs-swiper">
	<div class="container">
		<div class="row  g-5 section-title-space justify-content-center">
			<div class="col-xl-7 col-lg-7">
				<div class="rs-section-title-wrapper text-center">
					<span class="rs-section-subtitle has-theme-orange">
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                    fill="none">
                                    <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                        fill="#EA5501"></path>
                                </svg>
                                Partners
                            </span>
				
					<h2 class="rs-section-title rs-split-text-enable split-in-fade">Partners Who Trust Industrie
                            </h2>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xl-12">
				<div class="rs-brand-wrapper">
					<div class="swiper" data-clone-slides="false" data-loop="true" data-speed="1500" data-autoplay="false" data-dots-dynamic="false" data-center-mode="false" data-hover-pause="true" data-effect="false" data-delay="1500" data-item="6" data-item-xl="4" data-item-lg="4" data-item-md="3" data-item-sm="2" data-item-xs="2" data-item-mobile="1">
						<div class="swiper-wrapper">
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-02.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-03.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-04.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-05.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-06.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-07.png" alt="image">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
$content = ob_get_clean();
include 'layout/layout.php';
?>