   <?php
   $title = "PP / HDPE Raffia Woven Sack Production Line | Heaven Extrusions";
   $meta_description = "High-performance PP / HDPE Raffia Woven Sack Bag Production Line. Complete production solution with technical specifications and machine video.";
   ob_start();
   ?>

<style>
	/* ---------- FLOW SECTION ---------- */
	.production-flow {
		display: flex;
		flex-direction: column;
		gap: 22px;
		margin-top: 20px;
	}
	
	.flow-item {
		display: grid;
		grid-template-columns: 280px 1fr;
		gap: 20px;
		padding: 18px 20px;
		border-left: 4px solid #e53935;
		background: #fafafa;
		border-radius: 6px;
	}
	
	.flow-title {
		font-weight: 700;
		font-size: 16px;
	}
	
	.flow-desc {
		font-size: 15px;
		line-height: 1.7;
		color: #444;
	}
	
	@media(max-width:768px) {
		.flow-item {
			grid-template-columns: 1fr;
		}
	}
	
	/* ---------- CTA ---------- */
	.product-cta {
		display: flex;
		gap: 15px;
		margin: 20px 0 30px;
		flex-wrap: wrap;
	}
	
	.cta-btn {
		padding: 12px 22px;
		font-size: 15px;
		font-weight: 600;
		border-radius: 5px;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 8px;
		transition: .3s;
	}
	
	.cta-btn.primary {
		background: #e53935;
		color: #fff;
	}
	
	.cta-btn.primary:hover {
		background: #c62828;
	}
	
	.cta-btn.secondary {
		background: #fff;
		border: 2px solid #2d2a8c;
		color: #2d2a8c;
	}
	
	.cta-btn.secondary:hover {
		background: #2d2a8c;
		color: #fff;
	}
	
	/* ---------- TABLE ---------- */
	.raffia-tech-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 14px;
	}
	
	.raffia-tech-table th,
	.raffia-tech-table td {
		border: 1px solid #ddd;
		padding: 10px;
		text-align: center;
	}
	
	.raffia-tech-table thead {
		background: #2d2a8c;
		color: #fff;
	}
	
	@media(max-width:768px) {
		.raffia-tech-table {
			min-width: 900px;
		}
	}
	
	/* ---------- VIDEO MODAL ---------- */
	.video-modal {
		display: none;
		position: fixed;
		inset: 0;
		background: rgba(0, 0, 0, .85);
		z-index: 9999;
	}
	
	.video-content {
		max-width: 800px;
		margin: 80px auto;
		background: #000;
		padding: 10px;
		position: relative;
	}
	
	.close-video {
		position: absolute;
		top: -35px;
		right: 0;
		font-size: 30px;
		color: #fff;
		cursor: pointer;
	}
	
	.product-navigation {
		display: flex;
		justify-content: space-between;
		gap: 20px;
		margin-top: 50px;
		flex-wrap: wrap;
	}
	
	.nav-btn {
		text-decoration: none;
		border: 2px solid #e53935;
		padding: 14px 22px;
		border-radius: 6px;
		font-weight: 600;
		color: #e53935;
		transition: 0.3s;
		display: inline-flex;
		flex-direction: column;
		line-height: 1.3;
		max-width: 260px;
	}
	
	.nav-btn span {
		font-size: 13px;
		font-weight: 500;
		opacity: 0.8;
	}
	
	.nav-btn:hover {
		background: #e53935;
		color: #fff;
	}
	
	.prev-product-btn {
		align-items: flex-start;
		text-align: left;
	}
	
	.next-product-btn {
		align-items: flex-end;
		text-align: right;
	}
	
	@media (max-width: 768px) {
		.product-navigation {
			flex-direction: column;
		}
		.nav-btn {
			max-width: 100%;
			align-items: center;
			text-align: center;
		}
	}
	
	.cta-btn.whatsapp {
		background: #25D366;
		color: #fff;
	}
	
	.cta-btn.whatsapp:hover {
		background: #1ebe5d;
	}

</style>


<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
	<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
	<div class="container">
		<div class="row">
			<div class="col-xxl-6 col-xl-8 col-lg-8">
				<div class="rs-breadcrumb-content-wrapper">
					<div class="rs-breadcrumb-title-wrapper">
						<h1 class="rs-breadcrumb-title">Cast Stretch Film Extrusion Line</h1>
					</div>
					<div class="rs-breadcrumb-menu">
						<nav>
							<ul>
								<li><span><a href="index.php">Home</a></span>
								</li>
								<li><span>Products</span>
								</li>
								<li><span>Cast Stretch Film Extrusion Line</span>
								</li>
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
   <!-- breadcrumb area end -->

   <!-- portfolio area start -->
<section class="rs-portfolio-area section-space">
	<div class="container">
		<div class="row g-2">
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">
					<div class="portfolio-details-thumb-wrapper">
						<div class="row g-5">
							<div class="col-xl-7 col-lg-7 col-md-7 col-sm-7">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/cast-stretch-film-extrusion-line/1.jpg" alt="image">
								</div>
							</div>

							<div class="col-xl-5 col-lg-5 col-md-5 col-sm-5">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/cast-stretch-film-extrusion-line/2.png" alt="image">
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<h3>Cast Stretch Film Extrusion Line</h3>
				<h6 class="mt-4">Premium 2-Layer & 3-Layer Co-Extrusion Solutions</h6>
				<p align="justify">Heaven Extrusions' Cast Film Extrusion Lines are engineered to deliver world-class film quality, consistent thickness, and high-speed productivity for industrial, packaging, and lamination applications. Available in 2-layer (A-B) and 3-layer (A-B-A / A-B-C) configurations, these lines combine robust mechanical
design, advanced extrusion technology, and smart automation to maximize output and reduce operational costs.</p>
				
				<div class="product-cta">
					<a href="https://wa.me/919999999999?text=Hello%20Heaven%20Extrusions,%20I%20am%20interested%20in%20the%20Extrusion%20Coating%20Tarpaulin%20Lamination%20Line." target="_blank" class="cta-btn whatsapp">
   <i class="fab fa-whatsapp"></i> WhatsApp
</a>
				


					<a href="contact-us.html" class="cta-btn primary">
        Get Inquiry
    </a>
				

					<a href="#productionVideo" class="cta-btn secondary video-btn">
        ▶ Watch Video
    </a>
				

				</div>




			</div>
			
			
					<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">

						<h6 class="rs-portfolio-details-title">Why Heaven Cast Film Lines?</h6>

						<p class="mb-20 mt-15" align="justify">
							Heaven Extrusions provides an end-to-end, integrated production solution for PP / HDPE Raffia Woven Sack manufacturing. From raw material processing to finished bag conversion, every stage is engineered for high efficiency, durability, and consistent output quality.
						</p>

						<div class="production-flow">

							<div class="flow-item">
								<div class="flow-title">Consistent Film Quality :</div>
								<div class="flow-desc">
									 Mirror-finish chill rolls & melt pump technology ensure uniform thickness, optical clarity, & minimal defects. </div>
							</div>

							<div class="flow-item">
								<div class="flow-title">High-Speed, High-Output :</div>
								<div class="flow-desc">
									 Designed for continuous 24x7 operation, achieving maximum productivity with minimal energy consumption.</div>
							</div>

							<div class="flow-item">
								<div class="flow-title">Smart Automation :</div>
								<div class="flow-desc"> PLC + HMI controls, recipe memory, and process monitoring allow precision control of film width, thickness, and layer ratio.
								</div>
							</div>

							<div class="flow-item">
								<div class="flow-title">Versatile Co-Extrusion Options :</div>
								<div class="flow-desc">
									 2-layer or 3-layer co-extrusion enables barrier properties, lamination-ready films, and multi-functional packaging applications.</div>
							</div>

							<div class="flow-item">
								<div class="flow-title">Minimal Waste, Maximum ROI :</div>
								<div class="flow-desc">
									Edge-trimming with recycling, automatic winder, and tension control optimize efficiency and reduce material loss.</div>
							</div>

						</div>




						<h6 class="rs-portfolio-details-title mt-15">Standard Features</h6>
						<p>High-output screw & barrel, Mirror chill roll (dual-zone cooling), Fully Auto winder unit, Edge trim system +
grinder, Touchscreen HMI with full diagnostics</p>

						<h6 class="rs-portfolio-details-title">Optional Upgrades </h6>
						<p>Co-Extrusion (A-B / A-B-A), Auto die lip control (ADC), Air knife for ultra-thin film, Static removal system,
Inline surface treatment, Jumbo roll winder options</p>
						<h6 class="rs-portfolio-details-title">Applications </h6>
						<p>Flexible Packaging, Lamination Grade PE Film, Cling Film & Stretch Film, Industrial Protection Film, HighTransparency Film, Food & Pharma Packaging</p>

					</div>
					

				</div>
			</div>
			
			
			
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mt-4">Technical Specification</h3>
						<div class="table-responsive raffia-table-wrapper">
							<table class="raffia-tech-table">
								<thead>
									<tr>
										<th>Model</th>
										<th>Screw Size(MM)</th>
										<td>Die Width(MM)</td>
										<td>Film Thickness Range (MICRON)</td>
										<td>Max Line Speed (MPM)</td>
										<td>Max. Melting Capacity (KG/HR.)</td>
										<td>Total Connected Load(KW)</td>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td>HSCFL/1000</td>
										<td>55/70/55</td>
										<td>1250</td>
										<td>20 to 75</td>
										<td>125</td>
										<td>100 to 120</td>
										<td>85 kw</td>
									</tr>
									<tr>
										<td>HSCFL/1500</td>
										<td>65/90/65</td>
										<td>1750</td>
										<td>20 to 75</td>
										<td>125</td>
										<td>140 to 180</td>
										<td>120 kw</td>
									</tr>
									<tr>
										<td>HSCFL/2000</td>
										<td>70/100/70</td>
										<td>2250</td>
										<td>20 to 75</td>
										<td>100</td>
										<td>200 to 220</td>
										<td>160 kw</td>
									</tr>
														
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div class="product-navigation">
				<a href="air-bubble-film-extrusion-line" class="nav-btn prev-product-btn">
        ← Previous
        
    </a>
			

				<a href="cast-embossed-film-extrusion-line" class="nav-btn next-product-btn">
        Next →
        
    </a>
			
			</div>

		</div>

	</div>
	</div>
</section>
   <!-- ================= VIDEO MODAL ================= -->
<div id="productionVideo" class="video-modal">
	<div class="video-content">
		<span class="close-video">&times;</span>
		<iframe width="100%" height="450" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allowfullscreen></iframe>
	</div>
</div>

<script>
	document.addEventListener( "DOMContentLoaded", function () {

		document.querySelectorAll( '.video-btn' ).forEach( btn => {
			btn.addEventListener( 'click', function ( e ) {
				e.preventDefault();
				document.getElementById( 'productionVideo' ).style.display = 'block';
			} );
		} );

		document.querySelector( '.close-video' ).addEventListener( 'click', function () {
			document.getElementById( 'productionVideo' ).style.display = 'none';
		} );

	} );
</script>

   
   <?php
   $content = ob_get_clean();
   include 'layout/layout.php';
   ?>