   <?php
   $title = "PP / HDPE Raffia Woven Sack Production Line | Heaven Extrusions";
   $meta_description = "High-performance PP / HDPE Raffia Woven Sack Bag Production Line. Complete production solution with technical specifications and machine video.";
   ob_start();
   ?>

<style>
	/* ---------- FLOW SECTION ---------- */
	.production-flow {
		display: flex;
		flex-direction: column;
		gap: 22px;
		margin-top: 20px;
	}
	
	.flow-item {
		display: grid;
		grid-template-columns: 280px 1fr;
		gap: 20px;
		padding: 18px 20px;
		border-left: 4px solid #e53935;
		background: #fafafa;
		border-radius: 6px;
	}
	
	.flow-title {
		font-weight: 700;
		font-size: 16px;
	}
	
	.flow-desc {
		font-size: 15px;
		line-height: 1.7;
		color: #444;
	}
	
	@media(max-width:768px) {
		.flow-item {
			grid-template-columns: 1fr;
		}
	}
	
	/* ---------- CTA ---------- */
	.product-cta {
		display: flex;
		gap: 15px;
		margin: 20px 0 30px;
		flex-wrap: wrap;
	}
	
	.cta-btn {
		padding: 12px 22px;
		font-size: 15px;
		font-weight: 600;
		border-radius: 5px;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 8px;
		transition: .3s;
	}
	
	.cta-btn.primary {
		background: #e53935;
		color: #fff;
	}
	
	.cta-btn.primary:hover {
		background: #c62828;
	}
	
	.cta-btn.secondary {
		background: #fff;
		border: 2px solid #2d2a8c;
		color: #2d2a8c;
	}
	
	.cta-btn.secondary:hover {
		background: #2d2a8c;
		color: #fff;
	}
	
	/* ---------- TABLE ---------- */
	.raffia-tech-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 14px;
	}
	
	.raffia-tech-table th,
	.raffia-tech-table td {
		border: 1px solid #ddd;
		padding: 10px;
		text-align: center;
	}
	
	.raffia-tech-table thead {
		background: #2d2a8c;
		color: #fff;
	}
	
	@media(max-width:768px) {
		.raffia-tech-table {
			min-width: 900px;
		}
	}
	
	/* ---------- VIDEO MODAL ---------- */
	.video-modal {
		display: none;
		position: fixed;
		inset: 0;
		background: rgba(0, 0, 0, .85);
		z-index: 9999;
	}
	
	.video-content {
		max-width: 800px;
		margin: 80px auto;
		background: #000;
		padding: 10px;
		position: relative;
	}
	
	.close-video {
		position: absolute;
		top: -35px;
		right: 0;
		font-size: 30px;
		color: #fff;
		cursor: pointer;
	}
	
	.product-navigation {
		display: flex;
		justify-content: space-between;
		gap: 20px;
		margin-top: 50px;
		flex-wrap: wrap;
	}
	
	.nav-btn {
		text-decoration: none;
		border: 2px solid #e53935;
		padding: 14px 22px;
		border-radius: 6px;
		font-weight: 600;
		color: #e53935;
		transition: 0.3s;
		display: inline-flex;
		flex-direction: column;
		line-height: 1.3;
		max-width: 260px;
	}
	
	.nav-btn span {
		font-size: 13px;
		font-weight: 500;
		opacity: 0.8;
	}
	
	.nav-btn:hover {
		background: #e53935;
		color: #fff;
	}
	
	.prev-product-btn {
		align-items: flex-start;
		text-align: left;
	}
	
	.next-product-btn {
		align-items: flex-end;
		text-align: right;
	}
	
	@media (max-width: 768px) {
		.product-navigation {
			flex-direction: column;
		}
		.nav-btn {
			max-width: 100%;
			align-items: center;
			text-align: center;
		}
	}
	
	.cta-btn.whatsapp {
		background: #25D366;
		color: #fff;
	}
	
	.cta-btn.whatsapp:hover {
		background: #1ebe5d;
	}

</style>


<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
	<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
	<div class="container">
		<div class="row">
			<div class="col-xxl-6 col-xl-8 col-lg-8">
				<div class="rs-breadcrumb-content-wrapper">
					<div class="rs-breadcrumb-title-wrapper">
						<h1 class="rs-breadcrumb-title">Air Bubble Film Extrusion Line</h1>
					</div>
					<div class="rs-breadcrumb-menu">
						<nav>
							<ul>
								<li><span><a href="index.php">Home</a></span>
								</li>
								<li><span>Products</span>
								</li>
								<li><span>Air Bubble Film Extrusion Line</span>
								</li>
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
   <!-- breadcrumb area end -->

   <!-- portfolio area start -->
<section class="rs-portfolio-area section-space">
	<div class="container">
		<div class="row g-2">
			<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">
					<div class="portfolio-details-thumb-wrapper">
						<div class="row g-5">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/air-bubble-film-extrusion-line/1.jpg" alt="image">
								</div>
							</div>

							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/air-bubble-film-extrusion-line/2.png" alt="image">
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
			<div class="col-xl-6 col-lg-6">
				<h3>Air Bubble Film Extrusion Line</h3>

				<p align="justify">The Heaven Extrusions Air Bubble Film Extrusion Line is engineered for high-quality bubble film production
used in protective packaging, cushioning, and industrial applications. Designed with advanced twinextruder systems, precision bubble dies, and stable cooling towers, the line ensures uniform bubble size,
strong film strength, and excellent air retention.</p>
				<p align="justify">This line supports single-layer & co-extrusion bubble films (A-B / A-B-A) for enhanced barrier & cushioning properties. Equipped with PLC + HMI control, automatic thickness & bubble diameter control, & high-speed winding systems, it delivers consistent quality at maximum productivity.
Whether producing packaging bubble wrap, anti-static bubble film, or industrial cushioning films, this line provides robust performance, energy efficiency, & low maintenance, suitable for both domestic & export markets.</p>
				<div class="product-cta">
					<a href="https://wa.me/919999999999?text=Hello%20Heaven%20Extrusions,%20I%20am%20interested%20in%20the%20Extrusion%20Coating%20Tarpaulin%20Lamination%20Line." target="_blank" class="cta-btn whatsapp">
   <i class="fab fa-whatsapp"></i> WhatsApp
</a>
				


					<a href="contact-us.html" class="cta-btn primary">
        Get Inquiry
    </a>
				

					<a href="#productionVideo" class="cta-btn secondary video-btn">
        ▶ Watch Video
    </a>
				

				</div>




			</div>
			
			
					<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Standard Features:</h3>
                                
						<div class="rs-postbox-details-feature">
                                    <ul>
                                        <li>High-output extruder with energy-efficient screw</li>
                                        <li>Precision bubble die with adjustable air ring </li>
                                        <li>Bubble diameter & thickness control via PLC + HMI</li>
										<li>Automatic winder (center or surface) </li>
										<li>Automatic winder (center or surface) </li>
										<li>Edge trimming and recycling </li>
										
                                    </ul>
                                </div>                    
						
					</div>

				</div>
			</div>
			<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Optional Features:</h3>
                                
						<div class="rs-postbox-details-feature">
                                    <ul>
                                        <li>Multi-layer co-extrusion (A-B / A-B-A)</li>
                                        <li>Anti-static treatment </li>
                                        <li>Corona treatment</li>
										<li>Jumbo roll winder & lamination-ready output </li>
																			
                                    </ul>
                                </div>
                                
						

					</div>

				</div>
			</div>
			
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title">Applications:</h3>
						
						
						<p align="justify">	Protective Packaging for Electrical & Electronic Appliances, Industrial Cushioning & Bubble Insulation Film, Anti-Static Bubble Film for Glassware & Ceramic Product, Jumbo Roll Bubble Film for Engineering & Automobile Product, Cushioning film for Fragile items and Crafting Material, Protect Medical & Pharmaceutical Product, E-Commerce companies and Shopping Mall Uses </p>
					</div>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Technical Specification</h3>
						<div class="table-responsive raffia-table-wrapper">
							<table class="raffia-tech-table">
								<thead>
									<tr>
										<th>Model</th>
										<th>Screw Size(MM)</th>
										<td>Die Width(MM)</td>
										<td>Film Thickness Range in GSM</td>
										<td>Max Line Speed (MPM)</td>
										<td>Max Prod Capacity (KG/HR.)</td>
										<td>Total Connected Load (KW)</td>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td>HEABS/1000</td>
										<td>70</td>
										<td>1250</td>
										<td>30 to 80</td>
										<td>50</td>
										<td>70</td>
										<td>70 kw</td>
									</tr>
									<tr>
										<td>HEABS/1200</td>
										<td>80</td>
										<td>1500</td>
										<td>30 to 80</td>
										<td>50</td>
										<td>85</td>
										<td>85 kw</td>
									</tr>
									<tr>
										<td>HEABS/1500</td>
										<td>90</td>
										<td>1750</td>
										<td>30 to 80</td>
										<td>50</td>
										<td>120</td>
										<td>95 kw</td>
									</tr>
									<tr>
										<td>HEABS/2000</td>
										<td>100</td>
										<td>2250</td>
										<td>30 to 80</td>
										<td>50</td>
										<td>160</td>
										<td>100 kw</td>
									</tr>
																		
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div class="product-navigation">
				<a href="biodegradable-bags-production-line" class="nav-btn prev-product-btn">
        ← Previous
        
    </a>
			

				<a href="cast-stretch-film-extrusion-line" class="nav-btn next-product-btn">
        Next →
        
    </a>
			
			</div>

		</div>

	</div>
	</div>
</section>
   <!-- ================= VIDEO MODAL ================= -->
<div id="productionVideo" class="video-modal">
	<div class="video-content">
		<span class="close-video">&times;</span>
		<iframe width="100%" height="450" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allowfullscreen></iframe>
	</div>
</div>

<script>
	document.addEventListener( "DOMContentLoaded", function () {

		document.querySelectorAll( '.video-btn' ).forEach( btn => {
			btn.addEventListener( 'click', function ( e ) {
				e.preventDefault();
				document.getElementById( 'productionVideo' ).style.display = 'block';
			} );
		} );

		document.querySelector( '.close-video' ).addEventListener( 'click', function () {
			document.getElementById( 'productionVideo' ).style.display = 'none';
		} );

	} );
</script>

   
   <?php
   $content = ob_get_clean();
   include 'layout/layout.php';
   ?>