<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'inc/config.php';

// Prepare response array
$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Create
    if ($action === 'Create') {
        $title = mysqli_real_escape_string($conn, $_POST['title']);
		$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title), '-'));
        $description = mysqli_real_escape_string($conn, $_POST['description']);

        // File upload
        $photoPath = null;
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
            $fileExtension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('photo_', true) . '.' . $fileExtension;
            $photoPath = 'uploads/' . $uniqueName;
            move_uploaded_file($_FILES['photo']['tmp_name'], $photoPath);
        }

        $sql = "INSERT INTO service_categories (title,slug, description, status, image) 
                VALUES ('$title','$slug', '$description', '1', " . ($photoPath ? "'$photoPath'" : "NULL") . ")";

        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'Create', 'message' => 'Service added successfully.'];
        } else {
            $response = ['status' => 'Error', 'message' => 'Error creating : ' . mysqli_error($conn)];
        }
    }

    // Update
    elseif ($action === 'Update') {
        $id = intval($_POST['id']);
        $title = mysqli_real_escape_string($conn, $_POST['title']);
		$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title), '-'));
        $description = mysqli_real_escape_string($conn, $_POST['description']);

        $photoPath = null;
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
            $fileExtension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('photo_', true) . '.' . $fileExtension;
            $photoPath = 'uploads/' . $uniqueName;
            move_uploaded_file($_FILES['photo']['tmp_name'], $photoPath);
        }

        if ($photoPath !== null) {
            // Delete old image
            $check = mysqli_query($conn, "SELECT image FROM service_categories WHERE id = $id");
            if ($check && mysqli_num_rows($check) > 0) {
                $oldImage = mysqli_fetch_assoc($check)['image'];
                if ($oldImage && file_exists($oldImage)) unlink($oldImage);
            }

            $sql = "UPDATE service_categories SET title='$title',slug='$slug', description='$description', image='$photoPath' WHERE id=$id";
        } else {
            $sql = "UPDATE service_categories SET title='$title',slug='$slug', description='$description' WHERE id=$id";
        }

        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'Update', 'message' => 'updated successfully.'];
        } else {
            $response = ['status' => 'Error', 'message' => 'Error updating : ' . mysqli_error($conn)];
        }
    }

    // Select
    elseif ($action === 'Select') {
        $id = intval($_POST['id']);
        $sql = "SELECT * FROM service_categories WHERE id = $id";
        $result = mysqli_query($conn, $sql);

        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $row['image'] = $row['image'] ?: null;
            $response = ['status' => 'Select', 'data' => $row];
        } else {
            $response = ['status' => 'Error', 'message' => 'not found'];
        }
    }
	
	elseif ($action === 'StatusChange') {
    $id = intval($_POST['id']);

    $stmt = $conn->prepare("SELECT status FROM service_categories WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    $newStatus = ($row['status'] == '1') ? 0 : 1;

    $update = $conn->prepare("UPDATE service_categories SET status = ? WHERE id = ?");
    if (!$update) {
        echo json_encode(['success' => false, 'message' => 'Update prepare failed: ' . $conn->error]);
        exit;
    }

    $update->bind_param("ii", $newStatus, $id);
    $update->execute();

    echo json_encode(['success' => true, 'new_status' => $newStatus]);
    exit;
}



    // Delete
    elseif ($action === 'Delete') {
        $id = intval($_POST['id']);

        // Delete image if exists
        $check = mysqli_query($conn, "SELECT image FROM service_categories WHERE id = $id");
        if ($check && mysqli_num_rows($check) > 0) {
            $row = mysqli_fetch_assoc($check);
            if ($row['image'] && file_exists($row['image'])) {
                unlink($row['image']);
            }
        }

        $sql = "DELETE FROM service_categories WHERE id = $id";
        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'Success', 'message' => 'deleted successfully'];
        } else {
            $response = ['status' => 'Error', 'message' => 'Error deleting : ' . mysqli_error($conn)];
        }
    }

    // Invalid Action
    else {
        $response = ['status' => 'Error', 'message' => 'Invalid action'];
    }

    // Send JSON response
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
