<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>
	<link rel="stylesheet" href="assets/vendor/libs/quill/editor.css"/>
	<div class="container-xxl flex-grow-1 container-p-y">
		<div class="d-flex flex-column justify-content-center">
			<h5 class="card-header mb-2">Product Details Add</h5>
		</div>
		<button class="btn btn-primary" onclick="window.location.href='product_details_list.php'" type="button"><span><i class="ti ti-list me-sm-1"></i> <span class="d-none d-sm-inline-block">Product Details List</span></span></button>
		<div class="row">
			<!-- Basic Layout -->
			<div class="col-12">
				<div class="card mb-6">

					<form class="card-body" id="ProductDetailForm" method="POST" enctype="multipart/form-data">
						<div class="row g-4">
							<div class="col-md-12">
								<label class="form-label" for="cat_id">Product Category</label>
								<select class="form-select" id="cat_id" name="cat_id" required>
									<option value="">Select..</option>
									<?php
									$sql = "SELECT id, catname FROM product_categories WHERE status = '1' ORDER BY catname ASC";
									$result = mysqli_query( $conn, $sql );
									if ( mysqli_num_rows( $result ) > 0 ) {
										while ( $row = mysqli_fetch_assoc( $result ) ) {
											echo "<option value='" . $row[ 'id' ] . "'>" . ucwords( strtolower( $row[ 'catname' ] ) ) . "</option>";
										}
									} else {
										echo "<option>No Cat available</option>";
									}
									?>
								</select>
							</div>
							<div class="col-md-12">
								<label class="form-label" for="subcat_id">Product SubCategory</label>
								<select class="form-select" id="subcat_id" name="subcat_id" required>
									<option value="">Select..</option>
									
								</select>
							</div>
							<div class="col-md-12">
								<label class="form-label" for="Description">Short Description</label>

								<textarea class="form-control" id="short_description" name="short_description" rows="6" ></textarea>

							</div>
							<div class="col-md-12">
								<label class="form-label" for="Description">Product Description</label>

								<div id="full_description" name="full_description" style="height: 300px;"></div>

							</div>
							
							<!--<div class="col-md-12">-->
							<!--	<label class="form-label" for="Title">Title</label>-->
							<!--	<input type="text" class="form-control" id="title" required>-->
							<!--</div>-->
							<div class="col-md-12">
								<label class="form-label">Other Description</label>
								<div id="product_description" name="product_description" style="height: 300px;"></div>
							</div>

							<!-- Blog Image Upload -->
							<div class="col-md-12">
								<label class="form-label" for="multicol-email">Image</label>

								<input type="file" id="product_image" name="product_image" class="form-control" accept="image/png, image/jpeg, image/jpg" onchange="loadFile(event)"/>
								<script>
									var loadFile = function ( event ) {
										var output = document.getElementById( 'output' );
										output.src = URL.createObjectURL( event.target.files[ 0 ] );
										output.onload = function () {
											URL.revokeObjectURL( output.src ) // free memory
										}
									};
								</script>

							</div>
							<div class="col-md-3">


								<img id="output" src="" height="70" width="70" style="display: none;"/>


							</div>
						</div>

											
						<!-- Buttons -->
						<div class="pt-6">
							<input type="hidden" id="upd" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
							<input type="hidden" name="id" id="id">
							<input type="hidden" name="action" id="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
							<button type="submit" class="btn btn-primary me-2">
								<?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?> </button>
							<button type="reset" class="btn btn-label-secondary">Cancel</button>
						</div>
					</form>
					<script>
$(document).ready(function () {
	//  Load subcategories based on selected category
	function loadSubcategories(catId, selectedSubcatId = '') {
		if (!catId) {
			$('#subcat_id').html('<option value="">Select..</option>');
			return;
		}

		$.ajax({
			url: 'controllers/ProductCategoryController.php',
			method: 'POST',
			data: { action: 'getSubcategoriesByCategory', cat_id: catId },
			success: function (res) {
				const subcats = JSON.parse(res);
				let options = '<option value="">Select..</option>';
				subcats.forEach(subcat => {
					const selected = subcat.id == selectedSubcatId ? 'selected' : '';
					options += `<option value="${subcat.id}" ${selected}>${subcat.subcat_name}</option>`;
				});
				$('#subcat_id').html(options);
			},
			error: function () {
				alert('Failed to fetch subcategories.');
			}
		});
	}

	// Trigger load when user selects category
	$('#cat_id').on('change', function () {
		loadSubcategories($(this).val());
	});

	// Quill editors
	const quillFullDesc = new Quill('#full_description', {
		theme: 'snow',
		modules: {
			toolbar: [['bold', 'italic'], ['link'], [{ list: 'ordered' }, { list: 'bullet' }]]
		}
	});

	const quillOtherDesc = new Quill('#product_description', {
		theme: 'snow',
		modules: {
			toolbar: [['bold', 'italic'], ['link'], [{ list: 'ordered' }, { list: 'bullet' }]]
		}
	});

	// Show toast
	function showToast(message, type = 'success') {
		const alertBox = $('#alert-box');
		alertBox.removeClass('d-none alert-success alert-danger')
				.addClass(`alert alert-${type}`)
				.text(message);

		setTimeout(() => {
			alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
		}, 3000);
	}

	// Preview image
	$('#product_image').on('change', function () {
		const file = this.files[0];
		if (file) {
			const reader = new FileReader();
			reader.onload = function (e) {
				$('#output').attr('src', e.target.result).show();
			};
			reader.readAsDataURL(file);
		}
	});

	// Submit form
	$('#ProductDetailForm').on('submit', function (e) {
		e.preventDefault();

		const formData = new FormData(this);
		formData.append('full_description', quillFullDesc.root.innerHTML);
		formData.append('product_description', quillOtherDesc.root.innerHTML);

		const isUpdate = $('#id').val() !== '';

		$.ajax({
			url: 'controllers/ProductDetailsController.php',
			method: 'POST',
			data: formData,
			contentType: false,
			processData: false,
			success: function (res) {
				try {
					const result = JSON.parse(res);
					if (result.status === 'success') {
						showToast(result.message, 'success');
						if (!isUpdate) {
							$('#ProductDetailForm')[0].reset();
							quillFullDesc.setContents([]);
							quillOtherDesc.setContents([]);
							$('#output').hide();
						} else {
							setTimeout(() => {
								window.location.href = 'product_detail_list.php';
							}, 1500);
						}
					} else {
						showToast(result.message, 'danger');
					}
				} catch (e) {
					console.error("JSON Parse Error:", res);
					showToast('Invalid server response.', 'danger');
				}
			},
			error: function () {
				showToast('Something went wrong.', 'danger');
			}
		});
	});

	// Load data for editing (if update mode)
	const editId = $('#upd').val();
	if (editId !== '') {
		$.post('controllers/ProductDetailsController.php', {
			action: 'getProductDetail',
			id: editId
		}, function (res) {
			const productdetail = JSON.parse(res);
			$('#id').val(productdetail.id);
			$('#cat_id').val(productdetail.cat_id);

			// Load subcategories, then set selected subcat
			loadSubcategories(productdetail.cat_id, productdetail.subcat_id);

			$('#short_description').val(productdetail.short_description);
			quillFullDesc.root.innerHTML = productdetail.full_description || '';
			quillOtherDesc.root.innerHTML = productdetail.product_description || '';

			if (productdetail.product_image) {
				$('#output').attr('src', '../uploads/products/' + productdetail.product_image).show();
			}
		});
	}
});
</script>


				</div>
			</div>
			<!-- Basic with Icons -->

		</div>


	</div>
	<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
	<script src="assets/vendor/libs/quill/quill.js"></script>
	<script src="assets/js/forms-editors.js"></script>
	<?php } ?>