<?php
require_once '../inc/db.php';
require_once '../models/ProductMediaModel.php';

$mediaModel = new ProductMediaModel($conn);

// ? 1. Fetch All Media List by Product ID
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'medialist') {
    $product_id = (int)$_GET['product_id'];
    $mediaList = $mediaModel->getAllByProduct($product_id);

    $html = '';
    $i = 1;
    foreach ($mediaList as $media) {
        $mediaTag = $media['media_type'] === 'image' 
            ? "<img src='../uploads/media/{$media['media_url']}' width='60'>" 
            : "<video width='80' controls><source src='../uploads/media/{$media['media_url']}'></video>";

        $checked = $media['status'] === 'active' ? 'checked' : '';
        $statusSwitch = "<label class='switch switch-success'>
            <input type='checkbox' class='switch-input toggleStatus' data-id='{$media['id']}' $checked />
            <span class='switch-toggle-slider'>
              <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
              <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
            </span>
          </label>";

        $html .= "<tr>
            <td>{$i}</td>
            <td>{$mediaTag}</td>
            <td>{$media['media_type']}</td>
            <td>" . htmlspecialchars($media['alt_text']) . "</td>
            <td>
              <input type='number' class='form-control form-control-sm sort-order-input' 
              data-id='{$media['id']}' value='{$media['sort_order']}' style='width: 60px;'>
            </td>
            <td>{$statusSwitch}</td>
            <td>
              <button class='btn btn-xs btn-info rounded-pill editBtn' data-id='{$media['id']}'><i class='far fa-edit'></i></button>
              <button class='btn btn-xs btn-danger rounded-pill deleteBtn' data-id='{$media['id']}'><i class='far fa-trash-alt'></i></button>
            </td>
          </tr>";
        $i++;
    }

    echo $html;
    exit;
}

//
// ? 2. Update Sort Order
//
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'updateSortOrder') {
    $id = (int)$_POST['id'];
    $sort_order = (int)$_POST['sort_order'];

    $success = $mediaModel->updateSortOrder($id, $sort_order);

    echo json_encode([
        'status' => $success ? 'success' : 'error',
        'message' => $success ? 'Sort order updated.' : 'Failed to update sort order.'
    ]);
    exit;
}

//
// ? 3. Handle Other POST Actions (Get, Delete, Toggle Status, Create, Update)
//
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Get Media by ID
    if ($action === 'get') {
        $id = (int)$_POST['id'];
        echo json_encode($mediaModel->getById($id));
        exit;
    }

    // Delete Media
    if ($action === 'delete') {
        $id = (int)$_POST['id'];
        $deleted = $mediaModel->delete($id);
        echo json_encode(['status' => $deleted ? 'success' : 'error', 'message' => $deleted ? 'Media deleted' : 'Failed to delete']);
        exit;
    }

    // Toggle Status
    if ($action === 'toggleStatus') {
        $id = (int)$_POST['id'];
        $result = $mediaModel->toggleStatus($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Status updated' : 'Status update failed']);
        exit;
    }

    // Create or Update Media
    $id = $_POST['id'] ?? '';
    $product_id = (int)$_POST['product_id'];
    $media_type = $_POST['media_type'] ?? 'image';
    $alt_text = $_POST['alt_text'] ?? '';
    $is_primary = (int)($_POST['is_primary'] ?? 0);
    $sort_order = (int)($_POST['sort_order'] ?? 0);
    $status = $_POST['status'] ?? 'active';

    // ? Upload File
    $media_url = '';
    if (isset($_FILES['media_file']) && $_FILES['media_file']['error'] === UPLOAD_ERR_OK) {
        $filename = time() . '-' . preg_replace('/[^A-Za-z0-9_.-]/', '_', $_FILES['media_file']['name']);
        $targetPath = "../../uploads/media/" . $filename;
        if (move_uploaded_file($_FILES['media_file']['tmp_name'], $targetPath)) {
            $media_url = $filename;
        }
    }

    $data = [
        'product_id' => $product_id,
        'media_type' => $media_type,
        'alt_text' => $alt_text,
        'is_primary' => $is_primary,
        'sort_order' => $sort_order,
        'status' => $status
    ];

    if (!empty($media_url)) {
        $data['media_url'] = $media_url;
    }

    if (empty($id)) {
        // Insert
        $inserted = $mediaModel->create($data);
        echo json_encode(['status' => $inserted ? 'success' : 'error', 'message' => $inserted ? 'Media added' : 'Insert failed']);
    } else {
        // Update
        $updated = $mediaModel->update((int)$id, $data);
        echo json_encode(['status' => $updated ? 'success' : 'error', 'message' => $updated ? 'Media updated' : 'Update failed']);
    }

    exit;
}
?>
