<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>


<div class="container-xxl flex-grow-1 container-p-y">
	<div class="d-flex flex-column justify-content-center">
     <h5 class="card-header mb-2">Contact Details Add</h5>
      </div>
	<div class="row">
		
		<div class="col-12">
			<div class="card mb-6">
               
                <form class="card-body" method="POST" enctype="multipart/form-data">
                   <div class="row g-6">
                    <div class="col-md-12">
                      <label class="form-label" for="multicol-username">Address</label>
                      <textarea class="form-control" id="hotel_address" rows="6" ></textarea>
                    </div>
                    
                   <div class="col-md-12">
                      <label class="form-label" for="multicol-email">Email</label>
                       <input type="email"  class="form-control" id="email" />
                     </div>
					  <div class="col-md-6">
                      <label class="form-label" for="multicol-email">Contact No.</label>
                       <input type="text"  class="form-control" id="contact_office" pattern="\d{10}" maxlength="10" inputmode="numeric" oninput="this.value=this.value.replace(/[^0-9]/g,'');"  />
                     </div>
					  <div class="col-md-6">
                      <label class="form-label" for="multicol-email">Alt No.</label>
                       <input type="text"  class="form-control" id="contact_mobile" pattern="\d{10}" maxlength="10" inputmode="numeric" oninput="this.value=this.value.replace(/[^0-9]/g,'');" />
                     </div>
					 
					 
                  </div>
                  
                 
                  <div class="pt-6">
                    <input type="hidden" id="upd" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
          <input type="hidden" name="id" id="id">
          <input type="hidden" name="action" id="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
         <?php if (isset($_GET['id']) && !empty($_GET['id'])): ?>
    <button type="submit" class="btn btn-primary me-2">Update</button>
<?php else: ?>
    <!-- Optionally, you can add nothing here or leave it empty to show nothing -->
<?php endif; ?>
        <button type="reset" class="btn btn-label-secondary">Cancel</button>
                  </div>
                </form>
				<script>
$(document).ready(function () {
    // Handle form submission
    $('form.card-body').on('submit', function (event) {
        event.preventDefault(); // Prevent default form submission

        // Collect form data
        var formData = {
            hotel_address: $('#hotel_address').val(),
            hotel_email: $('#email').val(),
            contact_office: $('#contact_office').val(),
            contact_mobile: $('#contact_mobile').val(),
            id: $('#id').val(),
            action: $('#action').val()
        };

        // Validate required fields
        if (!formData.hotel_address || !formData.hotel_email || !formData.contact_office) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please fill out all required fields: Address, Email, and Contact No. (O).',
            });
            return;
        }

        // Validate email format
        if (!validateEmail(formData.hotel_email)) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter a valid email address.',
            });
            return;
        }

        // Validate contact numbers
        if (formData.contact_office.length !== 10 || isNaN(formData.contact_office)) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Contact No. (O) must be a 10-digit number.',
            });
            return;
        }

        if (formData.contact_mobile && (formData.contact_mobile.length !== 10 || isNaN(formData.contact_mobile))) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Contact No. (M) must be a 10-digit number.',
            });
            return;
        }

        // Create FormData object for AJAX
        var formDataObj = new FormData();
        for (const key in formData) {
            formDataObj.append(key, formData[key]);
        }

        // AJAX request
        $.ajax({
            url: 'contact_action.php', // Adjust to your server endpoint
            method: 'POST',
            data: formDataObj,
            contentType: false, // Needed for FormData
            processData: false, // Prevent jQuery from automatically processing data
            success: function (response) {
                try {
                    var res = typeof response === 'string' ? JSON.parse(response) : response;

                    if (res.status === 'Create') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: 'details added successfully.',
                        }).then(() => {
                            window.location.href = 'contact_list.php'; // Redirect to details list
                        });
                    } else if (res.status === 'Update') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: 'details updated successfully.',
                        }).then(() => {
                            window.location.href = 'contact_list.php'; // Redirect to details list
                        });
                    
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: res.message || 'Unexpected error occurred.',
                        });
                    }
                } catch (e) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Error parsing server response.',
                    });
                    console.error('Parsing error:', e, 'Response:', response);
                }
            },
            error: function (xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'AJAX Error',
                    text: 'An error occurred while submitting the form.',
                });
                console.error('AJAX error:', xhr.responseText);
            },
        });
    });

    // Validate email format
    function validateEmail(email) {
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }

    // Load data for updating if `upd` parameter exists
    var upd = $('#upd').val();
    if (upd) {
        $.ajax({
            url: 'contact_action.php', // Adjust to your server endpoint
            method: 'POST',
            data: { id: upd, action: 'Select' },
            dataType: 'json',
            success: function (data) {
				console.log('Response:', data); // Log the response to debug
				if (data.status === 'Success' && data.data) {
					var hotelData = data.data;

					// Populate form fields
					$('#hotel_address').val(hotelData.hotel_address);
					$('#email').val(hotelData.email);
					$('#contact_office').val(hotelData.contact_office);
					$('#contact_mobile').val(hotelData.contact_mobile);
					$('#id').val(upd);
					$('#action').val('Update');
				} else {
					Swal.fire({
						icon: 'error',
						title: 'Error',
						text: data.message || 'data not found.',
					});
				}
			},

            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Error fetching data for update.',
                });
            }
        });
    }
});
</script>

              </div>
		</div>
		<!-- Basic with Icons -->
		
	</div>
	

</div>

<?php } ?>