<?php
    use Illuminate\Support\Facades\Auth;$user = Auth::user();
    $accountId = Config::get('account.id')
?>
<?php
$nav_class = "navbar-right";
if (app()->getLocale() == "en") {
    $nav_class = " navbar-left";
}
?>
<div class="page-header navbar navbar-fixed-top">
    <ul class="page-header-inner">
        <!-- logo start -->
        <div class="page-logo">
            <a href="/dashboard" style="height: 100%;"><span class="logo-default">
                    <?php if(isset($user->account->logo) && !is_null($user->account->logo)): ?>
                        <img style="height: 45px;"
                             src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $user->account->logo ?? 'avatars/dp.png')); ?>"
                             class="img-responsive" alt="">
                    <?php else: ?>
                        Smart
                    <?php endif; ?>
                </span></a>
        </div><!-- logo end -->
        <ul class="nav navbar-nav <?=$nav_class?> in">
            <li>
                <a class="menu-toggler sidebar-toggler" href="#"><i class="icon-menu"></i></a>
            </li>
        </ul>

        <ul class="nav navbar-nav <?=$nav_class?> in">
            <h3><?php echo e(isset($user->account) ? $user->account->name : ''); ?></h3>
        </ul>

        <!--<form action="#" class="search-form-opened" method="get">
            <div class="input-group">
                <input class="form-control" name="query" placeholder="Search" type="text">
                <span class="input-group-btn">
                    <a class="btn submit" href="javascript:"><i class="icon-magnifier"></i></a>
                </span>
            </div>
        </form>-->

        <!-- start mobile menu -->
        <a class="menu-toggler responsive-toggler" data-target=".navbar-collapse" data-toggle="collapse"
           href="javascript:"><span></span></a>
        <!-- end mobile menu -->

        <!-- start header menu -->
        <div class="top-menu">
            <ul class="nav navbar-nav pull-right">
                <!-- start language menu -->
                <?php
                $lang_name = "locale.english";
                $lang_flag = "assets/img/flags/gb.png";
                if (Config::get('app.locale') == "ar") {
                    $lang_name = "locale.arabic";
                    $lang_flag = "assets/img/flags/sa.png";
                }
                ?>
                <li class="dropdown language-switch">
                    <a aria-expanded="false" class="dropdown-toggle" data-toggle="dropdown">
                        <img alt="" class="position-left" src="<?php echo e(asset("/")); ?><?=$lang_flag; ?>"> <?php echo e(__($lang_name)); ?>

                        <span class="fa fa-angle-down"></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="/change-locale?lang=ar" class="deutsch">
                                <img alt="" src="<?php echo e(asset('assets/img/flags/sa.png')); ?>"> <?php echo e(__('locale.arabic')); ?>  </a>
                        </li>
                        <li>
                            <a href="/change-locale?lang=en" class="english">
                                <img alt="" src="<?php echo e(asset('assets/img/flags/gb.png')); ?>"> <?php echo e(__('locale.english')); ?>  </a>
                        </li>
                    </ul>
                </li><!-- end language menu -->
                <!-- start manage user dropdown -->
                <li class="dropdown dropdown-user">
                    <a class="dropdown-toggle" data-close-others="true" data-hover="dropdown" data-toggle="dropdown" href="javascript:">
                        <img alt="" class="img-circle" src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $user->avatar ?? 'avatars/dp.png')); ?>">
                        <span class="username username-hide-on-mobile"><?php echo e($user->name); ?></span> <i
                            class="fa fa-angle-down"></i></a>
                    <ul class="dropdown-menu dropdown-menu-default">
                        <li>
                            <?php if(\App\Facades\General::isSchoolTeacher() || \App\Facades\General::isSchoolAdmin()): ?>
                                <a href="<?php echo e(route('teacher.profile')); ?>"><i
                                        class="icon-user"></i> <?php echo e(__('locale.profile')); ?></a>
                            <?php elseif(\App\Facades\General::isSchoolStudent()): ?>
                                <a href="<?php echo e(route('students.profile')); ?>"><i class="icon-user"></i> <?php echo e(__('locale.profile')); ?></a>
                            <?php else: ?>
                                <a href="javascript:void(0)"><i class="icon-user"></i> <?php echo e(__('locale.profile')); ?></a>
                            <?php endif; ?>
                        </li>
                        <?php if(!\App\Facades\General::isSchoolStudent()): ?>
                        <li> <a href="<?php echo e(route('staff.change-password')); ?>"><i class="icon-settings"></i> <?php echo e(__('locale.change_password')); ?></a> </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();">
                                <i class="icon-logout"></i> <?php echo e(__('locale.logout')); ?>

                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                  style="display: none;"> <?php echo csrf_field(); ?></form>
                        </li>
                    </ul>
                </li><!-- end manage user dropdown -->

                <!-- start notification dropdown
                <li class="dropdown dropdown-extended dropdown-notification" id="header_notification_bar">
                    <a class="dropdown-toggle" data-close-others="true" data-hover="dropdown"
                       data-toggle="dropdown" href="javascript:">
                        <i class="fa fa-bell-o"></i>
                        <span class="badge headerBadgeColor1">6</span>
                    </a>
                    <ul class="dropdown-menu">
                        <li class="external">
                            <h3><span class="bold"><?php echo e(__('locale.notifications')); ?></span></h3>
                            <span class="notification-label purple-bgcolor">New 6</span>
                        </li>
                        <li>
                            <div class="dropdown-menu-footer">
                                <a href="javascript:void(0)"><?php echo e(__('locale.all notifications')); ?></a>
                            </div>
                        </li>
                    </ul>
                </li><!-- end notification dropdown -->

                <!-- start language menu -->
              
                
                <!-- end language menu -->

                

            </ul>
        </div>
    </div>
</div><!-- end header -->
<?php /**PATH /var/www/html/sms/resources/views/layouts/includes/header.blade.php ENDPATH**/ ?>