@php
    use App\Models\Permission;
    use Illuminate\Support\Facades\Auth;
    $user = Auth::user();

    // Fetch all the permissions
    $permissions = Permission::getPermissions();
    $rolePermissions = null;
    // Get the role id of current user
    $roleId = Auth::user()->role_id;

    if (!is_null($roleId)){
        $role = \App\Models\Role::find($roleId);

        if(!is_null($role)){
            // Fetch all the role permissions
            $rolePermissions = $role->permissions()->pluck('route_name')->toArray();
        }
    }

@endphp
<!-- start sidebar menu -->
<div class="sidebar-container">
    <div class="sidemenu-container navbar-collapse collapse fixed-menu">
        <div id="remove-scroll" class="left-sidemenu">
            <ul class="sidemenu  page-header-fixed" data-keep-expanded="false" data-auto-scroll="true"
                data-slide-speed="200" style="padding-top: 20px">
                <li class="sidebar-toggler-wrapper hide">
                    <div class="sidebar-toggler">
                        <span></span>
                    </div>
                </li>
                <li class="sidebar-user-panel">
                    <div class="user-panel">
                        {{--                        ('assets/img/dp.png')--}}
                        <div class="pull-left image">
                            <img
                                src="{{ \Illuminate\Support\Facades\Storage::url( $user->avatar ?? 'avatars/dp.png') }}"
                                class="img-circle user-img-circle"
                                alt="User Image"/>
                        </div>
                        <div class="pull-left info">
                            <p>{{ $user->name }}</p>
                            <a href="#"><i class="fa fa-circle user-online"></i>
                                <span class="txtOnline">{{ __('locale.online') }}  </span>
                            </a>
                        </div>
                    </div>
                </li>

                @if(\App\Facades\General::isSuperAdmin())
                    <li class="nav-item {{ (request()->is('dashboard') || request()->is('dashboard/*')) ? 'active' : '' }}">
                        <a href="{{ route('dashboard.index') }}" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.dashboard') }}</span>
                            <i class="material-icons">dashboard</i>
                        </a>
                    </li><li class="nav-item {{ (request()->is('saas-user') || request()->is('saas-user/*')) ? 'active' : '' }}">
                        <a href="{{ route('saas-user.index') }}" class="nav-link nav-toggle">
                            <span class="title">{{__('locale.users') . ' ' .__('locale.management')}}</span>
                            <i class="material-icons">group</i>
                        </a>
                    </li>
                    <li class="nav-item {{ (request()->is('saas-school') || request()->is('saas-school/*')) ? 'active' : '' }}">
                        <a href="{{ route('saas-school.index') }}" class="nav-link nav-toggle">
                            <span class="title">{{__('locale.schools') . ' ' .__('locale.management')}}</span>
                            <i class="material-icons">school</i>
                        </a>
                    </li>
                @else

                    @foreach($permissions as $permission)
                        @if(isset($permission['children']) && !is_null($permission['children']))
                            @if(in_array($permission['route_name'],$rolePermissions) && $permission['is_active'] == 1)
                                <li class="nav-item">
                                    <a href="javaScript:void(0)" class="nav-link nav-toggle"> <i
                                            class="material-icons">{{ $permission['icon'] }}</i>
                                        <span class="title">{{ __('locale.'.strtolower($permission['name'])) }}</span>
                                        <span class="arrow"></span>
                                    </a>
                                    <ul class="sub-menu">
                                        @foreach($permission['children'] as $children)
                                            @if(in_array($children['route_name'],$rolePermissions) && $children['is_active'] == 1)
                                                <li class="nav-item">
                                                    <a href="{{ (Route::has($children['route_name'].'.index')) ?
route($children['route_name'].'.index') : 'javaScript:void(0)' }}" class="nav-link ">
                                                        <span
                                                            class="title">{{ __('locale.'.strtolower($children['name'])) }} </span>
                                                    </a>
                                                </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                </li>
                            @endif
                        @else
                            @if(in_array($permission['route_name'],$rolePermissions) && $permission['is_active'] == 1)
                                <li class="nav-item">
                                    <a href="{{ (Route::has($permission['route_name'].'.index')) ?
route($permission['route_name'].'.index') : 'javaScript:void(0)' }}" class="nav-link nav-toggle">
                                        <span class="title">{{ __('locale.'.strtolower($permission['name'])) }}</span>
                                        <i class="material-icons">{{ $permission['icon'] }}</i>
                                    </a>
                                </li>
                            @endif
                        @endif
                    @endforeach

                    {{--<li class="nav-item">
                        <a href="{{ route('dashboard.index') }}" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.dashboard') }}</span>
                            <i class="material-icons">dashboard</i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="#" class="nav-link nav-toggle"> <i class="material-icons">face</i>
                            <span class="title">{{ __('locale.staff') . ' ' .__('locale.management')}}</span>
                            <span class="arrow"></span>
                        </a>
                        <ul class="sub-menu">
                            <li class="nav-item">
                                <a href="{{ route('staff.index') }}" class="nav-link ">
                                    <span class="title">{{__('locale.staffs')}} </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="javaScript:void(0)" class="nav-link ">
                                    <span class="title">{{__('locale.teachers')}} </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="javaScript:void(0)" class="nav-link ">
                                    <span class="title">{{__('locale.teacher').' '.__('locale.timetable')}}</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item {{ (request()->is('student') || request()->is('student/*')) ? 'active' : '' }}">
                        <a href="#" class="nav-link nav-toggle"><i class="material-icons">group</i>
                            <span class="title">{{ __('locale.students'). ' ' .__('locale.management') }}</span><span
                                class="arrow"></span></a>
                        <ul class="sub-menu">
                            <li class="nav-item {{ (request()->is('student')) ? 'active' : '' }}">
                                <a href="{{ route('student.index') }}"
                                   class="nav-link {{ (request()->is('student.index')) ? 'active' : '' }}">
                                    <span class="title">{{ __('locale.students') }}</span>
                                </a>
                            </li>
                            <li class="nav-item {{ (request()->is('student/create')) ? 'active' : '' }}">
                                <a href="{{ route('student.create') }}" class="nav-link ">
                                    <span
                                        class="title">{{ __('locale.student'). ' ' .__('locale.registration') }} </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="javascript:void(0);" class="nav-link ">
                                    <span
                                        class="title">{{ __('locale.time_table') }} / {{ __('locale.schedule') }}</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="#" class="nav-link nav-toggle"><i class="material-icons">group</i>
                            <span class="title">{{ __('locale.reports') }}</span><span class="arrow"></span></a>
                        <ul class="sub-menu">
                            <li class="nav-item">
                                <a href="javaScript:void(0)" class="nav-link ">
                                    <span class="title">{{ __('locale.student'). ' ' .__('locale.report') }} </span>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="javaScript:void(0)" class="nav-link ">
                                    <span class="title">{{ __('locale.teacher'). ' ' .__('locale.report') }}</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a href="#" class="nav-link nav-toggle"><i class="material-icons">business</i>
                            <span class="title">{{ __('locale.class'). ' ' .__('locale.management') }} </span><span
                                class="arrow"></span></a>
                        <ul class="sub-menu">
                            <li class="nav-item">
                                <a href="javascript:void(0);" class="nav-link ">
                                    <span class="title">{{ __('locale.class'). ' ' .__('locale.reminders') }} </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="javaScript:void(0)" class="nav-link ">
                                    <span class="title">{{ __('locale.syllabus') }}</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="javascript:void(0);" class="nav-link ">
                                    <span class="title">{{ __('locale.subject') }}</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="javascript:void(0);" class="nav-link ">
                                    <span
                                        class="title">{{ __('locale.standard'). ' ' .__('locale.management') }} </span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.virtual'). ' ' .__('locale.classroom') }} </span>
                            <i class="material-icons">video_call</i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.fee'). ' ' .__('locale.management') }} </span>
                            <i class="material-icons">monetization_on</i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.assignment') }}/{{ __('locale.exam') }}</span>
                            <i class="material-icons">assignment</i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.library'). ' ' .__('locale.management') }}</span>
                            <i class="material-icons">local_library</i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.canteen'). ' ' .__('locale.management') }}</span>
                            <i class="material-icons">fastfood</i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.courses') }} </span>
                            <i class="material-icons">school</i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.cms') }} </span>
                            <i class="material-icons">create</i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.file_and_media') }}</span>
                            <i class="material-icons">attach_file </i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link nav-toggle">
                            <span class="title">{{ __('locale.chat') }}</span>
                            <i class="material-icons">chat</i>
                        </a>
                    </li>--}}
                @endif
            </ul>
        </div>
    </div>
</div>
<!-- end sidebar menu -->
