@php
    use Illuminate\Support\Facades\Auth;$user = Auth::user();
    $accountId = Config::get('account.id')
@endphp
<?php
$nav_class = "navbar-right";
if (app()->getLocale() == "en") {
    $nav_class = " navbar-left";
}
?>
<div class="page-header navbar navbar-fixed-top">
    <ul class="page-header-inner">
        <!-- logo start -->
        <div class="page-logo">
            <a href="/dashboard" style="height: 100%;"><span class="logo-default">
                    @if(isset($user->account->logo) && !is_null($user->account->logo))
                        <img style="height: 45px;"
                             src="{{ \Illuminate\Support\Facades\Storage::url( $user->account->logo ?? 'avatars/dp.png') }}"
                             class="img-responsive" alt="">
                    @else
                        Smart
                    @endif
                </span></a>
        </div><!-- logo end -->
        <ul class="nav navbar-nav <?=$nav_class?> in">
            <li>
                <a class="menu-toggler sidebar-toggler" href="#"><i class="icon-menu"></i></a>
            </li>
        </ul>

        <ul class="nav navbar-nav <?=$nav_class?> in">
            <h3>{{ isset($user->account) ? $user->account->name : ''}}</h3>
        </ul>

        <!--<form action="#" class="search-form-opened" method="get">
            <div class="input-group">
                <input class="form-control" name="query" placeholder="Search" type="text">
                <span class="input-group-btn">
                    <a class="btn submit" href="javascript:"><i class="icon-magnifier"></i></a>
                </span>
            </div>
        </form>-->

        <!-- start mobile menu -->
        <a class="menu-toggler responsive-toggler" data-target=".navbar-collapse" data-toggle="collapse"
           href="javascript:"><span></span></a>
        <!-- end mobile menu -->

        <!-- start header menu -->
        <div class="top-menu">
            <ul class="nav navbar-nav pull-right">
                <!-- start language menu -->
                <?php
                $lang_name = "locale.english";
                $lang_flag = "assets/img/flags/gb.png";
                if (Config::get('app.locale') == "ar") {
                    $lang_name = "locale.arabic";
                    $lang_flag = "assets/img/flags/om.png";
                }
                ?>
                <li class="dropdown language-switch">
                    <a aria-expanded="false" class="dropdown-toggle" data-toggle="dropdown">
                        <img alt="" class="position-left" src="{{ asset("/") }}<?=$lang_flag; ?>"> {{ __($lang_name) }}
                        <span class="fa fa-angle-down"></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="/change-locale?lang=ar" class="deutsch">
                                <img alt="" src="{{ asset('assets/img/flags/om.png') }}"> {{ __('locale.arabic') }}  </a>
                        </li>
                        <li>
                            <a href="/change-locale?lang=en" class="english">
                                <img alt="" src="{{ asset('assets/img/flags/gb.png') }}"> {{ __('locale.english') }}  </a>
                        </li>
                    </ul>
                </li><!-- end language menu -->
                <!-- start manage user dropdown -->
                <li class="dropdown dropdown-user">
                    <a class="dropdown-toggle" data-close-others="true" data-hover="dropdown" data-toggle="dropdown" href="javascript:">
                        <img alt="" class="img-circle" src="{{ \Illuminate\Support\Facades\Storage::url( $user->avatar ?? 'avatars/dp.png') }}">
                        <span class="username username-hide-on-mobile">{{ $user->name }}</span> <i
                            class="fa fa-angle-down"></i></a>
                    <ul class="dropdown-menu dropdown-menu-default">
                        <li>
                            @if(\App\Facades\General::isSchoolTeacher() || \App\Facades\General::isSchoolAdmin())
                                <a href="{{ route('teacher.profile') }}"><i
                                        class="icon-user"></i> {{ __('locale.profile') }}</a>
                            @elseif(\App\Facades\General::isSchoolStudent())
                                <a href="{{ route('students.profile') }}"><i class="icon-user"></i> {{ __('locale.profile') }}</a>
                            @else
                                <a href="javascript:void(0)"><i class="icon-user"></i> {{ __('locale.profile') }}</a>
                            @endif
                        </li>
                        @if(!\App\Facades\General::isSchoolStudent())
                        <li> <a href="{{ route('staff.change-password') }}"><i class="icon-settings"></i> {{ __('locale.change_password') }}</a> </li>
                        @endif
                        <li>
                            <a href="{{ route('logout') }}" onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();">
                                <i class="icon-logout"></i> {{ __('locale.logout') }}
                            </a>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                  style="display: none;"> @csrf</form>
                        </li>
                    </ul>
                </li><!-- end manage user dropdown -->

                <!-- start notification dropdown
                <li class="dropdown dropdown-extended dropdown-notification" id="header_notification_bar">
                    <a class="dropdown-toggle" data-close-others="true" data-hover="dropdown"
                       data-toggle="dropdown" href="javascript:">
                        <i class="fa fa-bell-o"></i>
                        <span class="badge headerBadgeColor1">6</span>
                    </a>
                    <ul class="dropdown-menu">
                        <li class="external">
                            <h3><span class="bold">{{ __('locale.notifications') }}</span></h3>
                            <span class="notification-label purple-bgcolor">New 6</span>
                        </li>
                        <li>
                            <div class="dropdown-menu-footer">
                                <a href="javascript:void(0)">{{ __('locale.all notifications') }}</a>
                            </div>
                        </li>
                    </ul>
                </li><!-- end notification dropdown -->

                <!-- start language menu -->
              {{--  <?php
                $lang_name = "locale.english";
                $lang_flag = "assets/img/flags/gb.png";
                if (Config::get('app.locale') == "ar") {
                    $lang_name = "locale.arabic";
                    $lang_flag = "assets/img/flags/om.png";
                }
                ?>--}}
                {{--<li class="dropdown language-switch">
                    <a aria-expanded="false" class="dropdown-toggle" data-toggle="dropdown">
                        <img alt="" class="position-left" src="{{ asset("/") }}<?=$lang_flag; ?>"> {{ __($lang_name) }}
                        <span class="fa fa-angle-down"></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="/change-locale?lang=ar" class="deutsch">
                                <img alt="" src="{{ asset('assets/img/flags/om.png') }}"> {{ __('locale.arabic') }}
                            </a>
                        </li>
                        <li>
                            <a href="/change-locale?lang=en" class="english">
                                <img alt="" src="{{ asset('assets/img/flags/gb.png') }}"> {{ __('locale.english') }}
                            </a>
                        </li>
                    </ul>
                </li>--}}
                <!-- end language menu -->

                {{--  @if(\App\Facades\General::isSuperAdmin())
                      <li class="dropdown">
                          <select class="form-control __change_account__super_admin" data-url="{{ route('config.account') }}">
                              <option value="">Select school</option>
                              @if(isset($commonData['accountList']))
                                  @foreach($commonData['accountList'] as $account)
                                      <option
                                          value="{{ $account->id }}" {{ $accountId== $account->id ? 'selected' : ''}}>{{ $account->name }}</option>
                                  @endforeach
                              @endif
                          </select>
                      </li>
                  @endif--}}

            </ul>
        </div>
    </div>
</div><!-- end header -->
