<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('account_id');
            $table->unsignedBigInteger('user_id');
            $table->bigInteger('admission_no')->nullable();
            $table->string('roll_no')->nullable();
            $table->integer('class_id');
            $table->integer('section_id');
            $table->integer('category_id');
            $table->integer('house_id');
            $table->string('religion', 100)->nullable();
            $table->string('cast', 100)->nullable();
            $table->date('admission_date')->nullable();
            $table->string('height', 100)->nullable();
            $table->string('weight', 100)->nullable();
            $table->date('measure_date')->nullable();
            $table->text('medical_history')->nullable();

            $table->string('father_name')->nullable();
            $table->string('father_phone')->nullable();
            $table->string('father_occupation')->nullable();
            $table->string('father_photo')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('mother_phone')->nullable();
            $table->string('mother_occupation')->nullable();
            $table->string('mother_photo')->nullable();
            $table->string('guardian_is', 50)->nullable();
            $table->string('guardian_relation', 50)->nullable();
            $table->string('guardian_occupation')->nullable();
            $table->bigInteger('guardian_id')->nullable();
            $table->string('bank_account_no')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('ifsc_code')->nullable();
            $table->string('bank_branch')->nullable();
            $table->string('national_ident_no')->nullable();
            $table->string('local_ident_no')->nullable();
            $table->text('prev_school')->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students');
    }

}
