@extends('layouts.master')
@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('locale.lectures')]) @stop
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.lectures') ]) @stop
@section('content')
<div class="card-box">
    <div class="card-head">
        <header>{{ __('locale.lectures')}} </header>
    </div>
    <div class="card-body ">
        <div class="row">
            <div class="col-lg-3">
                <select class="form-control" defaulttxt="Select" div="col-lg-12" name="days" id="option_days">
                    <option value="">Filter Day</option>
                    @foreach($weekDays as $weekDay)
                        <option value="{{ $weekDay }}">{{ $weekDay }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-lg-3">
                <select class="form-control" defaulttxt="Select" div="col-lg-12" name="class_type" id="option_class_type">
                    <option value="">Filter Type</option>
                    <option value="online">Online</option>
                    <option value="offline">Offline</option>
                </select>
            </div>
             <div class="col-lg-3">
                <select class="form-control" defaulttxt="Select" div="col-lg-12" name="subjects" id="option_subjects">
                    <option value="">Filter Subject</option>
                    @foreach($subjects as $key => $subject)
                        <option value="{{ $key }}">{{ $subject }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-lg-1"><button data-toggle="button" class="btn btn-default __sms_lectures_filter" id="__sms_lectures_filter"><i class="fa fa-search"></i></button></div>
        </div>
        <div class="row">
            <div class="col-lg-3">
                <select class="form-control" defaulttxt="Select" div="col-lg-12" name="teachers" id="option_teachers">
                    <option value="">Filter Teacher</option>
                    @foreach($teachers as $key => $teacher)
                        <option value="{{ $key }}">{{ $teacher }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-lg-3">
                <select class="form-control" defaulttxt="Select" div="col-lg-12" name="classes" id="option_classes">
                    <option value="">Filter Class</option>
                    @foreach($classes as $key => $class)
                        <option value="{{ $key }}">{{ $class }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-lg-3">
                <input required="true" autocomplete="off" class="form-control setDatePicker flatpickr-input active" name="__calender_helper" type="text" id="__calender_helper">
            </div>

        </div>
        <br/>
        @foreach($data as $row)
        <div class="lecture-five-col-row common-days common-type {{ $row->week_day }} {{ "teacher_".$row->teacher_id }} {{ "class_".$row->class_id }} {{ "sub_".$row->subject_id }} {{ ($row->is_online == 1 ? 'online' : 'offline') }}">
            <div class="lecture-col">
                <div class="lecThumb" style="background: url( {{file_exists(public_path().'/assets/img/card/'. strtolower($row->subject->title.'.png')) ? '/assets/img/card/'. strtolower($row->subject->title.'.png') : '/assets/img/card/'. strtolower('defalut.png') }});background-position: center center; background-size: 100% 100%;background-repeat: no-repeat;">
                    <div class="lecTitle">
                        <h2>{{ $row->subject->title }}</h2>
                    </div>
                    <div class="course-box">
                        <h3>{{ $row->teacher->user->name }} </h3>
                        <h3>{{ $row->week_day }}</h3>
                        <div class="mg-bottom-10 margin-top-20">
                           {{ date("H:i",strtotime($row->start_time))." - ".date("H:i",strtotime($row->end_time)) }}
                           <p><span>{{ (strtotime($row->end_time) - strtotime($row->start_time)) / 60 }} Mins</span></p>
                        </div>
                        <div class="mg-bottom-10">
                           <span class="lecGrade"> {{ $row->studentClass->title }} - {{ $row->section->title }} [{{ $row->ttl_students }}]</span>
                        </div>
                        <div class="lecBottom margin-top-20">
                            <p><span>Created {{ \Carbon\Carbon::parse($row->created_at)->format('d-M-Y') }}</span></p>
                            <p><span>{{ $row->studentClass->title }}</span> | <span>Attendance 40 (86.53%)</span></p>
                             <h5>{{ $row->is_online == 1 ? 'Online' : 'Offline' }}</h5>
                        </div>
                        <button type="button" class="margin-top-20 pull-right mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect btn-info {{ $row->is_online == 0 ? 'hide' : 'show' }}" data-upgraded=",MaterialButton,MaterialRipple" >Start<span class="mdl-button__ripple-container" ><span class="mdl-ripple"></span></span></button>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
@stop
@section('scripts')
<style>
.hide_days{
    display: none !important;
}

.hide_types{
    display: none !important;
}
.lecture-five-col-row .lecture-col .lecThumb{padding-top: 95px;min-height: 565px;margin: 0 0 10px 0;}
.lecTitle{background-color: #002C69;}
.lecTitle h2{margin:10px;color:white;}
.lecBottom p{margin: 0;}
.course-box h3{margin:0;}
.lecture-five-col-row{margin: 0 -5px;}
.lecture-five-col-row .lecture-col{width: 20%;float: left;padding:0 5px;}
.lecture-five-col-row .lecture-col .lecGrade{font-size: 26px;color: #002C69;display: block;}
.lecture-five-col-row .lecture-col .course-box{padding-left: 10px;}
@media only screen and (max-width:1023px) {
    .lecture-five-col-row .lecture-col{
        width: 33.33%;
    }
    .lecture-five-col-row .lecture-col .lecThumb{
        min-height: 530px;
    }
    .margin-top-20{margin-top:10px !important;}
    .course-box h3{line-height: 30px;}
    .lecture-five-col-row .lecture-col .lecGrade{font-size: 24px;}
}
@media only screen and (max-width:767px) {
    .lecture-five-col-row .lecture-col{
        width: 50%;
    }
    .margin-top-20{margin-top:5px !important;}

}
@media only screen and (max-width:500px) {
    .lecture-five-col-row .lecture-col{
        width: 100%;
    }
    .lecture-five-col-row .lecture-col .lecThumb{
        min-height: 510px;
    }
    .margin-top-20{margin-top:5px !important;}
}
    </style>
<style>
.lecture-five-col-row .lecture-col .lecThumb{padding-top: 95px;min-height: 565px;margin: 0 0 10px 0;}
.lecTitle{background-color: #002C69;}
.lecTitle h2{margin:10px;color:white;}
.lecBottom p{margin: 0;}
.course-box h3{margin:0;}
.lecture-five-col-row{margin: 0 -5px;}
.lecture-five-col-row .lecture-col{width: 20%;float: left;padding:0 5px;}
.lecture-five-col-row .lecture-col .lecGrade{font-size: 26px;color: #002C69;display: block;}
.lecture-five-col-row .lecture-col .course-box{padding-left: 10px;}
@media only screen and (max-width:1023px) {
    .lecture-five-col-row .lecture-col{
        width: 33.33%;
    }
    .lecture-five-col-row .lecture-col .lecThumb{
        min-height: 530px;
    }
    .margin-top-20{margin-top:10px !important;}
    .course-box h3{line-height: 30px;}
    .lecture-five-col-row .lecture-col .lecGrade{font-size: 24px;}
}
@media only screen and (max-width:767px) {
    .lecture-five-col-row .lecture-col{
        width: 50%;
    }
    .margin-top-20{margin-top:5px !important;}

}
@media only screen and (max-width:500px) {
    .lecture-five-col-row .lecture-col{
        width: 100%;
    }
    .lecture-five-col-row .lecture-col .lecThumb{
        min-height: 510px;
    }
    .margin-top-20{margin-top:5px !important;}
}
</style>
<link href="{{ asset('assets/plugins/fullcalendar/fullcalendar.css') }}" rel="stylesheet" type="text/css"/>
<script src="{{ asset('assets/plugins/moment/moment.min.js') }}"></script>
<script src="{{ asset('assets/plugins/fullcalendar/fullcalendar.min.js') }}"></script>
<script src="{{ asset('assets/js/pages/calendar/calendar.min.js') }}"></script>
<link href="{{ asset('assets/plugins/sweet-alert/sweetalert2.min.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/sweet-alert/sweetalert2.all.min.js') }}"></script>
<script>
$(document).on('change', '#__calender_helper', function () {

    let days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    let calenderHelper = $(this).val();
    let dateObject = new Date(calenderHelper);
    let dayName = days[dateObject.getDay()];
    $("#option_days").val(dayName);
    document.getElementById('__sms_lectures_filter').click();
});

$(document).on('click', '.__sms_lectures_filter', function () {
    let optionDays = $.trim($("#option_days").val());
    let optionClassType = $.trim($("#option_class_type").val());
    let optionSubjects = $.trim($("#option_subjects").val());
    let optionClasses = $.trim($("#option_classes").val());
    let optionTeachers = $.trim($("#option_teachers").val());
    $(".common-type").hide();
    var dviClass = "";
    if(optionDays != null && optionDays!= ''){
        dviClass = "."+optionDays;
    }
    if(optionClassType != null && optionClassType!= ''){
        dviClass = "."+optionClassType;
    }
    if(optionSubjects != null && optionSubjects!= ''){
        dviClass += ".sub_"+ optionSubjects;
    }
    if(optionClasses != null && optionClasses!= ''){
        dviClass += ".class_"+ optionClasses;
    }
    if(optionTeachers != null && optionTeachers!= ''){
        dviClass += ".teacher_"+ optionTeachers;
    }
    if(dviClass){
        console.log(dviClass);
        $(dviClass).show();
    }
    else{
        $(".common-type").show();
    }
});
</script>
@stop

