@extends('layouts.master')
@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('locale.timetable')]) @stop
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.file_manager').' '. __('locale.details') ]) @stop
@section('content')

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>{{ __('locale.study material')}} </header>
                </div>
                <div class="card-body ">
                    <div class="table-scrollable">
                        <table id="{{$moduleName}}-table"
                               class="display table table-checkable order-column valign-middle __class__teacher__table"
                               style="width: 100%">
                            <thead>
                            <tr>
                                <th width="20%"> {{ __('locale.date') }}</th>
                                <th width="20%"> {{ __('locale.category') }}</th>
                                <th width="20%"> {{ __('locale.file_title') }}</th>
                                <th width="15%"> {{ __('locale.download') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')

    <script>
        let columnsArray = [{data: 'date', name: 'date'},{data: 'category', name: 'category'},{data: 'file_title', name: 'file_title'},{data: 'download', name: 'download'}];
        let routeUrl = "{{ route('study-material.index') }}";
        let tableRef = "{{ $moduleName.'-table'}}";
        // Run the Datatable
        let table = __commonDatatableListing(tableRef, routeUrl, columnsArray);
    </script>
@stop

