<?php

namespace App\Modules\Timetable\Http\Controllers;

use App\Facades\General;
use App\Modules\Timetable\Model\Timetable;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class LectureController extends Controller
{

    /**
     * Module variable
     *
     * @var array
     */
    protected $moduleName;

    /**
     * Class Constructor.
     *
     * @return string
     */
    public function __construct()
    {
        $this->moduleName = $this->getModuleName();
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     * @throws Exception
     */
    public function index(Request $request)
    {

        $timetable = new Timetable();
        $options["cols"] = [
            "timetables.*",
            DB::raw('(select count(*) from students where class_id=timetables.class_id and section_id=timetables.section_id) as ttl_students')
            ];
        $options["where"] = [];


        if (isset($request->days) && !empty($request->days) && !is_null($request->days) && $request->days=='today'){
            $options["where"] += ["week_day" => '"'.date('l', strtotime(date('Y-m-d'))).'"'];
        }
        if (isset($request->class_type) && !empty($request->class_type) && !is_null($request->class_type) && $request->class_type=='online'){
            $options["where"] += ["is_online" => 1];
        }
        if (General::isSchoolTeacher()){
            $options["where"] += ["teacher_id" => Auth::user()->staff->id];
        }
        if (General::isSchoolStudent()){
            $options["where"] += ["class_id" => Auth::user()->student->class_id];
            $options["where"] += ["section_id" => Auth::user()->student->section_id];
        }
        $data      = $timetable->find($options);

        $weekDays = General::getWeekDays();
        $subjects = \App\Modules\Student\Model\Subject::getSubjects();
        $teachers = \App\Modules\Staff\Model\Staff::getTeachers();
        $classes = \App\Modules\Student\Model\StudentClass::getStudentClasses();
        General::userLog('SL000901', ['action_module' => $this->moduleName]);
        return View('timetable::lectures.index', ['moduleName' => $this->moduleName, 'data' => $data, 'request' => $request,
            'weekDays' => $weekDays,"subjects" => $subjects,"classes" => $classes,"teachers"=> $teachers]);
    }

    /**
     * Get Module name.
     *
     * @return string
     */
    public function getModuleName()
    {
        return "lectures";
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|View
     */
    public function test(){
        return View('timetable::online-events.test', ['moduleName' => $this->moduleName]);
    }

}
