<?php

namespace App\Modules\Teacher\Providers;

use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('teacher', 'Resources/Lang', 'app'), 'teacher');
        $this->loadViewsFrom(module_path('teacher', 'Resources/Views', 'app'), 'teacher');
        $this->loadMigrationsFrom(module_path('teacher', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('teacher', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('teacher', 'Database/Factories', 'app'));
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
