@extends('layouts.master')

@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('Students')]) @stop

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Students')]) @stop

@section('content')
    <div class="row __sms__datatable">
        <div class="col-md-12">
            <div class="card card-topline-aqua">
                    @include('layouts.modules.header', ['actionAddNew' => route($moduleName.'.create'), 'title' => __('Students').' '.__('List')])
                <div class="card-body">
                    <div class="table-scrollable">
                        <table id="{{$moduleName}}-table" class="display table table-checkable order-column valign-middle" style="width: 100%">
                            <thead>
                            <tr>
                                <th width="10%"> {{ __('locale.admission_no') }}</th>
                                <th> {{ __('locale.name') }}</th>
                                <th width="15%"> {{ __('locale.email') }}</th>
                                <th width="7%"> {{ __('locale.class') }}</th>
                                <th width="10%"> {{ __('locale.contact_no') }}</th>
                                <th width="7%"> {{ __('locale.gender') }}</th>
                                <th width="7%"> {{ __('locale.category') }}</th>
                                <th width="15%"> {{ __('Actions') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')

    <!-- data tables -->
    <link href="{{ asset('assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.css') }}" rel="stylesheet"
          type="text/css" />
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.js') }}"></script>

    <script>
        $(function () {
            $('#{{$moduleName}}-table').DataTable({
                processing: true,
                serverSide: false,
                autoWidth: false,
                responsive: false,
                orderClasses: false,
                ajax: '{!! route($moduleName.'.index') !!}',
                columns: [
                    {data: 'admission_no', name: 'admission_no'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'class', name: 'class'},
                    {data: 'contact_no', name: 'contact_no'},
                    {data: 'gender', name: 'gender'},
                    {data: 'category', name: 'category'},
                    {data: 'action', name: 'action'},
                ],
                columnDefs: [
                    {className: "__sms__ta__right", targets: "_all"},
                    @if(\App\Facades\General::isSchoolTeacher() && !\App\Facades\General::isStaffStudentACL())
                    { "visible": false, "targets": 7 },
                    @endif
                ],
                order: [[1, 'desc']],
                language: {
                    search: '<span>Filter:</span> _INPUT_',
                    lengthMenu: '<span>Show:</span> _MENU_',
                    paginate: {'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;'}
                },
                lengthMenu: [25, 50, 100],
                displayLength: 25
            });

            $('#{{$moduleName}}-table tbody').on('click', 'tr', function (evt) {
                let href = $(this).find("a#view").attr('href');
                let $cell = $(evt.target).closest('td');
                if ($cell.index() != 4 && href) {
                    $(location).attr('href', href);

                }
            });

        });
    </script>
@stop

