@extends('layouts.master')
@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('locale.classes')]) @stop
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.classes').' '. __('locale.details') ]) @stop
@section('content')
    <div class="row __sms__datatable">
        <div class="col-lg-4">
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>{{ __('locale.add').' '.__('locale.class') }} </header>
                </div>
                <div class="card-body ">
                    <div class="row text-center m-t-10">
                        <div class="form-group col-lg-12">
                            <label for="father_phone" class="col-lg-12 control-label">
                                {{ __('locale.class') }}<span class="required">*</span></label>
                            <div class="col-lg-12">
                                <input class="form-control" name="class" type="text" id="studentClass">
                                <p class="error __sms__field__error"></p>
                            </div>
                            <label for="studentClass" class="col-lg-12 control-label">
                                {{ __('locale.divisions') }}<span class="required">*</span></label>
                            <div class="col-lg-12 __divisions__data__checkbox">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-right">
                    <button type="button" class="btn btn-primary m-b-10 __sms__add__class__detail mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect btn-circle" data-id="0" data-type="dialog6">Save
                    </button>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>{{ __('locale.classes')}} </header>
                </div>
                <div class="card-body ">
                    <div class="table-scrollable">
                        <table id="{{$moduleName}}-table"
                               class="display table table-checkable order-column valign-middle __grade__table"
                               style="width: 100%">
                            <thead>
                            <tr>
                                <th width="10%"> {{ __('locale.class') }}</th>
                                <th width="30%"> {{ __('locale.sections') }}</th>
                                <th width="15%"> {{ __('locale.actions') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')
    <link href="{{ asset('assets/plugins/sweet-alert/sweetalert2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/pages/formlayout.css') }}" rel="stylesheet">
    <script src="{{ asset('assets/plugins/sweet-alert/sweetalert2.all.min.js') }}"></script>

    <script>
        let columnsArray = [{data: 'title', name: 'title'},{data: 'sections', name: 'sections'}, {data: 'action', name: 'action'}];
        let routeUrl = "{{ route($moduleName.'.index') }}";
        let tableRef = "{{ $moduleName.'-table'}}";
        // Run the Datatable
        let table = __commonDatatableListing(tableRef, routeUrl, columnsArray);
        let actionUrl = {
            '_add_edit_record': "{{ route($moduleName.'.crud', '_refSection') }}",
            '_edit_record': "{{ route($moduleName.'.edit', '_refSection') }}",
            '_destroy_record': "{{ route($moduleName.'.destroy', '_refSection') }}",
            '_get_division': "{{ route($moduleName.'.get_divisions') }}",
            '_success_msg': "{{ __('locale.grade_saved') }}"
        }
        getDivisions();
    </script>
@stop

