<?php

namespace App\Modules\Student\Providers;

use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('student', 'Resources/Lang', 'app'), 'student');
        $this->loadViewsFrom(module_path('student', 'Resources/Views', 'app'), 'student');
        $this->loadMigrationsFrom(module_path('student', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('student', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('student', 'Database/Factories', 'app'));
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
