<?php

namespace App\Modules\Student\Model;

use App\Models\Crud;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentHouse extends Tenant
{

    use SoftDeletes;

    protected $fillable = ['account_id', 'title', 'created_by', 'updated_by'];

    /**
     * Return section lists
     *
     * @return void
     */
    public static function getHouses()
    {
        try {
            $houseResults = self::get();
            $houseValues  = [];

            foreach ($houseResults as $houseResult) {
                $houseValues[$houseResult->id] = $houseResult->title;
            }

            return $houseValues;

        } catch (Exception $e) {
            return '';
        }
    }

    /**
     * Return house name nby house id
     *
     * @param $houseId
     * @return mixed
     */
    public static function getStudentHouseName($houseId)
    {
        if (isset($houseId) && !empty($houseId) && !is_null($houseId)) {
            return self::where('id', $houseId)->pluck('title')->first();
        } else {
            return null;
        }
    }
}
