<?php

namespace App\Modules\Student\Model;

use App\Models\Crud;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
use Throwable;
use Yajra\DataTables\Facades\DataTables;

class Section extends Tenant
{

    use SoftDeletes;

    protected $fillable = ['account_id', 'title', 'created_by', 'updated_by'];

    /**
     * @return mixed
     */
    public function student()
    {
        return $this->hasMany('App\Modules\Student\Model\Student', 'section_id')->withDefault();
    }

    /**
     * @return BelongsTo
     */
    /*public function studentClass()
    {
        return $this->belongsTo('App\Modules\Student\Model\StudentClass', 'class_id')->withDefault();
    }*/

    /**
     * @return BelongsToMany
     */
    public function studentClass()
    {
        return $this->belongsToMany(StudentClass::class, 'class_sections', 'section_id', 'class_id');
    }

    /**
     * Return section lists
     *
     * @return void
     */
    public static function getSections()
    {
        try {
            $sectionResults = self::orderBy('title', 'ASC')->get();
            $sectionValues  = [];

            foreach ($sectionResults as $sectionResult) {
                $sectionValues[$sectionResult->id] = $sectionResult->title;
            }

            return $sectionValues;

        } catch (Exception $e) {
            return '';
        }
    }

    /**
     * Return section details by Id
     *
     * @param $sectionId
     * @return Builder|int|mixed|object|null
     */
    public static function getSectionById($sectionId)
    {
        return self::where('id', $sectionId)->first();
    }

    /**
     * Return house name nby house id
     *
     * @param $sectionId
     * @return mixed
     */
    public static function getStudentSectionName($sectionId)
    {
        if (isset($sectionId) && !empty($sectionId) && !is_null($sectionId)) {
            return self::where('id', $sectionId)->pluck('title')->first();
        } else {
            return null;
        }
    }

    public static function getDatatableSections()
    {
        $options            = array();
        $options['object']  = true;
        $options['orderBy'] = "id";
        $options['order']   = "DESC";

        $section = new Section();
        $model   = $section->find($options);
        return DataTables::eloquent($model)
            ->addColumn('action', function (Section $section) {
                return $section->returnAjaxAction('section', $section, ['edit', 'destroy']);
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    /**
     * Return all the divisions
     *
     * @return array|string
     * @throws Throwable
     */
    public static function getDivisions($divisionArr = null)
    {
        $option            = [];
        $option["orderBy"] = "title";
        $option["order"]   = "ASC";
        $divisions         = (new Section())->find($option);

        return view('student::class.divisionCheckbox', compact('divisions', 'divisionArr'))->render();
    }

    /**
     * Return house name nby house id
     *
     * @param $classId
     * @return mixed
     */
    public  function getSectionByTitle($title)
    {
        return self::where('title', $title)->pluck('id')->first();
    }
}
