<?php

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | This file is where you may define all of the routes that are handled
  | by your module. Just tell Laravel the URIs it should respond
  | to using a Closure or controller method. Build something great!
  |
 */

Route::group(['middleware' => ['auth:web,saas', 'acl']], function () {
    Route::resource('staffs', 'StaffController');
    Route::get('teacher', ['as' => 'teacher.index','uses' => 'StaffController@index']);
    Route::get('teacher-profile', ['as' => 'teacher.profile','uses' => 'StaffController@teacherProfile']);
    Route::patch('update-teacher-profile/{staffId}', ['as' => 'teacher-profile.update','uses' => 'StaffController@updateTeacherProfile']);
    Route::any('import-staffs/', ['as'   => 'import-teachers.index', 'uses' => 'StaffController@import']);
    Route::any('import-staffs/save', ['as'   => 'import-teachers.save', 'uses' => 'StaffController@importSave']);
    Route::any('change-password', ['as' => 'staff.change-password', 'uses'=>'StaffController@changePassword']);
    Route::any('reset-password', ['as' => 'reset-password.index', 'uses'=>'StaffController@resetPassword']);
});
