@extends('layouts.master')

@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('locale.staff')]) @stop

@if(isset($staff) && isset($isTeacherProfile))
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.edit').' '.__('locale.profile') ]) @stop

@else
@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('locale.add').' '.__('locale.staff') ]) @stop
@endif

@section('quick_link')
@section('quick_link')
    <a href="{{ route($moduleName.'.index') }}" class="btn btn-info btn-labeled" title="{{ __('locale.list') }}"><b><i
                class="icon-list-unordered"></i></b>{{ __('locale.list')  }}</a>
@stop


@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box">
                @include('layouts.modules.header', [ 'title' => __('Basic Information')])
                <div class="card-body row">

                    @if(isset($staff) && isset($isTeacherProfile))
                        {!! Form::model($staff, ['route' => ['teacher-profile.update', $staff->id] ,'files' => true, "type" => "card" ]) !!}
                    @elseif(isset($staff))
                        {!! Form::model($staff, ['route' => [$moduleName.'.update', $staff->id] ,'files' => true, "type" => "card" ]) !!}
                    @else
                        {!! Form::open([ 'route' => $moduleName.'.store' ,'files' => true, "type" => "card"]) !!}
                    @endif
                        {!! Form::hidden('user_id', $staff->user->id ??  old('user_id')) !!}
                        <div class="row {{ \App\Facades\General::isSchoolAdmin() && !isset($isTeacherProfile) ? 'show' : 'hide'  }} ">
                            {!!  Form::openGroup('staff_id', 'staff::locale.staff_id') !!}
                            {!!  Form::text('staff_id', $staff->staff_id ?? old('staff_id')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('role', 'staff::locale.role' ,array("lbl_class" => "required")) !!}
                            {!!  Form::select('role', $staff_roles,$staff->role ?? old('role'), array("required" => "true", 'class'=> 'mdl-textfield__input form-control','defaultTxt' => trans( 'locale.select' ) ) ) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('designation', 'staff::locale.designation') !!}
                            {!!  Form::select('designation_id', $designations,$staff->designation_id ?? old('designation_id'), array('class'=> 'mdl-textfield__input form-control','id' => 'designation_id','defaultTxt' => trans( 'locale.select' ) ) ) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('department', 'staff::locale.department' ) !!}
                            {!!  Form::select('department_id', $departments,$staff->department_id ?? old('department_id'), array('class'=> 'mdl-textfield__input form-control','id' => 'department_id','defaultTxt' => trans( 'locale.select' ) ) ) !!}
                            {!!  Form::closeGroup() !!}
                        </div>
                    <div class="row">
                        {!!  Form::openGroup('name', 'locale.name',array("lbl_class" => "required")) !!}
                        {!!  Form::text('name',$staff->user->name ?? old('name'),array("required" => true)) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('mobile_number', 'staff::locale.mobile_number') !!}
                        {!!  Form::text('mobile_number',$staff->user->mobile_number ?? old('mobile_number')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('father_name', 'staff::locale.father_name') !!}
                        {!!  Form::text('father_name', $staff->father_name ?? old('father_name')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('mother_name', 'staff::locale.mother_name') !!}
                        {!!  Form::text('mother_name', $staff->mother_name ?? old('mother_name')) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">
                        {!!  Form::openGroup('email', 'staff::locale.email_login',array("lbl_class" => "required")) !!}
                        {!!  Form::text('email',$staff->user->email ?? old('email'),array("required" => true)) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('gender', 'staff::locale.gender') !!}
                        {!!  Form::select('gender', [null=>'Please Select'] + $genders, $staff->user->gender ?? old('gender'),['class' => 'mdl-textfield__input form-control']) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('dob', 'staff::locale.dob') !!}
                        {!!  Form::text('dob', $staff->user->dob ?? old('dob'),[ 'id' => 'dob',"autocomplete" => "off",'class' => 'mdl-textfield__input setDatePicker']) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('joining_date', 'staff::locale.joining_date') !!}
                        {!!  Form::text('joining_date', $staff->joining_date ?? old('joining_date'),["autocomplete" => "off",'class' => 'mdl-textfield__input setDatePicker']) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">

                        {!!  Form::openGroup('marital_status', 'staff::locale.marital_status') !!}
                        {!!  Form::select('marital_status', [null=>'Please Select'] + $marital_status, $staff->marital_status ?? old('marital_status'),['class' => 'mdl-textfield__input form-control']) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('avatar',  Lang::get('staff::locale.avatar')) !!}
                        {!!  Form::file('avatar') !!}
                        @push("scripts-joining_letter")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('note', 'staff::locale.note', array('class' => 'col-md-6')) !!}
                        {!!  Form::textarea('note',$staff->note ?? old('note'),["rows" => 4]) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                    <div class="row">
                        {!!  Form::openGroup('current_address', 'staff::locale.current_address') !!}
                        {!!  Form::textarea('current_address',$staff->user->current_address ?? old('current_address'),["rows" => 4]) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('permanent_address', 'staff::locale.permanent_address') !!}
                        {!!  Form::textarea('permanent_address',$staff->user->permanent_address ?? old('permanent_address'),["rows" => 4]) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('qualification', 'staff::locale.qualification') !!}
                        {!!  Form::textarea('qualification',$staff->qualification ?? old('qualification'),["rows" => 4]) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('work_exp', 'staff::locale.work_exp') !!}
                        {!!  Form::textarea('work_exp',$staff->work_exp ?? old('work_exp'),["rows" => 4]) !!}
                        {!!  Form::closeGroup() !!}
                    </div>

                    @if(\App\Facades\General::isSchoolAdmin() && !isset($isTeacherProfile))
                        <div class="row">
                            {!!  Form::openGroup('view_contact', 'locale.view_contact') !!}
                            {!!  Form::checkbox('view_contact', 1, (isset($staff->view_contact) && $staff->view_contact == 1 ? 'checked' : '') , ['id' => "view_contact","class" => "form-control"]) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('student_action', 'locale.student_action') !!}
                            {!!  Form::checkbox('student_action', 1,(isset($staff->student_action) && $staff->student_action == 1 ? 'checked' : ''), ['id' => "student_action","class" => "form-control"]) !!}
                            {!!  Form::closeGroup() !!}
                        </div>
                    @endif
                </div>

            </div>
            @if(\App\Facades\General::isSchoolAdmin() && !isset($isTeacherProfile))
                <div class="card card-topline-aqua">
                    @include('layouts.modules.header', [ 'title' => __('Payroll'), 'hide'=> true])
                    <div class="card-body row">
                        <div class="row">
                            {!!  Form::openGroup('epf_no', 'staff::locale.epf_no') !!}
                            {!!  Form::text('epf_no', $staff->epf_no ?? old('epf_no')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('basic_salary', 'staff::locale.basic_salary') !!}
                            {!!  Form::text('basic_salary', $staff->basic_salary ?? old('basic_salary')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('contract_type', 'staff::locale.contract_type') !!}
                            {!!  Form::text('contract_type', $staff->contract_type ?? old('contract_type')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('work_shift', 'staff::locale.work_shift') !!}
                            {!!  Form::text('work_shift', $staff->work_shift ?? old('work_shift')) !!}
                            {!!  Form::closeGroup() !!}
                        </div>
                        <div class="row">
                            {!!  Form::openGroup('location', 'staff::locale.location') !!}
                            {!!  Form::text('location', $staff->location ?? old('location')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('alloted_leave_1', 'staff::locale.alloted_leave_1') !!}
                            {!!  Form::text('alloted_leave_1', $staff->alloted_leave_1 ?? old('alloted_leave_1')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('alloted_leave_2', 'staff::locale.alloted_leave_2') !!}
                            {!!  Form::text('alloted_leave_2', $staff->alloted_leave_2 ?? old('alloted_leave_2')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('alloted_leave_3', 'staff::locale.alloted_leave_3') !!}
                            {!!  Form::text('alloted_leave_3', $staff->alloted_leave_3 ?? old('alloted_leave_3')) !!}
                            {!!  Form::closeGroup() !!}
                        </div>
                        <div class="row">
                            {!!  Form::openGroup('account_title', 'staff::locale.account_title') !!}
                            {!!  Form::text('account_title', $staff->account_title ?? old('account_title')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('bank_account_no', 'staff::locale.bank_account_no') !!}
                            {!!  Form::text('bank_account_no', $staff->bank_account_no ?? old('bank_account_no')) !!}
                            {!!  Form::closeGroup() !!}


                            {!!  Form::openGroup('bank_name', 'staff::locale.bank_name') !!}
                            {!!  Form::text('bank_name', $staff->bank_name ?? old('bank_name')) !!}
                            {!!  Form::closeGroup() !!}

                            {!!  Form::openGroup('ifsc_code', 'staff::locale.ifsc_code') !!}
                            {!!  Form::text('ifsc_code', $staff->ifsc_code ?? old('ifsc_code')) !!}
                            {!!  Form::closeGroup() !!}
                        </div>
                    </div>
                </div>
            @endif

            <div class="card card-topline-aqua">
                @include('layouts.modules.header', [ 'title' => __('Social Media'), 'hide'=> true])
                <div class="card-body row">
                    <div class="row">
                        {!!  Form::openGroup('fb_url', 'staff::locale.fb_url') !!}
                        {!!  Form::text('fb_url', $staff->fb_url ?? old('fb_url')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('twitter_url', 'staff::locale.twitter_url') !!}
                        {!!  Form::text('twitter_url', $staff->twitter_url ?? old('twitter_url')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('linkedin_url', 'staff::locale.linkedin_url') !!}
                        {!!  Form::text('linkedin_url', $staff->linkedin_url ?? old('linkedin_url')) !!}
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('instagram_url', 'staff::locale.instagram_url') !!}
                        {!!  Form::text('work_shift', $staff->instagram_url ?? old('instagram_url')) !!}
                        {!!  Form::closeGroup() !!}
                    </div>
                </div>
            </div>
            @if(\App\Facades\General::isSchoolAdmin() && !isset($isTeacherProfile))
            <div class="card card-topline-aqua">
                @include('layouts.modules.header', [ 'title' => __('Documents'), 'hide'=> true])
                <div class="card-body row">
                    <div class="row">
                        {!!  Form::openGroup('resume',  Lang::get('staff::locale.resume')) !!}
                        {!!  Form::file('resume') !!}
                        @push("scripts-footer")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('document',  Lang::get('staff::locale.document')) !!}
                        {!!  Form::file('document') !!}
                        @push("scripts-footer")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}

                        {!!  Form::openGroup('joining_letter',  Lang::get('staff::locale.joining_letter')) !!}
                        {!!  Form::file('photo') !!}
                        @push("scripts-joining_letter")
                            {!!  Form::filejs() !!}
                        @endpush
                        {!!  Form::closeGroup() !!}
                    </div>
                </div>
            </div>
            @endif
            <div class="row"> @include('layouts.forms.actions')</div>
            {!! Form::close() !!}
        </div>
@stop
@push('scripts')
@endpush
