@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Users')]) @stop

@section('content')
    <div class="row __sms__datatable">
        <div class="col-md-12">
            <div class="card card-topline-aqua">
                @include('layouts.modules.header', ['actionAddNew' => route($moduleName.'.create'), 'title' => __('Users').' '.__('List')])
                <div class="card-body">
                    <div class="table-scrollable">
                        <table id="{{$moduleName}}-table"
                               class="display table table-checkable order-column valign-middle" style="width: 100%">
                            <thead>
                            <tr>
                                <th width="20%"> {{ __('Name') }}</th>
                                <th> {{ __('Email') }}</th>
                                <th width="15%"> {{ __('Is Super') }}</th>
                                <th width="15%"> {{ __('Action') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')

    <!-- data tables -->
    <script>
        let columnsArray = [
            {data: 'name', name: 'name'},
            {data: 'email', name: 'email'},
            {data: 'is_super', name: 'is_super'},
            {data: 'action', name: 'action'}];
        let routeUrl = "{{ route($moduleName.'.index') }}";
        let tableRef = "{{ $moduleName.'-table'}}";
        // Run the Datatable
        let table = __commonDatatableListing(tableRef, routeUrl, columnsArray);

        $(function () {
            $('#{{$moduleName}}-table tbody').on('click', 'tr', function (evt) {
                let href = $(this).find("a#view").attr('href');
                let $cell = $(evt.target).closest('td');
                if ($cell.index() != 4 && href) {
                    $(location).attr('href', href);

                }
            });
        });
    </script>
@stop

