<?php

namespace App\Modules\Saasuser\Providers;

use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('saasuser', 'Resources/Lang', 'app'), 'saasuser');
        $this->loadViewsFrom(module_path('saasuser', 'Resources/Views', 'app'), 'saasuser');
        $this->loadMigrationsFrom(module_path('saasuser', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('saasuser', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('saasuser', 'Database/Factories', 'app'));
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
