<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\UserSetting;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function changeLocale(Request $request)
    {
        $language = $request->lang ?? 'ar';

        session(['selected_language' => $language]);
        $user = (new User())->findById(Auth::user()->id);
        $user->locale = $language;
        $user->save();

        return redirect(URL::previous());
    }

    /**
     * Update configuration for super admin
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function setConfigAccount(Request $request)
    {
        $options = [
            'option_name'  => 'default_account_id',
            'option_value' => $request->accountId,
            'user_id'      => Auth::user()->id,
        ];

        UserSetting::updateSettingByName($options);

        return response()->json(["status" => true], 200);
    }
}
