<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Account;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Contracts\View\Factory;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\View\View;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

//    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
//    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('guest:saas')->except('logout');
    }

    /**
     * Show sass admin login form
     *
     * @return Factory|View
     */
    public function showAdminLoginForm()
    {
        if (view()->exists('auth.authenticate')) {
            return view('auth.authenticate');
        }

        return view('auth.login_admin');
    }

    public function adminLogin(Request $request)
    {
        if (Auth::guard('saas')->attempt([
            'email'    => $request->email,
            'password' => $request->password
        ], $request->get('remember'))) {

            // If the current user is deactivated
            /*if (!is_null(auth()->user()->deleted_at)) {

                auth()->logout();
                return back()->withInput($request->only('email', 'remember'))
                    ->withErrors(['email' => trans('auth.auth_deactivate')]);
            }*/

            Config::set('account.id', 1);

            // Redirect to the main dashboard
            return redirect()->intended('dashboard');

        }
        return back()->withInput($request->only('email', 'remember'))
            ->withErrors(['email' => trans('auth.auth_fail')]);
    }

    /**
     * @return Factory|View
     */
    public function showUserLoginForm()
    {
        if (view()->exists('auth.authenticate')) {
            return view('auth.authenticate');
        }

        return view('auth.login');
    }

    /**
     * Handle an authentication attempt.
     *
     * @param Request $request
     * @return RedirectResponse|Redirector
     */
    public function userLogin(Request $request)
    {

        if (Auth::guard('web')->attempt([
            'email'    => $request->email,
            'password' => $request->password
        ], $request->get('remember'))) {

            // check the condition that user belong to same school
            if (auth()->user()->account_id != Config::get('account.id')) {

                auth()->logout();
                return back()->withInput($request->only('email', 'remember'))
                    ->withErrors(['email' => trans('auth.auth_notBelongToSchool')]);
            }

            // Check the school account is activated
            $schoolStatus = Account::where('id', Config::get('account.id'))->pluck('is_activated')->first();
            if ($schoolStatus == 0) {

                auth()->logout();
                return back()->withInput($request->only('email', 'remember'))
                    ->withErrors(['email' => trans('auth.account_not_activated')]);
            }

            // If the current user is deactivated
            if (!is_null(auth()->user()->deleted_at) || auth()->user()->is_active == 0) {

                auth()->logout();
                return back()->withInput($request->only('email', 'remember'))
                    ->withErrors(['email' => trans('auth.auth_deactivate')]);
            }

            if (auth()->user()->locale!='' && auth()->user()->locale!=null){
                session(['selected_language' => auth()->user()->locale]);
            }


            // Redirect to the main dashboard
            return redirect()->intended('dashboard');

        }
        return back()->withInput($request->only('email', 'remember'))
            ->withErrors(['email' => trans('auth.auth_fail')]);

    }

    use AuthenticatesUsers {
        logout as performLogout;
    }

    /**
     *  User Logout route to Login page
     * @param Request $request
     * @return RedirectResponse
     */
    public function logout(Request $request)
    {
        $this->performLogout($request);

        return redirect()->route('login');
    }

}
