<?php
require_once 'inc/db.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Order ID not specified.");
}

$sale_id = intval($_GET['id']);

// Fetch sale info
$saleQuery = $conn->prepare("
    SELECT s.*, a.agencyname, a.ownername, a.address AS agency_address, a.phone AS agency_phone, a.email AS agency_email, fy.year_label
    FROM sales s
    INNER JOIN agency a ON s.agency_id = a.id
    INNER JOIN financial_years fy ON s.financial_year_id = fy.id
    WHERE s.id = ?
");
$saleQuery->bind_param("i", $sale_id);
$saleQuery->execute();
$saleResult = $saleQuery->get_result();
if ($saleResult->num_rows == 0) die("Order not found.");
$sale = $saleResult->fetch_assoc();

// Fetch items
$itemQuery = $conn->prepare("
    SELECT si.*, n.name as newspaper_name
    FROM sales_items si
    INNER JOIN newspapers n ON si.newspaper_id = n.id
    WHERE si.sale_id = ?
");
$itemQuery->bind_param("i", $sale_id);
$itemQuery->execute();
$itemResult = $itemQuery->get_result();
$items = [];
while ($row = $itemResult->fetch_assoc()) {
    $items[] = $row;
}

// Company info
$companyName = "Your Company Name Pvt. Ltd.";
$companyAddress = "123, Business St, Corporate City, State - 100100";
$companyPhone = "+91 99999 99999";
$companyEmail = "info@company.com";
$companyLogo = "assets/img/logo.png"; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice #<?= htmlspecialchars($sale['bill_no']) ?></title>
<style>
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: #f4f6f9;
    margin: 0;
    padding: 20px;
    color: #333;
}

/* Invoice Box */
.invoice-container {
    width: 210mm;
    min-height: 297mm;
    margin: auto;
    background: #fff;
    padding: 10mm;
    box-shadow: 0 0 10px rgba(0,0,0,0.15);
    border-radius: 6px;
}

/* Header */
.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #004080;
    padding-bottom: 10px;
}
.header .logo img { max-height: 50px; }
.header .company-info { text-align:right; font-size:13px; color:#555; }
.header .company-info strong { font-size:16px; color:#004080; }

/* Invoice Title */
h2 {
    text-align: center;
    margin: 20px 0;
    color: #004080;
    text-transform: uppercase;
    letter-spacing: 2px;
    border-top:1px solid #ccc;
    border-bottom:1px solid #ccc;
    padding:8px 0;
}

.customer-info {
    display: flex;
    justify-content: space-between;
    margin: 20px 0;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 6px;
    overflow: hidden;
}

/* Agency details (bigger width) */
.customer-info .agency {
    flex: 2;              /* take 2/3 width */
    padding: 12px;
    border-right: 1px solid #ccc;
    line-height: 1.6;
}

/* Bill details (smaller width) */
.customer-info .bill {
    flex: 1;              /* take 1/3 width */
    padding: 12px;
    text-align: right;
    line-height: 2.0;
}

.customer-info strong { color:#004080; }

/* Table */
table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
    margin-top: 20px;
}
th, td {
    border: 1px solid #ddd;
    padding: 8px;
}
th {
    background: #004080;
    color: #fff;
    text-align: center;
}
td { text-align: center; }
td.text-left { text-align: left; }
tfoot td { font-weight: bold; }

/* Remarks */
.remarks {
    margin-top: 20px;
    font-size: 13px;
    border-left: 4px solid #004080;
    background: #f9f9f9;
    padding: 10px;
    border-radius: 4px;
}

/* Signature */
.signature {
    margin-top: 60px;
    display: flex;
    justify-content: flex-end;
    font-size: 14px;
}
.signature .sign-box {
    text-align: center;
    width: 220px;
}
.signature .line {
    border-top: 1px solid #000;
    margin-bottom: 5px;
    height: 20px;
}
.signature p {
    margin: 0;
    font-weight: bold;
}

/* Print */
@media print {
  body {
    -webkit-print-color-adjust: exact; /* Chrome, Safari */
    print-color-adjust: exact; /* Modern browsers */
    background: #fff !important;
    color: #000 !important;
  }

  .print-btn { display: none !important; }

  .invoice-container {
    box-shadow: none !important;
    border-radius: 0 !important;
    padding: 5mm !important; /* Safe padding for printers */
    background-color: #f9f9f9 !important; /* Light background */
  }
}


</style>
</head>
<body>

<div class="invoice-container">
<div class="print-btn">
    <button onclick="window.print()">Print Order</button>
</div>
    <div class="header">
        <div class="logo">
            <img src="<?= $companyLogo ?>" alt="Company Logo">
        </div>
        <div class="company-info">
            <strong><?= $companyName ?></strong><br>
            <?= $companyAddress ?><br>
            Phone: <?= $companyPhone ?><br>
            Email: <?= $companyEmail ?>
        </div>
    </div>

    <h2>Invoice</h2>

    <div class="customer-info">
        <div class="agency">
            <strong>To:</strong> <?= ucwords(htmlspecialchars($sale['agencyname'])) ?><br>
            <strong>Address:</strong> <?= nl2br(ucwords(htmlspecialchars($sale['agency_address']))) ?><br>
            <strong>Phone:</strong> <?= htmlspecialchars($sale['agency_phone']) ?><br>
        </div>
        <div class="bill">
            <strong>Bill No:</strong> <?= htmlspecialchars($sale['bill_no']) ?><br>
            <strong>Date:</strong> <?= date("d-m-Y", strtotime($sale['sale_date'])) ?><br>
            
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Newspaper</th>
                <th>Rate</th>
                <th>Qty</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $totalQty = 0; $subtotal = 0;
            foreach($items as $index => $item):
                $amount = $item['qty'] * $item['rate'];
                $totalQty += $item['qty'];
                $subtotal += $amount;
            ?>
            <tr>
                <td><?= $index+1 ?></td>
                <td class="text-left"><?= ucwords(htmlspecialchars($item['newspaper_name'])) ?></td>
                <td><?= number_format($item['rate'],2) ?></td>
                <td><?= $item['qty'] ?></td>
                <td><?= number_format($amount,2) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="3" style="text-align:right;">Total Qty</td>
                <td><?= $totalQty ?></td>
                <td></td>
            </tr>
            <tr>
                <td colspan="4" style="text-align:right;">Subtotal</td>
                <td><?= number_format($subtotal,2) ?></td>
            </tr>
            <?php if ($sale['transport_charge'] != 0): ?>
            <tr>
                <td colspan="4" style="text-align:right;">Transport</td>
                <td><?= number_format($sale['transport_charge'],2) ?></td>
            </tr>
            <?php endif; ?>
            <?php if ($sale['discount'] != 0): ?>
            <tr>
                <td colspan="4" style="text-align:right;">Discount</td>
                <td><?= number_format($sale['discount'],2) ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <td colspan="4" style="text-align:right;">Grand Total</td>
                <td><?= number_format($sale['total_amount'],2) ?></td>
            </tr>
        </tfoot>
    </table>

    <?php if(!empty($sale['remarks'])): ?>
    <div class="remarks">
        <strong>Remarks:</strong> <?= htmlspecialchars($sale['remarks']) ?>
    </div>
    <?php endif; ?>

    <div class="signature">
        <div class="sign-box">
            <div class="line"></div>
            <p>Authorised Signature</p>
        </div>
    </div>

</div>

</body>
</html>
