<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );
function main() {
	?>
	<div class="container-xxl flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb breadcrumb-custom-icon">
				<li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item active">Newspepar</li>
			</ol>
		</nav>
		<button type="button" class="btn btn-sm rounded-pill btn-primary" data-bs-toggle="modal" data-bs-target="#newspeparModal"><i class="ti ti-plus me-sm-1"></i>Add Newspepar</button>
		
		<div class="modal fade" id="newspeparModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="newspeparForm" method="post" enctype="multipart/form-data">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title">Add/Edit Newspepar</h5>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
       <input type="hidden" id="id" name="id" />
	  		<input type="hidden" id="role" name="role" value="admin" />

      <div class="row mb-3">
        <div class="col-md-12 mb-3">
          <label class="form-label">Newspepar Name</label>
          <input type="text" class="form-control" name="name" id="name" required />
        </div>
		<div class="col-md-12 mb-3">

									<label for="price" class="form-label">Price</label>
									<input type="number" name="price" id="price" class="form-control" step="0.01" value="0.00" required>
								</div>
		<div class="col-md-12 mb-3">
              <label class="form-label">Status</label>
               <select class="form-select" name="status" id="status">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
              </select>
            </div>
        
      </div>
    </div>

    <div class="modal-footer">
      <button type="submit" class="btn btn-primary">Save</button>
      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
    </div>
  </div>
</form>

  </div>
</div>

		<div class="card">

			<div id="alert-box" class="alert d-none" role="alert"></div>
			<div class="card-datatable text-nowrap">
<table class="datatables-ajax table table-bordered">
  <thead>
    <tr>
      <th>#</th>
      <th>Pepar Name</th>
		<th>Price</th>
       <th>Status</th>
	   <th>Action</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>

			</div>
		</div>
	</div>
<script>
$(document).ready(function () {
  fetchNewspepars();

  function showToast(message, type = 'success') {
    const alertBox = $('#alert-box');
    alertBox.removeClass('d-none alert-success alert-danger')
            .addClass(`alert alert-${type}`)
            .text(message);

    setTimeout(() => {
      alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
    }, 3000);
  }

  // Handle form submit
  $('#newspeparForm').on('submit', function (e) {
  e.preventDefault();

  const modalEl = document.getElementById('newspeparModal');
  const modal = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);
  modal.hide();

  const formData = new FormData(this);

  $.ajax({
    url: 'controllers/NewspaperController.php',
    method: 'POST',
    data: formData,
    contentType: false,
    processData: false,
    success: function (res) {
      try {
        let result = JSON.parse(res);

        if (result.status === 'success') {
          // Success
          $('#newspeparForm')[0].reset();
          $('#id').val('');
          fetchNewspepars();
          showToast(result.message, 'success');

        } else if (result.status === 'error') {
          // Show array of errors or single message
          if (result.errors && Array.isArray(result.errors)) {
            result.errors.forEach(err => showToast(err, 'danger'));
          } else if (result.message) {
            showToast(result.message, 'danger');
          } else {
            showToast('Something went wrong.', 'danger');
          }

        } else {
          showToast('Unexpected response.', 'danger');
        }
      } catch (err) {
        console.error("Parse error:", res);
        showToast('Invalid server response.', 'danger');
      }
    },
    error: function () {
      showToast('Something went wrong. Try again.', 'danger');
    }
  });
});

  // Edit Button
  $(document).on('click', '.editBtn', function () {
    const id = $(this).data('id');
    $.post('controllers/NewspaperController.php', { action: 'getNewspepar', id }, function (data) {
        const user = JSON.parse(data);
        $('#id').val(user.id);
        $('#name').val(user.name);
		$('#price').val(user.price);
        $('#status').val(user.status);
        $('#newspeparModal').modal('show');
    });
});


  // Delete Button
  $(document).on('click', '.deleteBtn', function () {
    const id = $(this).data('id');
    Swal.fire({
      title: 'Are you sure?',
      text: "Do you really want to delete this user?",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#6c757d',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed) {
        $.post('controllers/NewspaperController.php', { action: 'deleteNewspepar', id }, function (res) {
          let result = JSON.parse(res);
          if (result.status === 'success') {
            fetchNewspepars();
            Swal.fire('Deleted!', result.message, 'success');
          } else {
            Swal.fire('Error!', result.message, 'error');
          }
        });
      }
    });
  });

  // Status Toggle
  $(document).on('change', '.toggleStatus', function () {
    const id = $(this).data('id');
    $.post('controllers/NewspaperController.php', { action: 'toggleStatus', id }, function (res) {
      const result = JSON.parse(res);
      showToast(result.message, result.status === 'success' ? 'success' : 'danger');
      fetchNewspepars();
    });
  });

  // Fetch users
  function fetchNewspepars() {
    $.get('controllers/NewspaperController.php', { action: 'Newspeparlist' }, function (html) {
      if ($.fn.DataTable.isDataTable('.datatables-ajax')) {
        $('.datatables-ajax').DataTable().destroy();
      }
      $('.datatables-ajax tbody').html(html);
      $('.datatables-ajax').DataTable({
        processing: true,
        responsive: true,
        scrollX: true,
        order: [[0, 'asc']]
      });
    });
  }
});

</script>	
<?php } ?>