<?php
class FyModel {
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function listFinancialYears() {
        $stmt = $this->conn->prepare("SELECT * FROM financial_years ORDER BY year_label DESC");
        $stmt->execute();
        return $stmt->get_result();
    }

    public function dropdownFinancialYears() {
        $stmt = $this->conn->prepare("SELECT id, year_label FROM financial_years WHERE status = 'active' ORDER BY year_label DESC");
        $stmt->execute();
        return $stmt->get_result();
    }
	
		public function getActiveFinancialYearId() {
		$sql = "SELECT id, year_label FROM financial_years WHERE status = 1 ORDER BY year_label DESC LIMIT 1";
        $result = $this->conn->query($sql);
        if ($result && $row = $result->fetch_assoc()) {
            return $row;
        }
        return ['id' => 0, 'year_label' => ''];
		}


    public function getFinancialYearById($id) {
        $stmt = $this->conn->prepare("SELECT * FROM financial_years WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function isDuplicate($year_label, $excludeId = null) {
        if ($excludeId) {
            $stmt = $this->conn->prepare("SELECT id FROM financial_years WHERE year_label = ? AND id != ?");
            $stmt->bind_param("si", $year_label, $excludeId);
        } else {
            $stmt = $this->conn->prepare("SELECT id FROM financial_years WHERE year_label = ?");
            $stmt->bind_param("s", $year_label);
        }
        $stmt->execute();
        $stmt->store_result();
        return $stmt->num_rows > 0;
    }

    public function insert($data) {
        $stmt = $this->conn->prepare("INSERT INTO financial_years (year_label, start_date, end_date, status) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $data['year_label'], $data['start_date'], $data['end_date'], $data['status']);
        return $stmt->execute();
    }

    public function update($data) {
        $stmt = $this->conn->prepare("UPDATE financial_years SET year_label = ?, start_date = ?, end_date = ?, status = ? WHERE id = ?");
        $stmt->bind_param("ssssi", $data['year_label'], $data['start_date'], $data['end_date'], $data['status'], $data['id']);
        return $stmt->execute();
    }

    public function delete($id) {
        $stmt = $this->conn->prepare("DELETE FROM financial_years WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }

    public function toggleStatus($id) {
        $year = $this->getFinancialYearById($id);
        if (!$year) return false;

        $newStatus = ($year['status'] === 'active') ? 'inactive' : 'active';
        $stmt = $this->conn->prepare("UPDATE financial_years SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $newStatus, $id);
        return $stmt->execute();
    }
}
