<?php
error_reporting( 0 );

// Always start session before auth check
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Correct include (same folder)
require_once 'inc/auth_check.php'; // protect access

$welcomeMessage = '';

if (isset($_SESSION['welcome_message'])) {
    $welcomeMessage = $_SESSION['welcome_message'];
    unset($_SESSION['welcome_message']); // show only once
}
?>

<!doctype html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/"  data-template="vertical-menu-template" data-style="light">
<head>
<meta charset="utf-8" />
<meta name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
<?php include('meta-tag.php'); ?>
<meta name="description" content="" />
<!-- Favicon -->
<link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />
<!-- Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com" />
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap"
      rel="stylesheet" />
<!-- Icons -->
<link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css" />
<link rel="stylesheet" href="assets/vendor/fonts/tabler-icons.css" />
<!-- Core CSS -->
<link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
<link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
<link rel="stylesheet" href="assets/css/demo.css" />
<link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />
<link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
<link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css" />
<link rel="stylesheet" href="assets/vendor/libs/swiper/swiper.css" />
<link rel="stylesheet" href="assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<!--<link rel="stylesheet" href="assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />-->
<script src="assets/vendor/js/helpers.js"></script>
<script src="assets/vendor/js/template-customizer.js"></script>
<script src="assets/js/config.js"></script>
<link rel="stylesheet" href="assets/toastr.min.css">
<script src="assets/js/sweetalert2@11.js"></script>
<script src="assets/js/jquery-3.6.0.min.js"></script>
<script src="assets/toastr.min.js"></script>
</head>

<body>
<script>
document.addEventListener("DOMContentLoaded", function () {
    <?php if (!empty($welcomeMessage)): ?>
        toastr.options = {
            "positionClass": "toast-top-right",
            "timeOut": 3000,
            "closeButton": true,
        };
        toastr.success("<?= addslashes($welcomeMessage) ?>");
    <?php endif; ?>
});
</script>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
  <div class="layout-container"> 
    <!-- Menu -->
    <?php include('side_menu.php');?>
    
    <!-- / Menu --> 
    
    <!-- Layout container -->
    <div class="layout-page"> 
      <!-- Navbar -->
      
      <?php include('header.php');?>
      
      <!-- / Navbar --> 
      
      <!-- Content wrapper -->
      <div class="content-wrapper"> 
        <!-- Content -->
        
        <?php main(); ?>
        <!-- / Content --> 
        
        <!-- Footer -->
        <?php include('footer.php'); ?>
        <!-- / Footer -->
        
     </div>
      <!-- Content wrapper --> 
    </div>
    <!-- / Layout page --> 
  </div>
   
</div>
<script src="assets/vendor/libs/jquery/jquery.js"></script> 
<script src="assets/vendor/libs/popper/popper.js"></script> 
<script src="assets/vendor/js/bootstrap.js"></script> 
<script src="assets/vendor/libs/node-waves/node-waves.js"></script> 
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script> 
<script src="assets/vendor/libs/hammer/hammer.js"></script> 
<script src="assets/vendor/libs/i18n/i18n.js"></script> 
<script src="assets/vendor/libs/typeahead-js/typeahead.js"></script> 
<script src="assets/vendor/js/menu.js"></script> 
<!--<script src="assets/vendor/libs/swiper/swiper.js"></script> -->
<script src="assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script> 
<!-- Main JS --> 
<script src="assets/js/main.js"></script> 
<!-- Page JS --> 
<!--<script src="assets/js/tables-datatables-advanced.js"></script>-->
</body>
</html>
