<!doctype html>
<html lang="en" class="layout-wide customizer-hide" dir="ltr" data-skin="default" data-assets-path="assets/" data-template="horizontal-menu-template"  data-bs-theme="light">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Forgot Password | News Pepars</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicon/favicon-16x16.png">
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link rel="stylesheet" href="assets/vendor/fonts/iconify-icons.css" />
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="assets/vendor/libs/pickr/pickr-themes.css" />
    <link rel="stylesheet" href="assets/vendor/css/rtl/core.css" />
    <link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css"/>
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css" />
    <script src="assets/vendor/js/helpers.js"></script>
        <script src="assets/js/config.js"></script>
	<script src="assets/js/jquery.min.js"></script>
	<link rel="stylesheet" href="assets/toastr.min.css">
	<script src="assets/toastr.min.js"></script>
</head>

<body style="background-image: url('assets/img/bg.jpg'); background-size: cover; background-repeat: no-repeat; background-position: center center; min-height: 100vh;">

	<div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-4">
		
            <div class="card">
            <div class="card-body">
              <!-- Logo -->
              <div class="app-brand justify-content-center mb-4 mt-2">
               <a href="#" class="app-brand-link gap-2">
                <span class="app-brand-logo demo">
                  <img src="assets/img/logo.png" width="250" class="img-fluid">
                </span>
              </a>
              </div>
              	<h4 class="mb-1" align="center">Forgot Password </h4>
				<div class="alert d-none mt-3" id="alert-box" role="alert"></div>
            	<form class="mb-3" action="#" method="POST" id="AdminAuthentication">
					<div class="mb-3">
						<input type="hidden" name="action" value="forgotPassword">	
					<label for="email" class="form-label">Email</label>
                  <input type="email" class="form-control" id="email" name="email" placeholder="Enter your email" autofocus />
						</div>
						
						<button class="btn btn-primary d-grid w-100 mb-3" type="submit" name="reset_password">Send Reset Link</button>
						<div class="text-center">
							<a href="index.php">
                  <i class="icon-base ti tabler-chevron-left scaleX-n1-rtl"></i>
                  Back to login
                </a>
						
						</div>
					</form>

            </div>
          </div>
		
	
		</div>
	</div>
	<script>
  // Toast message function
  function showToast(message, type = 'success') {
    const alertBox = document.getElementById('alert-box');
    alertBox.className = `alert alert-${type}`;
    alertBox.textContent = message;
    alertBox.classList.remove('d-none');

    setTimeout(() => {
      alertBox.classList.add('d-none');
      alertBox.textContent = '';
    }, 3000);
  }

  // Form submit handler
  document.addEventListener("DOMContentLoaded", function () {
    const form = document.getElementById("AdminAuthentication");

    form.addEventListener("submit", function (e) {
      e.preventDefault();
      const formData = new FormData(form);

      fetch("controllers/ForgotController.php", {
        method: "POST",
        body: formData
      })
      .then(res => res.json())
      .then(data => {
        if (data.status === 'success') {
          showToast("Redirecting to reset page...", 'success');
    setTimeout(() => {
      window.location.href = data.reset_url; // Redirect to reset page
    }, 1000);
        } else {
          showToast(data.message, 'danger');
        }
      })
      .catch(error => {
        console.error("Reset error:", error);
        showToast("An unexpected error occurred.", 'danger');
      });
    });
  });
</script>


<script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/@algolia/autocomplete-js.js"></script>
    <script src="assets/vendor/libs/pickr/pickr.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/libs/hammer/hammer.js"></script>
    <script src="assets/vendor/libs/i18n/i18n.js"></script>
    <script src="assets/vendor/js/menu.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/pages-auth.js"></script>
  </body>
</html>
