<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>
	<div class="container-xxl flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb breadcrumb-custom-icon">
				<li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item"><a href="agency_list.php">Agency List</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item active">Agency Add</li>
			</ol>
		</nav>

		<div class="card mb-6">
			<div class="position-fixed top-0 end-0 p-3" style="z-index: 1080">
  <div id="toastContainer"></div>
</div>

			<form class="card-body" method="POST" enctype="multipart/form-data" id="agencyForm">
  <div class="row g-6">

    <h5 class="mb-3">Agency Registration</h5>

    <!-- Hidden ID (for update) -->
    <input type="hidden" name="id" id="id">

    <!-- Agency Name -->
    <div class="col-md-6">
      <label for="agencyname" class="form-label">Agency Name</label>
      <input type="text" name="agencyname" id="agencyname" class="form-control" required>
    </div>

    <!-- Owner Name -->
    <div class="col-md-6">
      <label for="ownername" class="form-label">Owner Name</label>
      <input type="text" name="ownername" id="ownername" class="form-control" required>
    </div>

    <!-- Email -->
    <div class="col-md-6">
      <label for="email" class="form-label">Email</label>
      <input type="email" name="email" id="email" class="form-control">
    </div>

    <!-- Phone -->
    <div class="col-md-6">
      <label for="phone" class="form-label">Phone</label>
      <input type="tel" name="phone" id="phone" class="form-control" required 
             pattern="[0-9]{10}" maxlength="10" minlength="10" 
             oninput="this.value=this.value.replace(/[^0-9]/g,'');" 
             placeholder="Enter 10 digit mobile number">
    </div>
	 <div class="col-md-6">
      <label for="registration_no" class="form-label">Registration No.</label>
      <input type="text" name="registration_no" id="registration_no" class="form-control" required>
    </div> 
	 <!-- GST No -->
    <div class="col-md-6">
      <label for="gst_no" class="form-label">GST No.</label>
      <input type="text" name="gst_no" id="gst_no" class="form-control">
    </div>

    <!-- Address -->
    <div class="col-md-12">
      <label class="form-label">Address</label>
      <textarea name="address" id="address" class="form-control" rows="3" required></textarea>
    </div>

    <!-- City -->
    <div class="col-md-3">
      <label class="form-label">City</label>
      <input type="text" name="city" id="city" class="form-control" required>
    </div>

    <!-- State -->
    <div class="col-md-3">
      <label class="form-label">State</label>
      <input type="text" name="state" id="state" class="form-control" value="Gujarat">
    </div>

    <!-- Country -->
    <div class="col-md-3">
      <label class="form-label">Country</label>
      <input type="text" name="country" id="country" class="form-control" value="India">
    </div>

    <!-- Pincode -->
    <div class="col-md-3">
      <label class="form-label">Pincode</label>
      <input type="text" name="pincode" id="pincode" class="form-control">
    </div>

  
    <!-- Logo -->
    <div class="col-md-4">
      <label for="logo" class="form-label">Agency Logo</label>
      <input type="file" name="logo" id="logo" class="form-control" accept="image/*">
	  <input type="hidden" name="old_logo" id="old_logo">
    </div>
	<div class="col-md-2">
        
        
    <img id="logo_preview" src="" alt="Company Logo" style="max-height: 100px; display: none;">
  
      </div>
    <!-- Status -->
    <div class="col-md-6">
      <label class="form-label">Status</label>
      <select name="status" id="status" class="form-select">
        <option value="active" selected>Active</option>
        <option value="inactive">Inactive</option>
      </select>
    </div>

  </div>

  <div class="pt-6">
    <button type="submit" class="btn btn-primary me-4">Save Agency</button>
  </div>
</form>



		</div>
	</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script>
$(document).ready(function () {
   $(document).ready(function () {
    const form = $('#agencyForm');

    // ✅ Toastr default options (you can customize)
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000"
    };

    // ✅ Toast helper
    function showToast(type, message) {
        switch (type) {
            case 'success': toastr.success(message); break;
            case 'error': toastr.error(message); break;
            case 'info': toastr.info(message); break;
            case 'warning': toastr.warning(message); break;
        }
    }

    // ✅ Submit form
    form.on('submit', function (e) {
        e.preventDefault();

        let formData = new FormData(this);
        formData.append('action', 'saveAgency');

        $.ajax({
            url: 'controllers/AgencyController.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            
            success: function (res) {
                let result = {};
                try {
                    result = JSON.parse(res.trim());  // parse JSON safely
                } catch (err) {
                    console.error("Invalid JSON:", res);
                    showToast('error', 'Invalid server response!');
                    return;
                }

                if (result.status === 'success') {
                    if ($('#id').val()) {
                        // ✅ Update case
                        showToast('success', result.message || 'Agency updated successfully!');
                        setTimeout(() => {
                            window.location.href = 'agency_list.php';
                        }, 1500);
                    } else {
                        // ✅ Create case
                        showToast('success', result.message || 'Agency created successfully!');
                        form[0].reset();
                        $('#logo_preview').hide().attr('src', '');
                    }
                } else {
                    // ❌ Error case
                    showToast('error', result.message || 'Something went wrong!');
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", status, error);
                showToast('error', 'Network/Server error, please try again later.');
            }
        });
    });
});

    // If editing existing agency (update case)
    function getUrlParam(param) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(param);
    }

    const agencyId = getUrlParam('id');
if (agencyId) {
    $.getJSON('controllers/AgencyController.php', {
        action: 'getAgency',
        id: agencyId
    }, function (r) {
        $('#id').val(r.id);
        $('#agencyname').val(r.agencyname);
        $('#ownername').val(r.ownername);
        $('#email').val(r.email);
        $('#phone').val(r.phone);
        $('#registration_no').val(r.registration_no);
        $('#gst_no').val(r.gst_no);
        $('#address').val(r.address);
        $('#city').val(r.city);
        $('#state').val(r.state);
        $('#country').val(r.country);
        $('#pincode').val(r.pincode);
        $('#website').val(r.website);
        $('#status').val(r.status);

        if (r.logo) {
            $('#logo_preview').show().attr('src', r.logo);
            $('#old_logo').val(r.logo.split('/').pop()); // ✅ store only filename in hidden field
        }
    });
}

    // Preview logo before upload
    $('#logo').on('change', function () {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function (e) {
                $('#logo_preview').show().attr('src', e.target.result);
            };
            reader.readAsDataURL(file);
        }
    });

});
</script>


	<?php } ?>