<?php include( 'inc/template.php' ); ?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="index.php">Home</a>
			</li>
			<li class="breadcrumb-item"><a href="quotation_list.php">Quotation List</a>
			</li>
			<li class="breadcrumb-item">Quotation Details</li>
		</ol>
	</nav>
	<?php
	$quotation_id = isset( $_GET[ 'quotationid' ] ) ? intval( $_GET[ 'quotationid' ] ) : 0;
	$result = mysqli_query( $conn, "SELECT q.*, c.name AS customer_name, c.phone AS customer_phone, c.email AS customer_email, c.address AS customer_address, uq.name AS quotation_assigned_to_name, i.id AS inquiry_id,i.inquiry_date, i.source AS inquiry_source, i.destination AS inquiry_destination, i.travel_date AS inquiry_travel_date, i.nights AS inquiry_nights, 
    i.adults AS inquiry_adults, i.child AS inquiry_child, i.extrabed AS inquiry_extrabed, i.rooms AS inquiry_rooms, i.inquiry_type, i.hotel_type, i.transport_type AS inquiry_transport_type,i.with_flight,i.remarks AS inquiry_remarks,i.followup_status,i.last_followup_date AS inquiry_last_followup_date,i.followup_status,i.last_followup_update, ui.name AS inquiry_assigned_to_name FROM quotations q LEFT JOIN customers c ON q.customer_id = c.id LEFT JOIN users uq ON q.assigned_to = uq.id LEFT JOIN inquiries i ON q.inquiry_id = i.id LEFT JOIN users ui ON i.assigned_to = ui.id WHERE q.id = '$quotation_id'" );
	$row = mysqli_fetch_array( $result );
	?>

	<div class="row">
		<div class="col-xl-12 col-lg-5 col-md-5">
			<div class="accordion mt-3" id="accordionExample">
				<div class="card accordion-item active">
					<h2 class="accordion-header" id="headingOne">
                        <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#accordionOne" aria-expanded="true" aria-controls="accordionOne">
                          Quotation Details
                        </button>
                      </h2>
				

					<div id="accordionOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
						<div class="accordion-body">

							<?php $statusclass = strtolower($row['status']) == 'pending' ? 'bg-warning' :
     (strtolower($row['status']) == 'accepted' ? 'bg-success' : 
	 (strtolower($row['status']) == 'rejected' ? 'bg-danger' :
     (strtolower($row['status']) == 'closed' ? 'bg-secondary' : 'bg-info')));?>
							<div class="d-flex flex-wrap">
								<div class="me-5">
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Quotation Date:
										<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['inquiry_date']))); ?>
									</p>
									
									<p class="text-nowrap"><i class="ti ti-users ti-sm me-2 mt-n2"></i>Name:
										<?php echo htmlspecialchars(ucwords(strtolower($row['customer_name']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-map-pin ti-sm me-2 mt-n2"></i>Address:
										<?php echo htmlspecialchars(ucwords(strtolower($row['customer_address']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-phone-call ti-sm me-2 mt-n2"></i>Contact: +91
										<?php echo htmlspecialchars($row['customer_phone']); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-mail ti-sm me-2 mt-n2"></i>Email:
										<?php echo htmlspecialchars($row['customer_email']); ?>
									</p>
									
								</div>
								<div>
									<p class="text-nowrap"><i class="ti ti-search ti-sm me-2 mt-n2"></i>Quotation No.:
										<?php echo htmlspecialchars($row['quotation_no']); ?>
									</p>
									
									<p class="text-nowrap">
										<i class="ti ti-clock ti-sm me-2 mt-n2"></i>Followup Status:
										<span class="badge <?php echo $statusclass; ?> bg-glow">
											<?php echo htmlspecialchars(ucwords(strtolower($row['status']))); ?>
										</span>
									</p>
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Last Followup Date:
										<?php echo !empty($row['inquiry_last_followup_date']) ? date('d-m-Y', strtotime($row['inquiry_last_followup_date'])) : 'Not Followup'; ?>
									</p>
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Assign to:
										<?php echo htmlspecialchars(ucwords(strtolower($row['quotation_assigned_to_name']))); ?>
									</p>
								</div>
							</div>
							<h5 class="mt-4">Package Details</h5>
							<div class="table-responsive text-nowrap">
								<table class="table table-bordered table-sm">

									<tbody>
										<tr>
											<td>Package Name</td>
											<td>
												<?php echo htmlspecialchars(ucwords($row['package_name'])); ?>
											</td>
											<td>Destination</td>
											<td>
												<?php echo htmlspecialchars(ucwords($row['destination'])); ?>
											</td>
										</tr>
										
										<tr>
											<td>Travel Date</td>
											<td>
												<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
											</td>
											<td>No. of Nights</td>
											<td>
												<?php echo htmlspecialchars($row['nights']); ?>
											</td>
										</tr>
										<tr>
											
											<td>Total Rooms</td>
											<td>
												<?php echo htmlspecialchars($row['rooms']); ?>
											</td>
											<td>Guests (Adult/Child)</td>
											<td>
												<?php echo htmlspecialchars($row['adults']); ?> Adults /
												<?php echo htmlspecialchars($row['child']); ?>Child</td>
										</tr>
										<tr>
											
										</tr>
										<tr>
											<td>Extra Bed</td>
											<td>
												<?php echo htmlspecialchars($row['extrabed']); ?>
											</td>
											<td></td>
											<td>
												
											</td>
										</tr>
										

									</tbody>
								</table>
							</div>
							<h5 class="mt-4">Hotel Details</h5>
							<div class="table nsive text-nowrap">
								<?php
							$sql = "SELECT hotel_name, hotel_location, hotel_rooms, hotel_type, meal_plan 
									FROM quotation_hotels 
									WHERE quotation_id = ?";
							$stmt = $conn->prepare($sql);
							$stmt->bind_param("i", $quotation_id);
							$stmt->execute();
							$result = $stmt->get_result();
							?>

							<table class="table table-bordered table-sm">
								<thead>
									<tr>
										<th>Hotel Name</th>
										<th>Location</th>
										<th>Room</th>
										<th>Hotel Type</th>
										<th>Meal Plan</th>
									</tr>
								</thead>
								<tbody>
									<?php while ($hotelrow = $result->fetch_assoc()): ?>
										<tr>
											<td><?= htmlspecialchars(ucwords($hotelrow['hotel_name'])) ?></td>
											<td><?= htmlspecialchars(ucwords($hotelrow['hotel_location'])) ?></td>
											<td><?= htmlspecialchars($hotelrow['hotel_rooms']) ?></td>
											<td><?= htmlspecialchars(ucwords($hotelrow['hotel_type'])) ?></td>
											<td><?= htmlspecialchars(ucwords($hotelrow['meal_plan'])) ?></td>
										</tr>
									<?php endwhile; ?>
								</tbody>
							</table>

							</div>
							<h5 class="mt-4">Pricing Details</h5>
							<div class="table-responsive text-nowrap">
								<table class="table table-bordered table-sm">

									<tbody>
										<tr>
											<td>Adult Price (<?= htmlspecialchars($row['adults']) ?> × <?= htmlspecialchars($row['adult_price']) ?>)</td>
											<td><?= number_format((float)$row['adult_price'] * (int)$row['adults'], 2) ?></td>

										</tr>
										<?php if ($row['child'] > 0) { ?>
										<tr>
											<td>Child Price (<?= htmlspecialchars($row['child']) ?> × <?= htmlspecialchars($row['child_price']) ?>)</td>
											<td><?= number_format((float)$row['child_price'] * (int)$row['child'], 2) ?></td>
										</tr>
										<?php } ?>
										<?php if ($row['extrabed'] > 0) { ?>
										<tr>
											<td>Extra Bed (<?= htmlspecialchars($row['extrabed']) ?> × <?= htmlspecialchars($row['extra_bed_price']) ?>)</td>
											<td><?= number_format((float)$row['extra_bed_price'] * (int)$row['extrabed'], 2) ?></td>
										</tr>
										<?php } ?>
										<tr>
											<td><b>Sub Total</b></td>
											<td><b><?= number_format((float)$row['total_amount'], 2) ?></b></td>
										</tr>
										<?php if ($row['discount'] > 0) {?>
										<tr>
											<td>Discount (<?= htmlspecialchars($row['discount']) ?>%)</td>
											<td><?= number_format((float)$row['discount_amount'], 2) ?></td>
										</tr>
										<?php } ?>
										<?php if ($row['gst_included'] === 'yes') { ?>
										<tr>
											<td>GST (<?= htmlspecialchars($row['gst_rate']) ?>%)</td>
											<td><?= number_format((float)$row['gst_amount'], 2) ?></td>
										</tr>
										<?php }?>
										<tr>
											<td><b>Garnd Total</b></td>
											<td><b><?= number_format((float)$row['grand_total'], 2) ?></b></td>
										</tr>
										
									</tbody>
								</table>
							</div>
						</div>

						<div class="accordion-body">



							<h6>Description</h6>
							<p class="mb-3">
								<?php echo ucwords($row['remarks']); ?>
							</p>
							<h6>Inclusions</h6>
							<p class="mb-3">
								<?php echo ucwords($row['inclusions']); ?>
							</p>
							<h6>Exclusions</h6>
							<p class="mb-3">
								<?php echo ucwords($row['exclusions']); ?>
							</p>

						</div>

					</div>
				</div>
				<div class="card accordion-item">
					<h2 class="accordion-header" id="headingTwo">
                        <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionTwo" aria-expanded="false" aria-controls="accordionTwo">
                           Inquiry Details
                        </button>
                      </h2>
				
					<div id="accordionTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
						<div class="accordion-body">

							<?php $statusclass = strtolower($row['followup_status']) == 'pending' ? 'bg-warning' :
     (strtolower($row['followup_status']) == 'done' ? 'bg-success' :
     (strtolower($row['followup_status']) == 'closed' ? 'bg-secondary' : 'bg-info'));?>
							<div class="d-flex flex-wrap">
								<div class="me-5">
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Inquiry Date:
										<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['inquiry_date']))); ?>
									</p>
									<p class="text-nowrap">
										<i class="ti ti-location ti-sm me-2 mt-n2"></i>Travel Destination :
										<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_destination']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-calendar-check ti-sm me-2 mt-n2"></i>Travel Date:
										<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['inquiry_travel_date']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-man ti-sm me-2 mt-n2"></i>Adults:
										<?php echo htmlspecialchars($row['inquiry_adults']); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-mood-boy ti-sm me-2 mt-n2"></i>Child:
										<?php echo htmlspecialchars($row['inquiry_child']); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-baby-carriage ti-sm me-2 mt-n2"></i>Extra Bed:
										<?php echo htmlspecialchars($row['inquiry_extrabed']); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-phone-call ti-sm me-2 mt-n2"></i>No. of Nights:
										<?php echo htmlspecialchars($row['inquiry_nights']); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-bed ti-sm me-2 mt-n2"></i>No. of Rooms:
										<?php echo htmlspecialchars($row['inquiry_rooms']); ?>
									</p>

								</div>
								<div>
									<p class="text-nowrap"><i class="ti ti-building-skyscraper ti-sm me-2 mt-n2"></i>Hotel Type:
										<?php echo htmlspecialchars(ucwords(strtolower($row['hotel_type']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-search ti-sm me-2 mt-n2"></i>Source:
										<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_source']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-beach ti-sm me-2 mt-n2"></i>Inquiry Type:
										<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_type']))); ?>
									</p>
									<p class="text-nowrap">
										<i class="ti ti-clock ti-sm me-2 mt-n2"></i>Followup Status:
										<span class="badge <?php echo $statusclass; ?> bg-glow">
											<?php echo htmlspecialchars(ucwords(strtolower($row['followup_status']))); ?>
										</span>
									</p>
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Last Followup Date:
										<?php echo !empty($row['inquiry_last_followup_date']) ? date('d-m-Y', strtotime($row['inquiry_last_followup_date'])) : 'Not Followup'; ?>
									</p>
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Assign to:
										<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_assigned_to_name']))); ?>
									</p>
								</div>
							</div>

							<h6>Remarks</h6>
							<p class="mb-3">
								<?php echo htmlspecialchars(ucwords($row['inquiry_remarks'])); ?>
							</p>
							<h6>Last Followup Update</h6>
							<p class="mb-3">
								<?php echo htmlspecialchars(ucwords($row['last_followup_update'])); ?>
							</p>

						</div>

					</div>
				</div>

			</div>

		</div>

	</div>
</div>
<?php include('inc/footer.php');?>