<?php include( 'inc/template.php' );?>
	<div class="container-fluid flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="inquiry_list.php">Inquiry List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Package' : 'Package Add'; ?></li>
    </ol>
</nav>
	
    <link rel="stylesheet" href="assets/vendor/libs/quill/editor.css" />
		<div class="card mb-4">

			<form class="card-body" method="post" enctype="multipart/form-data">
    <div class="row g-3">

        <div class="col-md-6">
            <label class="form-label" for="package_name">Package Name</label>
            <input type="text" id="package_name" name="package_name" class="form-control" required />
        </div>

        <div class="col-md-6">
            <label class="form-label" for="destination">Destination</label>
            <input type="text" id="destination" name="destination" class="form-control" required />
        </div>

        <div class="col-md-2">
            <label class="form-label" for="days">Days</label>
            <input type="number" id="days" name="days" class="form-control" min="1" required />
        </div>

        <div class="col-md-2">
            <label class="form-label" for="nights">Nights</label>
            <input type="number" id="nights" name="nights" class="form-control" min="1" required />
        </div>

        <div class="col-md-6">
            <label class="form-label" for="price">Price (per person ₹)</label>
            <input type="number" id="price" name="price" class="form-control" min="0" step="0.01" required />
        </div>
<!-- Description -->
<div class="col-md-12">
  <label class="form-label">Description</label>
  <div id="editor_description" class="quill-editor"></div>
  <input type="hidden" name="description" id="desc_input">
</div>

<!-- Inclusions -->
<div class="col-md-12">
  <label class="form-label">Inclusions</label>
  <div id="editor_inclusions" class="quill-editor"></div>
  <input type="hidden" name="inclusions" id="incl_input">
</div>

<!-- Exclusions -->
<div class="col-md-12">
  <label class="form-label">Exclusions</label>
  <div id="editor_exclusions" class="quill-editor"></div>
  <input type="hidden" name="exclusions" id="excl_input">
</div>

    </div>

    <div class="pt-4">
        <input type="hidden" id="upd" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
        <input type="hidden" name="id" id="id">
        <input type="hidden" name="action" id="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
        <button type="submit" class="btn btn-primary me-2"><?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?></button>
        <button type="reset" class="btn btn-label-secondary">Cancel</button>
    </div>
</form>



		</div>
	</div>

<!-- Quill JS -->
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<script>
  const fullToolbar = [
    [{ font: [] }, { size: [] }],
    ['bold', 'italic', 'underline', 'strike'],
    [{ color: [] }, { background: [] }],
    [{ script: 'super' }, { script: 'sub' }],
    [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
    [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
    [{ direction: 'rtl' }],
    ['link', 'image', 'video', 'formula'],
    ['clean']
  ];

  // Initialize each editor separately
  const editorDescription = new Quill('#editor_description', {
    bounds: '#editor_description',
    placeholder: 'Type Description...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  const editorInclusions = new Quill('#editor_inclusions', {
    bounds: '#editor_inclusions',
    placeholder: 'Type Inclusions...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  const editorExclusions = new Quill('#editor_exclusions', {
    bounds: '#editor_exclusions',
    placeholder: 'Type Exclusions...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  // Sync editor content to hidden fields before submit
  document.getElementById('quotationForm').addEventListener('submit', function () {
    document.getElementById('desc_input').value = editorDescription.root.innerHTML;
    document.getElementById('incl_input').value = editorInclusions.root.innerHTML;
    document.getElementById('excl_input').value = editorExclusions.root.innerHTML;
  });
</script>
<script>
$(document).ready(function () {
    // Initialize Quill editors
   // const quillDesc = new Quill('#editor_description', { theme: 'snow' });
   // const quillIncl = new Quill('#editor_inclusions', { theme: 'snow' });
    //const quillExcl = new Quill('#editor_exclusions', { theme: 'snow' });

    // Submit form
    $('form.card-body').on('submit', function (event) {
        event.preventDefault();

        // Set Quill editor values to hidden inputs
//        $('#desc_input').val(quillDesc.root.innerHTML);
//        $('#incl_input').val(quillIncl.root.innerHTML);
//        $('#excl_input').val(quillExcl.root.innerHTML);

        let formData = new FormData(this);

        // Basic validation
        if (!formData.get("package_name") || !formData.get("destination") || !formData.get("price")) {
            toastr.error("Package Name, Destination, and Price are required.");
            return;
        }

        $.ajax({
            url: 'controller/PackagesController.php',
            method: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function (response) {
                if (response.status === 'success') {
                    toastr.success(response.message);
                    setTimeout(() => window.location.href = 'package_list.php', 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function (xhr) {
                toastr.error('An error occurred while submitting the form.');
                console.error('AJAX error:', xhr.responseText);
            }
        });
    });

    // Load existing data if updating
    const upd = $('#upd').val();
    if (upd) {
        $.ajax({
            url: 'controller/PackagesController.php',
            method: 'POST',
            data: { id: upd, action: 'Select' },
            dataType: 'json',
            success: function (data) {
                $('#package_name').val(data.package_name);
                $('#destination').val(data.destination);
                $('#days').val(data.days);
                $('#nights').val(data.nights);
                $('#price').val(data.price);
                quillDesc.root.innerHTML = data.description || '';
                quillIncl.root.innerHTML = data.inclusions || '';
                quillExcl.root.innerHTML = data.exclusions || '';

                $('#id').val(data.id);
                $('#action').val('Update');
            },
            error: function () {
                toastr.error('Failed to load package data.');
            }
        });
    }
});
</script>

<?php include('inc/footer.php');?>