<?php include('inc/template.php');?>
<div class="container-fluid flex-grow-1 container-p-y">
<?php include('inquiry_header.php');?>
<div class="row mb-4">
<div class="col-xl-4 col-lg-6 col-md-6">
<div class="card mb-4">
<div class="card-body">
<form id="followupForm">
 <input type="hidden" id="inquiry_id" name="inquiry_id" value="<?php echo $inquiry_id; ?>" />
  <input type="hidden" id="user_id" name="user_id" value="<?php echo $adminId; ?>" />
  <div class="mb-3">
    <label class="form-label" for="followup_mode">Followup Mode</label>
    <select class="form-select" id="followup_mode" name="followup_mode" required>
      <option value="">Select Mode</option>
      <option value="call">Call</option>
      <option value="email">Email</option>
      <option value="visit">Visit</option>
      <option value="whatsapp">WhatsApp</option>
      <option value="sms">SMS</option>
    </select>
  </div>

  <div class="mb-3">
    <label class="form-label" for="followup_remarks">Followup Remarks</label>
    <textarea class="form-control" rows="5" id="followup_remarks" name="followup_remarks" placeholder="Enter follow-up details here..." required></textarea>

  </div>

  <div class="mb-3">
    <label class="form-label" for="followup_status">Followup Status</label>
    <select class="form-select" id="followup_status" name="followup_status" required>
      <option value="">Select Status</option>
      <option value="pending">Pending</option>
      <option value="done">Done</option>
      <option value="rescheduled">Rescheduled</option>
	  <option value="cancelled">Cancelled</option>
<!--      <option value="closed">Closed</option>-->
    </select>
  </div>

  <div class="mb-3 d-none" id="reschedule_date_wrapper">
    <label class="form-label" for="reschedule_date">Rescheduled Date</label>
    <input type="date" class="form-control" id="reschedule_date" name="reschedule_date" />
  </div>

  <button type="submit" class="btn btn-primary">Submit</button>
</form>

                    </div>
                  </div>
        </div>

        <!-- Users Table -->
        <div class="col-xl-8 col-lg-6 col-md-6">
			<div id="followupAlert" class="alert d-none" role="alert"></div>
            <div class="card">
                <div class="card-datatable table-responsive pt-0">
                    <table class="datatables-ajax table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th>Followup Date</th>
                                <th>Followup Mode</th>
                                <th>Remarks</th>
                                <th>Status</th>
								<th>Reschedule Date</th>
                                <th>Followed by</th>
                            </tr>
                        </thead>
                        <tbody id="followup_table_body">
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>-->
<script>
$(document).ready(function () {
  let followupTable;

  $('#followup_status').on('change', function () {
    const status = $(this).val();
    $('#reschedule_date_wrapper').toggleClass('d-none', status !== 'rescheduled');
    $('#reschedule_date').prop('required', status === 'rescheduled');
  });

  function loadFollowups(inquiryId) {
    $.post('controller/InquiryFollowupController.php', {
      action: 'fetch',
      inquiry_id: inquiryId
    }, function (response) {
      let html = '';

      if (response.length > 0) {
        response.forEach(row => {
          html += `<tr>
            <td>${row.followup_date}</td>
            <td>${row.followup_mode}</td>
            <td>${row.remarks}</td>
            <td>${row.status}</td>
            <td>${row.next_followup_date}</td>
            <td>${row.followed_by_name}</td>
          </tr>`;
        });
      } else {
        html = `<tr><td colspan="6" class="text-center">No follow-ups found.</td></tr>`;
      }

      $('#followup_table_body').html(html);

      // Handle both first-time and subsequent loads
      if ($.fn.DataTable.isDataTable('.datatables-ajax')) {
        followupTable.clear().destroy();
      }

      followupTable = $('.datatables-ajax').DataTable({
        processing: true,
        searching: false,
        paging: false,
        info: false,
        order: [[0, 'desc']]
      });
    }, 'json');
  }

  $('#followupForm').on('submit', function (e) {
    e.preventDefault();

    $.ajax({
      type: 'POST',
      url: 'controller/InquiryFollowupController.php',
      data: $(this).serialize() + '&action=insert',
      dataType: 'json',
      success: function (res) {
        if (res.success) {
          toastr.success(res.message);
          $('#followupForm')[0].reset();
          $('#reschedule_date_wrapper').addClass('d-none');
          setTimeout(() => {
            loadFollowups($('#inquiry_id').val()); // ensure DOM updated before init
          }, 100);
        } else {
          toastr.error(res.message);
        }
      }
    });
  });

  // Initial load
  setTimeout(() => {
    loadFollowups($('#inquiry_id').val());
  }, 100);
});

</script>


<?php include('inc/footer.php');?>