<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Something went wrong'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'Create';
    $id = $_POST['id'] ?? null;

    // Sanitize inputs
    $package_name = trim($_POST['package_name'] ?? '');
    $destination = trim($_POST['destination'] ?? '');
    $days = (int)($_POST['days'] ?? 0);
    $nights = (int)($_POST['nights'] ?? 0);
    $price = number_format((float)($_POST['price'] ?? 0), 2, '.', '');
    $description = $_POST['description'] ?? '';
    $inclusions = $_POST['inclusions'] ?? '';
    $exclusions = $_POST['exclusions'] ?? '';
    $status = 'active';

    // Validate required fields
    if (empty($package_name) || empty($destination) || $price <= 0) {
        $response['message'] = 'Package Name, Destination, and valid Price are required.';
        echo json_encode($response);
        exit;
    }

    // Create
    if ($action === 'Create') {
        $stmt = $conn->prepare("INSERT INTO packages (package_name, destination, start_date, end_date, days, nights, price_per_person, description, inclusions, exclusions, status, created_at) VALUES (?, ?, NULL, NULL, ?, ?, ?, ?, ?, ?, ?, NOW())");
        $stmt->bind_param("ssiisssss", $package_name, $destination, $days, $nights, $price, $description, $inclusions, $exclusions, $status);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package created successfully'];
        } else {
            $response['message'] = 'Failed to create package.';
        }
    }

    // Update
    if ($action === 'Update' && $id) {
        $stmt = $conn->prepare("UPDATE packages SET package_name = ?, destination = ?, days = ?, nights = ?, price_per_person = ?, description = ?, inclusions = ?, exclusions = ?,  updated_at = NOW() WHERE id = ?");
        $stmt->bind_param("ssiissssi", $package_name, $destination, $days, $nights, $price, $description, $inclusions, $exclusions, $status, $id);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package updated successfully'];
        } else {
            $response['message'] = 'Failed to update package.';
        }
    }

    // Select
    if ($action === 'Select' && $id) {
        $stmt = $conn->prepare("SELECT * FROM packages WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $package = $result->fetch_assoc();

        if ($package) {
            $response = ['status' => 'success', 'data' => $package];
        } else {
            $response['message'] = 'Package not found';
        }
        echo json_encode($response);
        exit;
    }

    // Delete
    if ($action === 'Delete' && $id) {
        $stmt = $conn->prepare("DELETE FROM packages WHERE id = ?");
        $stmt->bind_param("i", $id);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package deleted successfully'];
        } else {
            $response['message'] = 'Failed to delete package.';
        }
    }
}

echo json_encode($response);
?>
